/***************************************************************************
                          kurs.h  -  description                              
                             -------------------                                         
    begin                : Sat Apr 29 18:26:54 MEST 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KURS_H
#define KURS_H

#include <vector>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <wx/wx.h>

#include "lektion.h"
class Lektion;

// Exception fr Benutzerabruch
class Abbruch{};

// Kriterien fr einzelnen Lektionen wie z.B. Fehlerzahl und Zeit

class LKrit
{
 private:
  int m_nummer;
  time_t  m_zeit;
  int m_promille;
 public:
  LKrit(int nummer, int zeit, int promille);
  inline int GetNummer() {return m_nummer;};
  wxString GetZeit();
  inline int GetUnixZeit() {return m_zeit;};
  inline int GetPromille() {return m_promille;};
  bool SetNummer(int nummer);
  bool SetZeit(int zeit);
  bool SetPromille(int promille);
  
};

// Klasse fr das Speichern von Informationen zu Listen
class LEntry
{
 private:
   int m_anschlaege;
   int m_fehler;
   int m_promille;
   int m_richtig;
   int m_apm;
   int m_lnummer;
   int m_zeit;
 public:
   LEntry();
   LEntry(int anschlaege, int fehler, int promille, int richtig, int apm, int zeit);
   ~LEntry();
   inline int GetAnschlaege() {return m_anschlaege;};
   inline int GetFehler() {return m_fehler;};
   inline int GetPromille() {return m_promille;};
   inline int GetRichtig() {return m_richtig;};
   inline int GetApM() {return m_apm;};
   inline int GetZeit() {return m_zeit;};
   bool SetAnschlaege(int anschlaege);
   bool SetFehler(int fehler);
   bool SetPromille(int promille);
   bool SetRichtig(int richtig);
   bool SetApM(int apm);
   bool SetZeit(int zeit);
};

class Kurs 
{
 private:
  wxWindow* m_parent;
  Lektion* m_lektion;
  wxString m_name;
  int m_kn;
  wxString m_key;

  vector<LKrit> m_kriterien;
  vector<LEntry> m_results;

   int  akt_krit;
   bool KursBeginnen();
   bool KursLaden();
   bool KursSpeichern();
   bool KursEinleitung();
   bool KursEnde();
   bool LektionSpeichern();
 public:
  Kurs(wxWindow* parent, bool neu=true);
  ~Kurs();
  bool KursAbbrechen();
  bool NaechsteLektion();
  bool Langzeitstatistik();
  wxString GetLimits();
 
};
#endif // ifndef KURS_H
