#   Copyright (C) 1987-2001 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Tue Feb  6 15:14:21 2001
#

proc resetTechList {} {
  global gatesetech_w

  set tech_w .sbar.tech

  set L [gat_getTechList]
  destroy $tech_w.v
  eval "tk_optionMenu $tech_w.v tkg_defaultTech $L"  
  $tech_w.v configure -width 12
  pack $tech_w.v -anchor w -padx 3 -pady 3

  set menu_list [list .pop_MIgate.settech .pop_gate.settech .pop_multi.settech $gatesetech_w]

  foreach m $menu_list {
    catch {
      destroy $m
      menu $m  -tearoff 0 
      foreach mi $L {
	$m add command -label $mi -command "gat_setTech $mi"
      }
    }
  }
}

frame .tbar.f
button .tbar.f.new -bitmap "@$bd/file_new.b" -command tkg_new -takefocus 0
button .tbar.f.open -bitmap "@$bd/file_open.b" -command tkg_load -takefocus 0
button .tbar.f.save -bitmap "@$bd/file_save.b" -command tkg_saveCurrent -takefocus 0
button .tbar.f.print -bitmap "@$bd/file_print.b" -command tkg_printDlg -takefocus 0
pack .tbar.f.new .tbar.f.open .tbar.f.save .tbar.f.print -side left -pady 5

helpon .tbar.f.new [m ho.new]
helpon .tbar.f.open [m ho.open]
helpon .tbar.f.save [m ho.save]
helpon .tbar.f.print [m ho.print]

frame .tbar.m
radiobutton .tbar.m.mov -bitmap "@$bd/mov_curs.b" -indicatoron false -variable mode -value 1 -takefocus 0
radiobutton .tbar.m.del -bitmap "@$bd/del_curs.b" -indicatoron false -variable mode -value 3 -takefocus 0
radiobutton .tbar.m.cut -bitmap "@$bd/cut_curs.b" -indicatoron false -variable mode -value 0 -takefocus 0
radiobutton .tbar.m.inv -bitmap "@$bd/inv_curs.b" -indicatoron false -variable mode -value 2 -takefocus 0
radiobutton .tbar.m.siz -bitmap "@$bd/size_curs.b" -indicatoron false -variable mode -value 9 -takefocus 0
pack .tbar.m.mov .tbar.m.del .tbar.m.cut .tbar.m.inv .tbar.m.siz -side left -pady 5

helpon .tbar.m.mov [m ho.move]

helpon .tbar.m.del [m ho.delgat]
helpon .tbar.m.cut [m ho.cutw]
helpon .tbar.m.inv [m ho.inv]
helpon .tbar.m.siz [m ho.bitw]

frame .tbar.b
button .tbar.b.open -bitmap "@$bd/blk_open.b" -command gat_openBox -takefocus 0
button .tbar.b.close -bitmap "@$bd/blk_close.b" -command gat_closeBox -takefocus 0
pack .tbar.b.open .tbar.b.close  -side left -pady 5

helpon .tbar.b.open [m ho.modopen]
helpon .tbar.b.close [m ho.modclose]

frame .tbar.z
button .tbar.z.zoomin -bitmap "@$bd/zoom_in.b" -command { gat_zoom 1 } -takefocus 0
button .tbar.z.zoomout -bitmap "@$bd/zoom_out.b" -command { gat_zoom -1 } -takefocus 0 -state disabled
pack .tbar.z.zoomin .tbar.z.zoomout  -side left -pady 5

helpon .tbar.z.zoomin [m zoomin]
helpon .tbar.z.zoomout [m zoomout]

frame .tbar.s
button .tbar.s.simgo -bitmap "@$bd/sim_go.b" -command tkg_simRun -takefocus 0
button .tbar.s.simpause -bitmap "@$bd/sim_pause.b" -command tkg_simStop -takefocus 0
button .tbar.s.simstep -bitmap "@$bd/sim_step.b" -command tkg_simStep -takefocus 0
button .tbar.s.simclock -bitmap "@$bd/sim_clock.b" -command tkg_simCycle -takefocus 0
button .tbar.s.simstop -bitmap "@$bd/sim_stop.b" -command { gat_setMajorMode edit } -takefocus 0
pack .tbar.s.simgo .tbar.s.simpause .tbar.s.simstep .tbar.s.simclock .tbar.s.simstop -side left -pady 5

helpon .tbar.s.simgo [m ho.simgo]
helpon .tbar.s.simpause [m ho.simpause]
helpon .tbar.s.simstep [m ho.simstep]
helpon .tbar.s.simclock [m ho.simclock]
helpon .tbar.s.simstop [m ho.simstop]

frame .tbar.sc
button .tbar.sc.simbreak -bitmap "@$bd/sim_break.b" -takefocus 0 -command tkg_editBreakpoints
button .tbar.sc.simscript -bitmap "@$bd/sim_script.b" -takefocus 0 -command tkg_doSimScript
button .tbar.sc.simload -bitmap "@$bd/sim_load.b" -takefocus 0 -command tkg_simLoadMem
button .tbar.sc.simdump -bitmap "@$bd/sim_dump.b" -takefocus 0 -command tkg_simDumpMem
pack .tbar.sc.simbreak .tbar.sc.simscript .tbar.sc.simload .tbar.sc.simdump -side left -pady 5

frame .tbar.anal
button .tbar.anal.anal -bitmap "@$bd/analyze.b" -takefocus 0 -command tkg_cpathAnal
pack .tbar.anal.anal -side left -pady 5

helpon .tbar.anal.anal [m ho.cpathanal]

#frame .tbar.tech
#label .tbar.tech.l -text "[m b.tech]:"
#eval "tk_optionMenu .tbar.tech.v tkg_defaultTech [gat_getTechList]"
#pack .tbar.tech.l .tbar.tech.v -anchor w

helpon .tbar.sc.simbreak [m ho.simbreak]
helpon .tbar.sc.simscript [m ho.simexec]
helpon .tbar.sc.simload [m ho.simload]
helpon .tbar.sc.simdump [m ho.simdump]
#helpon .tbar.tech [m ho.deftech]

#pack .tbar.f .tbar.m .tbar.b .tbar.z .tbar.s .tbar.sc .tbar.anal .tbar.tech -side left -padx 5
pack .tbar.f .tbar.m .tbar.b .tbar.z .tbar.s .tbar.sc .tbar.anal -side left -padx 5
#grid .tbar.f -row 0 -column 0 -sticky w -padx 5
#grid .tbar.m -row 0 -column 1 -sticky w -padx 5
#grid .tbar.b -row 0 -column 2 -sticky w -padx 5
#grid .tbar.sc -row 1 -column 0 -sticky w -padx 5
#grid .tbar.s -row 1 -column 1 -sticky w -padx 5
#grid .tbar.z -row 1 -column 2 -sticky w -padx 5
#grid .tbar.anal -row 1 -column 3 -sticky w -padx 5
