/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Thu Jun 22 20:35:58 2000
****************************************************************************/
#include "tkgate.h"

#define ARSHIFT_IN 0
#define ARSHIFT_OUT 1
#define ARSHIFT_SHIFT 2

static iconDimensions arshift_iconDims[] = {
  {0, 21, 75, 20, 36, 9},
  {76, 0, 20, 75, 10, 37},
  {0,  0, 75, 20, 36, 9},
  {97, 0, 20, 75, 10, 37},
};
static int arshift_iconBoldOffset = 76;


struct locate arshifter_in_loc[] = {
	{0,-10,0,-10,D_UP},
	{-11,0,-11,0,D_LEFT},
	{0,11,0,11,D_DOWN},
	{10,0,10,0,D_RIGHT}};

struct locate arshifter_out_loc[] = {
	{0,11,0,11,D_DOWN},
	{10,0,10,0,D_RIGHT},
	{0,-10,0,-10,D_UP},
	{-11,0,-11,0,D_LEFT}};

struct locate arshifter_shift_loc[] = {
	{-37,0,-37,0,D_LEFT},
	{0,38,0,38,D_DOWN},
	{39,0,39,0,D_RIGHT},
	{0,-38,0,-38,D_UP}};

static char *psArshifter[] = {
  "%",
  "% A Arshifter",
  "%",
  "/psarshift {",
  "  [[0 .5][-.5 .5][2 0.5][0 -.5]] adjstartgate",
  "  -31 -10.5 moveto",
  "  -37.5 -5 lineto",
  "  -37.5 4 lineto",
  "  -31 10.5 lineto",
  "  31 10.5 lineto",
  "  37.5 4 lineto",
  "  37.5 -5 lineto",
  "  31 -10.5 lineto",
  "  closepath stroke",
  "  -7 2 moveto",
  "  3 2 lineto",
  "  3 5 lineto",
  "  9 0 lineto",
  "  3 -5 lineto",
  "  3 -2 lineto",
  "  -7 -2 lineto",
  "  closepath fill",
  "  -9 2 moveto -11 2 lineto",
  "  -11 -2 lineto -9 -2 lineto",
  "  closepath fill",
  "  -9 3 moveto",
  "  -9 6 lineto",
  "  -7 6 lineto",
  "",
  "  -7 4 lineto",
  "  -8 4 lineto",
  "  -6 3 lineto",
  "  -4 4 lineto",
  "  -5 4 lineto",
  "",
  "  -5 8 lineto",
  "  -11 8 lineto",
  "  -11 3 lineto",
  "  closepath fill",
  "  grestore",
  "} def",
  0
};

GGateInfo gate_arshifter_info = {
  0,
  "Arshifter",
  "arshift",0x0,
  "psarshift",psArshifter,

  {{"S A",	{"gmalu",0},		{"gmarshift",0,"shift",300},	"gat_make arshift"},
   0},

  arshift_iconDims,

  3,{{"I",IN,8,1,arshifter_in_loc},
       {"Z",OUT,8,1,arshifter_out_loc},
       {"S",IN,3,1,arshifter_shift_loc}},
  {{12,-12,LJ},{12,-12,LJ},{12,-12,LJ},{12,-12,LJ}},
  {1},
  
  {"S-Z","I-Z",0},

  Generic_Make,
  Generic_Init,
  Generic_Delete,
  Generic_GetExtents,
  Generic_HitDistance,
  Generic_Draw,
  Generic_Move,
  Generic_Replicate,
  Err_AddInput,
  Err_AddOutput,
  Err_AddInOut,
  Err_ChangePin,
  Nop_SimStateFunc,
  Nop_SimHitFunc,
  Generic_PSWrite,
  Generic_EditProps,
  Generic_VerSave
};

void init_arshift()
{
  Pixmap P;

  P = Pixmap_registerFromFile("arshift","arshift.b");
  gateinfo_iconInit(&gate_arshifter_info,P,arshift_iconDims,arshift_iconBoldOffset);
  RegisterGate(&gate_arshifter_info);
}
