/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Thu Jan 31 09:22:06 2002
****************************************************************************/
#include "tkgate.h"

#define TCLSCRIPT "scripts/tkgate.tcl"

int want_exit = 0;

char *print_file = 0;
char *print_printer = 0;


extern int blockmovestyle;
extern int smoothScroll;
extern int flashCPath;

int debugContinuousVerify = 0;
int debugSimInterface = 0;
int sync_Xserver = 0;

int noviceMode = 1;
int discardChanges = 0;
int useExtBars = 1;
int doBackupOnSave = 0;
int wantCheckpoint = 0;
int checkpointenabled = 0;

SHash *message_table;


/*
 * Global variables used in main/Tk_AppInit
 */
static  char **loadList;
static  int numLoads = 0;
static  char **libLoadList;
static  int numLibLoads = 0;
static  int quiet = 0;
static  int start_sim = 0;
static  char *sim_script = 0;
static  int did_load = 0;
static  int debug = 0;
extern int guiActive;

char tkgate_homedir[STRMAX];
char *tkgate_exampledir;
char *tkgate_tutorialdir;

static void catchInterrupt(int s)
{
  switch (tkgate_currentMode()) {
  case MM_EDIT :
    want_exit = 0;
    DoTcl("tkg_exit");
    break;
  case MM_ANALYZE :
    want_exit = 1;
    break;
  case MM_SIMULATE :
    want_exit = 1;
    ReqScopeRedisplay();
    break;
  }
}

static int testHome(char *path)
{
  char buf[STRMAX];
  FILE *f;

  sprintf(buf,"%s/sitename.txt",path);

  f = fopen(buf,"r");
  if (!f) return 0;
  fclose(f);
  return 1;
}

static void tkg_findGateHome()
{
  char *p;

  *tkgate_homedir = 0;
  if ((p = getenv("TKGATE_HOME"))) strcpy(tkgate_homedir,p);

  if (!testHome(tkgate_homedir)) {
    strcpy(tkgate_homedir,TKGATE_HOMEDIR);
    if (!testHome(tkgate_homedir)) {
      strcpy(tkgate_homedir,TKGATE_SECONDARYHOME);
      if (!testHome(tkgate_homedir)) {
	printf("\n");
	printf("I could not locate the tkgate home directory.  I tried looking in:\n");
	if (p) printf("  %s (environment variable)\n",p);
	printf("  %s  (primary location)\n",TKGATE_HOMEDIR);
	printf("  %s  (secondary location)\n",TKGATE_SECONDARYHOME);
	printf("\n");
	printf("Try setting the environment variable TKGATE_HOME.\n");
	exit(1);
      }
    }
  }
}

static void PrintCopyright()
{
  printf("TKGate %s - %s (compiled %s)\n",VERSIONS[0].name,TKGATE_DESCRIPTION,__DATE__);
  printf("%s\n",TKGATE_COPYRIGHT);
  printf("  TKGate comes with ABSOLUTELY NO WARRANTY;  see 'Help...License' menu\n");
  printf("  for license and warranty details.  Report problems to %s\n",TKGATE_MAILCONTACT);
  fflush(stdout);
}

void linkvars(Tcl_Interp *tcl)
{
  extern int stepsize;
  static char randomstate[128];

  initstate(getpid() | time(0),randomstate,128);

  XGate_setOrigin(0,0);

  Tcl_SetVar(tcl,"tkg_progVer",VERSIONS[0].name,TCL_GLOBAL_ONLY);
  Tcl_SetVar(tcl,"tkg_description",TKGATE_DESCRIPTION,TCL_GLOBAL_ONLY);
  Tcl_SetVar(tcl,"tkg_copyright",TKGATE_COPYRIGHT,TCL_GLOBAL_ONLY);
  Tcl_SetVar(tcl,"tkg_mailContact",TKGATE_MAILCONTACT,TCL_GLOBAL_ONLY);
  Tcl_SetVar(tcl,"tkg_homepage",TKGATE_HOMEPAGE,TCL_GLOBAL_ONLY);
  Tcl_SetVar(tcl,"tkg_localdoc",TKGATE_LOCALDOC,TCL_GLOBAL_ONLY);

  Tcl_LinkVar(tcl,"tkg_errorLogFile",(char*)&tkg_errorLogFile,TCL_LINK_STRING);
  Tcl_LinkVar(tcl,"tkg_siteName",(char*)&tkg_siteName,TCL_LINK_STRING);
  Tcl_LinkVar(tcl,"tkg_defaultTech",(char*)&tkg_defaultTech,TCL_LINK_STRING);

  Tcl_LinkVar(tcl,"tkg_contVerify",(char*)&debugContinuousVerify,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_simStepSize",(char*)&stepsize,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_checkpointEnabled",(char*)&checkpointenabled,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_wantCheckpoint",(char*)&wantCheckpoint,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_simDebugInterface",(char*)&debugSimInterface,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_baderMode",(char*)&baderp,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_trekMode",(char*)&startrekp,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_batMode",(char*)&batp,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"simOn",(char*)&XGate.simulator.active,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_modifiedFlag",(char*)&changedp,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_regionUpdate",(char*)&regionUpdate,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_blockMoveStyle",(char*)&blockmovestyle,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_noviceMode",(char*)&noviceMode,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_discardChanges",(char*)&discardChanges,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_useExtBars",(char*)&useExtBars,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_doBackupOnSave",(char*)&doBackupOnSave,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_smoothScroll",(char*)&smoothScroll,TCL_LINK_INT);
  Tcl_LinkVar(tcl,"tkg_flashCPath",(char*)&flashCPath,TCL_LINK_INT);
}

void readLongMsg(FILE *f,char *msg,int n)
{
  char *p;
  int l;

  p = msg;
  while (fgets(p,n,f)) {
    l = strlen(p);
    if (strcmp(p,"-end-\n") == 0) {
      if (p != msg)
	p[-1] = 0;
      else
	*p = 0;
      break;
    }
    p += l;
    n -= l;
    if (n <= 0) {
      printf("Fatal Error: Message too long.\n");
      exit(1);
      break;
    }
  }
}

/*
 * Determine which locale we are going to run under and read the appropriate
 * message files.  If the locale is not "en" (English), then the both the
 * locale specific message file and the English message file is read.  If there
 * are any messages in the English message file that are not in the locale 
 * specific message file, a warning is printed and the English message
 * is used in place of the missing locale-specific message.
 */
void localization_Setup(Tcl_Interp *tcl)
{
  SHash *H = new_SHash();
  char fileName[1024],buf[1024],tag[1024],msg[8096];
  char msg_lang[1024];
  FILE *f;
  int en_backup = 0;
  char *lang = 0;

  XGate.japaneseMode = 0;
  
  lang = getenv("LANG");
  if (!lang || !*lang)
    lang = "en";

  strncpy(msg_lang,lang,1024);

  if (strcmp(msg_lang,"ASCII") == 0 || strcmp(msg_lang,"US-ASCII") == 0)
    strcpy(msg_lang,"en");

  if (strncmp(lang,"ja",2) == 0 || strncmp(lang,"jp",2) == 0) {
#if TKGATE_JSUPPORT
    strcpy(msg_lang,"ja");
    XGate.japaneseMode = 1;
#else
    logError(ERL_ERROR,"Not configured for Japanese support.  Reverting to English.");
    putenv("LANG=ASCII");
    strcpy(msg_lang,"en");
#endif
  }

  msg_lang[2] = 0;


  if (strcmp(msg_lang,"en") != 0) {
    sprintf(fileName,"%s/messages.%s",tkgate_homedir,msg_lang);
    f = fopen(fileName,"r");
    if (f) {
      while (fgets(buf,1024,f)) {
	if (sscanf(buf,"%s %[^\n]",tag,msg) == 2 && *tag != '#') {
	  if (strcmp(msg,"-begin-") == 0)
	    readLongMsg(f,msg,8096);

	  if (SHash_find(H,tag)) {
	    logError(ERL_ERROR,"Duplicate add of message '%s'.",tag);
	  }

	  SHash_insert(H,tag,strdup(msg));
	}
      }
      fclose(f);
      en_backup = 1;
    } else {
      printf("[No support for locale '%s'.  Reverting to English.]\n",msg_lang);
      strcpy(msg_lang,"en");
    }
  }

  sprintf(fileName,"%s/messages.en",tkgate_homedir);
  f = fopen(fileName,"r");
  if (!f) {
    logError(ERL_ERROR,"Can not find required messages.en file.\n");
    exit(1);
  }
  while (fgets(buf,1024,f)) {
    if (sscanf(buf,"%s %[^\n]",tag,msg) == 2 && *tag != '#') {
      if (strcmp(msg,"-begin-") == 0)
	readLongMsg(f,msg,8096);

      if (en_backup) {
	if (!SHash_find(H,tag)) {
	  SHash_insert(H,tag,strdup(msg));
	  logError(ERL_ERROR,"No localized string for symbol '%s'.  Using English value.",tag);
	}
      } else {
	if (SHash_find(H,tag)) {
	  logError(ERL_ERROR,"Duplicate add of message '%s'.",tag);
	}
	SHash_insert(H,tag,strdup(msg));
      }
    }
  }

  fclose(f);

  message_table = H;

  Tcl_SetVar(tcl,"lang",msg_lang,TCL_GLOBAL_ONLY);

#if TKGATE_JSUPPORT
  /*
   * If we have Japanese support and kinput is running, an invalid locale
   * will cause a crash in the tcl/tk initialization step.  If the locale
   * is not set, force it to a valid locale.
   */
  if (!getenv("LANG"))
    putenv("LANG=ASCII");
#endif
}

/*
 * tcl handler code for message lookup function 'm'.
 */
int gat_msgLookup(ClientData d,Tcl_Interp *tcl,int argc,char *argv[])
{
  char *msg;

  if (argc < 2) return TCL_OK;

  msg = msgLookup(argv[1]);
  if (strlen(msg) < 127)
    strcpy(tcl->result,msg);
  else
    tcl->result = strdup(msg);

  return TCL_OK;
}

/*
 * Set handlers on various signals we might receive.  Most abnormal signals
 * are caught by panicSave which attempts to save the current circuit.
 */
void tkgate_signalSetup()
{
  /*
    Make sure they really want to exit when ctl-c is typed.
   */
  signal(SIGINT,catchInterrupt);

  /*
    Do a panic save on any core dump producing signal, or
    on a SIGHUP.
   */
  signal(SIGHUP,panicSave);
  signal(SIGQUIT,panicSave);
  signal(SIGILL,panicSave);
  signal(SIGTRAP,panicSave);
  signal(SIGFPE,panicSave);
  signal(SIGBUS,panicSave);
  signal(SIGSEGV,panicSave);
#ifdef SIGEMT
  signal(SIGEMT,panicSave);
#endif
#ifdef SIGSYS
  signal(SIGSYS,panicSave);
#endif
}

void usage()
{
  fprintf(stderr,"Usage: tkgate [options][file]\n\n");
  fprintf(stderr,"  Options:\n");
  fprintf(stderr,"    -h         Print this summary of options.\n");
  fprintf(stderr,"    -s         Run in X11 synchronous mode (slow).\n");
  fprintf(stderr,"    -q         Suppress some messages to the tty.\n");
  fprintf(stderr,"    -x         Start simulator immediately.\n");
  fprintf(stderr,"    -X file    Start simulator immediately and execute script.\n");
  fprintf(stderr,"    -l file    Load file as a library.\n");
  fprintf(stderr,"    -L lang    Specify language (if configured).\n");
  fprintf(stderr,"    -p file    Print to a file.\n");
  fprintf(stderr,"    -P prn     Output to a printer.\n");
  exit(1);
}


void parse_options(int argc,char *argv[])
{
  int i;
  int c;
  extern char *optarg;
  extern int optind;
#if OPTRESET
  extern int optreset;
#endif

  loadList = (char**) calloc(argc,sizeof(char*));
  libLoadList = (char**) calloc(argc,sizeof(char*));

  while (argc > 0) {
    while ((c = getopt(argc,argv,"hdxqsX:l:L:p:P:")) != EOF) {
      switch (c) {
      case 'X' :
	start_sim = 1;
	sim_script = optarg;
	break;
      case 'p' :
	print_file = optarg;
	break;
      case 'P' :
	print_printer = optarg;
	break;
      case 'x' :
	start_sim = 1;
	break;
      case 'q' :
	quiet = 1;
	break;
      case 's' :
	sync_Xserver = 1;
	break;
      case 'd' :
	debug = 1;
	break;
      case 'l' :
	libLoadList[numLibLoads++] = optarg;
	break;
      case 'L' :
	{
	  static char buf[128];
	  if (strlen(optarg) < 100) {
	    /*
	     * Solaris putenv man page claims the actual string passed
	     * to putenv is used in the environment so we must use
	     * a 'static' char array here.
	     */
	    sprintf(buf,"LANG=%s",optarg);
	    putenv(buf);
	  } else
	    putenv("LANG=ASCII");
	}
	break;
      case 'h' :
      default :
	usage();
	break;
      }
    }
    argc -= optind;
    argv += optind;
#if OPTRESET
    optreset = 1;
#endif
    optind = 0;
    if (argc > 0) {
      loadList[numLoads++] = argv[0];
      argc--;
      argv++;
    }
  }
}

/*
 * See if Miles Bader is running this program and harass him just a bit.
 */
void bader_check()
{
  struct passwd *pw = getpwuid(getuid());
  char buf[STRMAX],*p;
  extern int baderp,startrekp,batp;

  strcpy(buf,pw->pw_gecos);
  for (p = buf;*p;p++)
    if (isupper(*p)) *p = tolower(*p);

  if (strstr(buf,"miles") != 0 && strstr(buf,"bader") != 0) {
    baderp = 1;
    printf("Hi sMiles!\n");
  } else if ((strstr(buf,"james") != 0 || strstr(buf,"jim") != 0) && strstr(buf,"kirk") != 0) {
    startrekp = 1;
    printf("Kirk, this place is swarming with Klingons!\n");
  } else if ((strstr(buf,"william") != 0 || strstr(buf,"bill") != 0) && strstr(buf,"shatner") != 0) {
    startrekp = 1;
    printf("Do you have a point Spock?\n");
  } else if ((strstr(buf,"bruce") != 0 || strstr(buf,"wayne") != 0) && strstr(buf,"shatner") != 0) {
    batp = 1;
    printf("Let's go, Robin. The longer we tarry, the more dire the peril.\n");
  }
}

/*
 * Read delay files and associate them with gates
 */
void TkGate_initDelay()
{
  char buf[STRMAX],*p;
  extern SHash GateIdxHash;
  HashElem *E;
  int i;

  GDelayDef_flush();

  p = Tcl_GetVar(XGate.tcl,"tkg_simDefaultDelayFile",TCL_GLOBAL_ONLY);
  if (GDelayDef_readFile(p) < 0)
    message(1,"Can not open default delay file '%s'.",p);

  p = Tcl_GetVar(XGate.tcl,"tkg_simDelayFile",TCL_GLOBAL_ONLY);
  strcpy(buf,p);
  for (p = strtok(buf," ");p;p = strtok(0," ")) {
    if (GDelayDef_readFile(p) < 0)
      message(1,"tkgate: Can not open delay file '%s'.",p);
  }

  for (E = Hash_first(&GateIdxHash);E;E = Hash_next(&GateIdxHash,E)) {
    GGateInfo *gi = (GGateInfo*) HashElem_obj(E);

    for (i = 0;gi->delayNames[i];i++);
    gi->num_delays = i;

    if (!gi->num_delays) continue;

    strcpy(buf,gi->vnames);
    if ((p = strchr(buf,':'))) *p = 0;

    gi->delay_defs = GDelayDef_findList(buf);
    if (!gi->delay_defs) {
      message(1,"No delay definitions found for primitive '%s'.",buf);
    } else {
      GDelayDef *dd = GDelayDef_findTech(gi->delay_defs,"default");
      if (strcmp(dd->dd_tech,"default") != 0)
	message(1,"No 'default' delay definition found for primitive '%s'.",buf);
    }
  }

  DoTcl("resetTechList");
}

/*
 * Called to do final tkgate initilization (called from tcl script)
 */
void TkGate_init(Tcl_Interp *tcl)
{
  int i;

  TkGate_initDelay();

  sel_updateMenuState();

  for (i = 0;i < numLoads;i++) {
    DoTcl("gat_load %s",loadList[i]);
    did_load = 1;
  }

  for (i = 0;i < numLibLoads;i++) {
    DoTcl("gat_loadLibrary %s",libLoadList[i]);
    did_load = 1;
  }

  free(libLoadList);
  free(loadList);

  guiActive = 1;

  if (start_sim) {
    if (sim_script)
      Tcl_SetVar(XGate.tcl,"sopts_simInitScript",sim_script,TCL_GLOBAL_ONLY);
    tkgate_setMajorMode(MM_SIMULATE);
  }

  if (noviceMode && !did_load)
    DoTcl("tkg_loadNoviceCircuit");

  /*
   * If a print file has been specified.  Print the file and exit tkgate.
   */
  if (print_file) {
    DoTcl("tkg_printWithDefaults 1 %s",print_file);
    exit(0);
  }

  /*
   * If a printer has been specified.  Print to specified printer and
   * exit tkgate.
   */
  if (print_printer) {
    DoTcl("tkg_printWithDefaults 0 {lpr -P%s}",print_printer);
    exit(0);
  }

  bader_check();
  tkgate_signalSetup();			/* set traps on signals */
}

void tkgate_setup_tutorials(Tcl_Interp *tcl)
{
  char buf[STRMAX],*p;
  char *lang = Tcl_GetVar(tcl,"lang",TCL_GLOBAL_ONLY);
  struct stat sb;

  if (strcmp(lang,"en") == 0) {
    sprintf(buf,"%s/examples/tutorials",tkgate_homedir);
  } else {
    sprintf(buf,"%s/examples/%s-tutorials",tkgate_homedir,lang);
    if (stat(buf,&sb) || ((sb.st_mode & S_IFMT) != S_IFDIR)) {
      sprintf(buf,"%s/examples/tutorials",tkgate_homedir);
      printf("[No tutorials found for locale '%s'.  Using English tutorials.]\n",lang);
    }
  }

  tkgate_tutorialdir = strdup(buf);
  Tcl_SetVar(tcl,"tkgate_tutorialdir",buf,TCL_GLOBAL_ONLY);
}

int Tcl_AppInit(Tcl_Interp *tcl)
{
  char buf[STRMAX],*p;
  int r,i;


  /*
   * Initialize the application description object to all zeros.
   */
  memset(&XGate,0,sizeof(XGate));


  r = Tcl_Init(tcl);
  if (r == TCL_ERROR) {
    fprintf(stderr,"Tcl_Init Error in tkgate:\n%s\n",tcl->result);
    fprintf(stderr,"Perhaps you could try setting the environment variable TCL_LIBRARY\n");
    fprintf(stderr,"to the directory in which init.tcl can be found.  You can also set\n");
    fprintf(stderr,"this variable in config.h\n");
    exit(1);
  }

  localization_Setup(tcl);

  r = Tk_Init(tcl);
  if (r == TCL_ERROR) {
    fprintf(stderr,"Tk_Init Error in tkgate:\n%s\n",tcl->result);
    fprintf(stderr,"Perhaps you could try setting the environment variable TK_LIBRARY\n");
    fprintf(stderr,"to the directory in which tk init files can be found.  You can also set\n");
    fprintf(stderr,"this variable in config.h\n");
    exit(1);
  }

  Tcl_SetVar(tcl,"tkg_gateHome",tkgate_homedir,TCL_GLOBAL_ONLY);

  sprintf(buf,"%s/bitmaps",tkgate_homedir);
  Tcl_SetVar(tcl,"bd",buf,TCL_GLOBAL_ONLY);

  sprintf(buf,"%s/scripts",tkgate_homedir);
  Tcl_SetVar(tcl,"sd",buf,TCL_GLOBAL_ONLY);

  sprintf(buf,"%s/examples",tkgate_homedir);
  tkgate_exampledir = strdup(buf);
  Tcl_SetVar(tcl,"tkgate_exampledir",buf,TCL_GLOBAL_ONLY);

  tkgate_setup_tutorials(tcl);

  configureMainWindow(tcl);

  linkvars(tcl);


  Tcl_CreateCommand(tcl,"m",gat_msgLookup,(ClientData)0,0);

  icon_init();
  SetUpCursors();
  MakeHashTables();

  init_gates();				/* initialized built-in gate types */
  InitTclProcs(tcl);			/* install tkgate tcl commands */
  cpath_initNetDelayTable();		/* initialize delay tables for critical path analysis */

#if TKGATE_UNICODE_JSUPPORT
  if (XGate.japaneseMode)
    DoTcl("catch { option add *font k14 }");
#endif

  return TCL_OK;
}

int main(int argc,char *argv[])
{
  char tkgate_startup_script[STRMAX];
  char *tk_argv[2];

#ifdef TCL_LIBRARY
  if (!getenv("TCL_LIBRARY")) putenv("TCL_LIBRARY=" TCL_LIBRARY);
#endif
#ifdef TK_LIBRARY
  if (!getenv("TK_LIBRARY")) putenv("TK_LIBRARY=" TK_LIBRARY);
#endif

  tkg_findGateHome();
  parse_options(argc,argv);
  if (!quiet) PrintCopyright();

  sprintf(tkgate_startup_script,"%s/%s",tkgate_homedir,TCLSCRIPT);
  tk_argv[0] = argv[0];
  tk_argv[1] = tkgate_startup_script;
  Tk_Main(2,tk_argv,Tcl_AppInit);

  return 0;
}

