include $(HOME)/build/make.config

.PHONY: FORCE
.SUFFIXES: .cpp

INCLUDES += -I$(HOME)/src/include

COMPFLAGS=$(CFLAGS) $(CXXFLAGS) $(INCLUDES) 
SRC=$(OBJS:.o=.cpp)

.cpp.o:
	$(CXX) -c $(COMPFLAGS) $< -o $@

all:	$(PROGS)

clean:
	rm -f $(OBJS) *~ Makefile.bak date_string.* core

realclean very: clean
	rm -f $(PROGS)

# Gag, makedepend is kind of a crock, isn't it..  We'd
# like to not generate dependencies for system header
# files, which is kind of what -Y is advertised to do,
# but then with -Y we get makedepend warnings on basically
# every file saying Can't find stdlib.h! Can't find iostream.h!
# and so forth.  We'd really like to switch over to $(CPP) -MM
# but haven't got the juice to do it now.  So to avoid scaring
# people, we're resorting to the endlessly evil expedient of
# muzzling makedepend's stderr..
depend: FORCE
	@makedepend -Y -- $(COMPFLAGS) -- *.cpp 2>/dev/null

install:	$(PROGS)
	mkdir -p $(LIBDIR)
	mkdir -p $(BINDIR)
	$(INSTALL) $(PROGS) $(LIBDIR)
