/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: fpu.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

#include "sizedefs.h"
#include "Instruct.h"
#include "FPU.h"
#include "Assert.h"

// public Constructors / Destructors
//
FloatingPointUnit::FloatingPointUnit() {
    FloatingPointUnit::reset();    
}
FloatingPointUnit::~FloatingPointUnit() {}


// public Member functions
//     
void FloatingPointUnit::reset() {
    int i;

    for ( i = 0; i < 32; i++ ) {
	_freg[i] = 0.0;
    }

    // change this -- get rounding direction
    _RD   = 0;		// rounding -- nearest (even if tie)   
    _TEM  = 0x1f;	// enable all floating point exceptions
    _NS   = 0;		// ANSI/IEEE standard results
    _ver  = 0;		// identifies FPU implementation -- means nothing here
    _ftt  = No_FPU_Trap;// floating-point exception trap type = NONE
    _qne  = 0;		// Optional fp deferred-trap queue -- NOT PRESENT
    _fcc  = 0;    	// fp condition codes
    _aexc = 0; 		// clear accrued exception
    _cexc = 0;		// Clear current exception
}


//
// the FPU dispatch return the trap code the instruction routine returns
//
int FloatingPointUnit::dispatch_instruction(const Instruction& inst) {
    switch (inst.op3()) {
    case Instruction::FPop1:
	switch (inst.opf()) {
	case FiTOs: case FiTOd: case FiTOq:
	    return convert_itof(inst);
	case FsTOi: case FdTOi: case FqTOi:
	    return convert_ftoi(inst);
	case FsTOd: case FsTOq: case FdTOs: case FdTOq: case FqTOs: case FqTOd:
	    return convert_ftof(inst);
	case FMOVs: case FNEGs: case FABSs:
	    return move(inst);
	case FSQRTs: case FSQRTd: case FSQRTq:
	    return square_root(inst);
	case FADDs: case FADDd: case FADDq: case FSUBs: case FSUBd: case FSUBq:
	    return add_subtract(inst);
	case FMULs: case FMULd: case FMULq: case FsMULd: case FdMULq:
	case FDIVs: case FDIVd: case FDIVq:
	    return multiply_divide(inst);
	case FCMPs: case FCMPd: case FCMPq: case FCMPEs: case FCMPEd:
	case FCMPEq:
	    return compare(inst);
	default:
	    return unimplemented();
	    // Assert(0, "unknown opf");
	}
	break;
    case Instruction::FPop2:
	switch (inst.opf()) {
	case FCMPs: case FCMPd: case FCMPEd: case FCMPEs:
	    return compare(inst);
	default:
	    return unimplemented();
	}
	break;
    default:
	Assert(0, "Unknown floating op: PLEASE EMAIL isem@cs.unm.edu with this error!");
	/* NOT_REACHED */
	return -1;		// keep gcc happy
    }
}


// FPU register query/modify
//
UInt32 FloatingPointUnit::ireg(UInt32 r) { 
    return _ireg[r];
}
Float_s FloatingPointUnit::freg(UInt32 r) { 
    return _freg[r];
}
Float_d FloatingPointUnit::dreg(UInt32 r) { 
    return _dreg[r >> 1];
}


void FloatingPointUnit::ireg(UInt32 r, UInt32 value) { 
    _ireg[r] = value;
}
void FloatingPointUnit::freg(UInt32 r, Float_s value) {
    _freg[r] = value;
}
void FloatingPointUnit::dreg(UInt32 r, Float_d value) {
    _dreg[r >> 1] = value;
}


// Floatingpoint Status Register
UInt32 FloatingPointUnit::FSR() { 
    return (_RD << 30) | (_TEM << 23) | (_NS << 22) | (_ver << 17) |
	(_ftt << 14) | (_qne << 13) | (_fcc << 10) | (_aexc << 5) | _cexc ;
}


void FloatingPointUnit::FSR(UInt32 value) {
    _RD   = (value >> 30) & 0x3;
    _TEM  = (value >> 23) & 0x1F;
    _NS   = (value >> 22) & 1 ;
    _ver  = (value >> 17) & 0x7;
    _ftt  = (value >> 14) & 0x7;
    _qne  = (value >> 13) & 1;
    _fcc  = (value >> 10) & 0x3;
    _aexc = (value >> 5 ) & 0x1F;
    _cexc = (value)       & 0x1F;
} 


// FSR field query
//
UInt32 FloatingPointUnit::RD()  { return _RD;  }
UInt32 FloatingPointUnit::TEM() { return _TEM; }
UInt32 FloatingPointUnit::NS()  { return _NS;  }
UInt32 FloatingPointUnit::ver() { return _ver; }
UInt32 FloatingPointUnit::ftt() { return _ftt; }
UInt32 FloatingPointUnit::qne() { return _qne; }
UInt32 FloatingPointUnit::fcc() { return _fcc; }
UInt32 FloatingPointUnit::aexc(){ return _aexc; }
UInt32 FloatingPointUnit::cexc(){ return _cexc; }
