/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//
// $Id: a_out.h 1.2 Sat, 13 Sep 1997 12:04:11 -0600 maccabe $
//

#ifndef __A_OUT_GNU_H__
#define __A_OUT_GNU_H__

#define __GNU_EXEC_MACROS__

#ifndef __STRUCT_EXEC_OVERRIDE__

struct exec
{
  unsigned int a_info;	/* Use macros N_MAGIC, etc for access */
  unsigned a_text;	/* length of text, in bytes */
  unsigned a_data;	/* length of data, in bytes */
  unsigned a_bss;	/* length of uninitialized data area for file, bytes */
  unsigned a_syms;	/* length of symbol table data in file, in bytes */
  unsigned a_entry;	/* start address */
  unsigned a_trsize;	/* length of relocation info for text, in bytes */
  unsigned a_drsize;	/* length of relocation info for data, in bytes */
};

#endif /* __STRUCT_EXEC_OVERRIDE__ */

/* these go in the N_MACHTYPE field */
enum machine_type {
#if defined (M_SPARC)
  M__SPARC = M_SPARC
#else
  M_SPARC = 3
#endif
};

#ifndef N_MAGIC
#define N_MAGIC(exec) ((exec).a_info & 0xffff)
#endif

#define N_MACHTYPE(exec) ((enum machine_type)(((exec).a_info >> 16) & 0xff))
#define N_FLAGS(exec) (((exec).a_info >> 24) & 0xff)
#define N_SET_INFO(exec, magic, type, flags) \
	((exec).a_info = ((magic) & 0xffff) \
	 | (((int)(type) & 0xff) << 16) \
	 | (((flags) & 0xff) << 24))
#define N_SET_MAGIC(exec, magic) \
	((exec).a_info = (((exec).a_info & 0xffff0000) | ((magic) & 0xffff)))

#define N_SET_MACHTYPE(exec, machtype) \
	((exec).a_info = \
	 ((exec).a_info&0xff00ffff) | ((((int)(machtype))&0xff) << 16))

#define N_SET_FLAGS(exec, flags) \
	((exec).a_info = \
	 ((exec).a_info&0x00ffffff) | (((flags) & 0xff) << 24))

/* Code indicating object file or impure executable.  */
#define OMAGIC 0407
/* Code indicating pure executable.  */
#define NMAGIC 0410
/* Code indicating demand-paged executable.  */
#define ZMAGIC 0413

#ifndef N_BADMAG
#define N_BADMAG(x)					\
 (N_MAGIC(x) != OMAGIC && N_MAGIC(x) != NMAGIC		\
  && N_MAGIC(x) != ZMAGIC)
#endif

#define _N_BADMAG(x)					\
 (N_MAGIC(x) != OMAGIC && N_MAGIC(x) != NMAGIC		\
  && N_MAGIC(x) != ZMAGIC)

#define SPARC_PAGE_SIZE    0x2000
#define SPARC_SEGMENT_SIZE SPARC_PAGE_SIZE

#define _N_HDROFF(x) (1024 - sizeof (struct exec))

#define N_TXTOFF(x) \
 (N_MAGIC(x) == ZMAGIC ? 0 :  sizeof(struct exec))

#define N_DATOFF(x) (N_TXTOFF(x) + (x).a_text)

#define N_TRELOFF(x) (N_DATOFF(x) + (x).a_data)

#define N_DRELOFF(x) (N_TRELOFF(x) + (x).a_trsize)

#define N_SYMOFF(x) (N_DRELOFF(x) + (x).a_drsize)

#define N_STROFF(x) (N_SYMOFF(x) + (x).a_syms)

/* Address of text segment in memory after it is loaded.  */
#define N_TXTADDR(x) \
	((N_MAGIC(x) == ZMAGIC) && ((x).a_entry < SPARC_PAGE_SIZE) ? \
	0 : SPARC_PAGE_SIZE)

#define _N_SEGMENT_ROUND(x) (((x) + SPARC_SEGMENT_SIZE - 1) & ~(SPARC_SEGMENT_SIZE - 1))

#define _N_TXTENDADDR(x) (N_TXTADDR(x)+(x).a_text)

#define N_DATADDR(x) \
    (N_MAGIC(x)==OMAGIC? (_N_TXTENDADDR(x)) \
     : (_N_SEGMENT_ROUND (_N_TXTENDADDR(x))))

/* Address of bss segment in memory after it is loaded.  */
#define N_BSSADDR(x) (N_DATADDR(x) + (x).a_data)

#if !defined (N_NLIST_DECLARED)
struct nlist {
  union {
    int n_name;
    int n_next;
    int n_strx;
  } n_un;
  unsigned char n_type;
  char n_other;
  short n_desc;
  unsigned int n_value;
};
#endif /* no N_NLIST_DECLARED.  */

#define N_UNDF 0
#define N_ABS 2
#define N_TEXT 4
#define N_DATA 6
#define N_BSS 8
#define N_FN 15

#define N_EXT 1
#define N_TYPE 036
#define N_STAB 0340

/* The following type indicates the definition of a symbol as being
   an indirect reference to another symbol.  The other symbol
   appears as an undefined reference, immediately following this symbol.

   Indirection is asymmetrical.  The other symbol's value will be used
   to satisfy requests for the indirect symbol, but not vice versa.
   If the other symbol does not have a definition, libraries will
   be searched to find a definition.  */
#define N_INDR 0xa

/* The following symbols refer to set elements.
   All the N_SET[ATDB] symbols with the same name form one set.
   Space is allocated for the set in the text section, and each set
   element's value is stored into one word of the space.
   The first word of the space is the length of the set (number of elements).

   The address of the set is made into an N_SETV symbol
   whose name is the same as the name of the set.
   This symbol acts like a N_DATA global symbol
   in that it can satisfy undefined external references.  */

/* These appear as input to LD, in a .o file.  */
#define	N_SETA	0x14		/* Absolute set element symbol */
#define	N_SETT	0x16		/* Text set element symbol */
#define	N_SETD	0x18		/* Data set element symbol */
#define	N_SETB	0x1A		/* Bss set element symbol */

/* This is output from LD.  */
#define N_SETV	0x1C		/* Pointer to set vector in data area.  */


/* taken from the SunOS man pages -- comments filled in from observations*/
enum reloc_type
{
    /* simplest relocations */
    RELOC_8,			/* --00 ".byte xxx" -- as generates bad code */
    RELOC_16,			/* --01 ".half xxx" -- illegal */
    RELOC_32,			/* 02 ".word xxx" */

    /* PC relative relocations */
    RELOC_DISP8,		/* --03 */
    RELOC_DISP16,		/* --04 */
    RELOC_DISP32,		/* --05 */

    /* PC relative with displacement  -- SR word disp's */
    RELOC_WDISP30,		/* 06 "call xxx" */
    RELOC_WDISP22,		/* 07 "ba xxx" */

    RELOC_HI22,			/* 08 "sethi %hi(xxx), %r3" */
    RELOC_22,			/* --09 "sethi xxx, %r3" */
    RELOC_13,			/* 10 "add %r2, xxx, %r3" */
    RELOC_LO10,			/* 11 "add %r2, %lo(xxx) %r3" */

    /* ??? -- shared objects -- ??? */
    RELOC_SFA_BASE, RELOC_SFA_OFF13,                /* SR S.F.A. relocs   */
    RELOC_BASE10,   RELOC_BASE13,   RELOC_BASE22,   /* base_relative pic */
    RELOC_PC10,     RELOC_PC22,                     /* special pc-rel pic*/
    RELOC_JMP_TBL,                                  /* jmp_tbl_rel in pic */
    RELOC_SEGOFF16,                                 /* ShLib offset-in-seg*/
    RELOC_GLOB_DAT, RELOC_JMP_SLOT, RELOC_RELATIVE  /* rtld relocs        */
};

/*
 * Format of a relocation datum.
 */

struct reloc_info_sparc /* used when header.a_machtype == M_SPARC */
{
        unsigned long int r_address;    /* relocation addr (offset in segment)*/
        unsigned int    r_index   :24;  /* segment index or symbol index      */
        unsigned int    r_extern  : 1;  /* if F, r_index==SEG#; if T, SYM idx */
        int                       : 2;  /* <unused>                           */
        enum reloc_type r_type    : 5;  /* type of relocation to perform      */
        long int        r_addend;       /* addend for relocation value        */
};

#if !defined (N_RELOCATION_INFO_DECLARED)
struct relocation_info
{
    /* Address (within segment) to be relocated.  */
    int r_address;

    unsigned int reloc_type:5;

    int :2; /* unused */

    /* 1 => relocate with value of symbol.
            r_symbolnum is the index of the symbol
	    in file's the symbol table.
       0 => relocate with the address of a segment.
            r_symbolnum is N_TEXT, N_DATA, N_BSS or N_ABS
	    (the N_EXT bit may be set also, but signifies nothing).  */
    unsigned int r_extern:1;

    /* The meaning of r_index depends on r_extern.  */
    unsigned int r_index:24;

    unsigned int addend;
};
#endif /* no N_RELOCATION_INFO_DECLARED.  */


#endif /* __A_OUT_GNU_H__ */
