/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: rtn_trap.cpp 1.2 Fri, 27 Dec 1996 14:28:13 -0700 maccabe $";

//-----------------------------------------------------
// Return from Trap Instruction -
//    see p181 of SPARC Architecture Manual, Version 8
//-----------------------------------------------------

#include <string.h>

#include "sizedefs.h"
#include "Instruct.h"
#include "RegBlock.h"
#include "IU.h"

extern char ErrMsg[];

void IntegerUnit::return_from_trap(const Instruction& inst) {
    UInt32 new_cwp = (reg.CWP() + 1 + NWINDOWS) % NWINDOWS;

    UInt32 address = reg[inst.rs1()] +
		     ((inst.i() == 0) ? reg[inst.rs2()] : inst.simm13());

    if (IU_ET == 1) {
        trap = 1;
	strcpy( ErrMsg, "Return from trap when traps enabled" );
	if (IU_S == 0)
            trapFlag[privileged_instruction] = 1;
	else
            trapFlag[illegal_instruction] = 1;
    } else if (IU_S == 0) {
        trap = 1;
        trapFlag[privileged_instruction] = 1;
	strcpy( ErrMsg, "Return from trap executed in user mode" );
	mode = ERROR;
    } else if ((IU_WIM >> new_cwp) & 1) {
        trap = 1;
        trapFlag[window_underflow] = 1;
	strcpy( ErrMsg, "Return from trap -- window underflow" );
	mode = ERROR;
    } else if ((address & 0x3) != 0 ) {
        trap = 1;
        trapFlag[mem_address_not_aligned] = 1;
	strcpy( ErrMsg, "Return from trap to unaligned address" );
	mode = ERROR;
    } else {
        IU_ET = 1;
        IU_PC = IU_nPC;
        IU_nPC = address;
        reg.CWP(new_cwp);
        IU_S = IU_PS;
    }
}
