/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED
 = "$Id: isemStep.cpp 1.3 Sat, 13 Sep 1997 12:04:11 -0600 maccabe $";

char ErrMsg[256] = "No error";

// -- Step.c --------------------------------------------------------------
//
// This module performs single step execution of the program in User
// Text segment. 
//
// Ver 1.0 - 13 JUL 92 - R.Mueller
// 

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <tk.h>

#include "config.h"

#include "sizedefs.h"
#include "globals.h"
#include "RegBlock.h"
#include "IU.h"

#include "Isem.h"

extern Tcl_Channel Input, Output;
Tcl_Interp *Interp;

int Isem_Step( ClientData, Tcl_Interp *interp, int argc, char ** ) {
    //
    // usage:
    //    isem_step
    //
    if( argc != 1 ) {
	sprintf( interp->result, "isem_step:  wrong number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    Interp = interp;
    if( iu->S() ) {
	super_steps++;
	super_mems += iu->execute();
    } else {
	user_steps++;
	user_mems += iu->execute();
    }

    if( iu->IU_state() == IntegerUnit::EXECUTE ) {
	if( iu->S() ) {
	    interp->result = "super";
	} else {
	    interp->result = "user";
	}
    } else {
	char temp[256];
	sprintf( temp, "debug \"processor error:  %s\"", ErrMsg );
	Tcl_Eval( interp, temp );
	strcpy( ErrMsg, "No error" );
	interp->result = "error";
    }
    return TCL_OK;
}

int Isem_Counts( ClientData, Tcl_Interp *interp, int argc, char ** ) {
    //
    // usage:
    //    isem_counts
    //
    if( argc != 1 ) {
	sprintf( interp->result, "isem_counts:  wrong number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    sprintf( interp->result, "%d %d %d %d", user_steps, user_mems, super_steps,
	     super_mems );
    return TCL_OK;
}

int Isem_Usteps( ClientData, Tcl_Interp *interp, int argc, char ** ) {
    //
    // usage:
    //    isem_usteps 
    //
    if( argc != 1 ) {
	sprintf( interp->result, "isem_usteps:  wrong number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    sprintf( interp->result, "%d", user_steps );
    return TCL_OK;
}

int Isem_Tsteps( ClientData, Tcl_Interp *interp, int argc, char ** ) {
    //
    // usage:
    //    isem_usteps 
    //
    if( argc != 1 ) {
	sprintf( interp->result, "isem_tsteps:  wrong number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    sprintf( interp->result, "%d", user_steps+super_steps );
    return TCL_OK;
}

int Isem_Annul( ClientData, Tcl_Interp *interp, int argc, char ** ) {
    //
    // usage:
    //    isem_annul
    //
    if( argc != 1 ) {
	sprintf( interp->result, "isem_annul:  wrong number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    if( iu->IU_annul ) {
	interp->result = "(annul)";
    } else {
	interp->result = "";
    }
    return TCL_OK;
}

int Isem_Interp( ClientData, Tcl_Interp *interp, int argc, char ** ) {
    //
    // usage:
    //    isem_interp
    //
    if( argc != 1 ) {
	sprintf( interp->result, "isem_interp:  wrong number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    //
    // make a channel to standard input
    Tcl_DString line;
    int res;

    Tcl_DStringInit( &line );
    
    Tcl_Write( Output, "ISEM> ", 6 );
    while( 0 <= (res=Tcl_Gets(Input,&line)) ) {
	if( TCL_ERROR == Tcl_Eval( interp, Tcl_DStringValue(&line) ) ) {
	    Tcl_Write( Output, interp->result, strlen(interp->result) );
	    Tcl_Write( Output, "\n", 1 );
	}
	Tcl_Write( Output, "ISEM> ", 6 );
	Tcl_DStringFree(&line);
//	while( 0 != Tk_DoOneEvent( TK_DONT_WAIT ) );
    }
    printf( "\n" );
    return TCL_OK;
}

int Isem_Poll( ClientData, Tcl_Interp *interp, int argc, char ** ) {
    //
    // usage:
    //    isem_poll
    //
    if( argc != 1 ) {
	sprintf( interp->result, "isem_poll:  wrong number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    Tcl_DString line;
    int res;

    Tcl_SetChannelOption( interp, Input, "-blocking", "false" );

    // process all delayed events
    while( 0 != Tcl_DoOneEvent( TCL_DONT_WAIT ) );

    Tcl_DStringInit( &line );
    while( 0 <= (res=Tcl_Gets(Input,&line)) ) {
	Tcl_Eval( interp, Tcl_DStringValue(&line) );
	Tcl_Write( Output, "ISEM> ", 6 );
	Tcl_DStringFree(&line);
    }
    Tcl_SetChannelOption( interp, Input, "-blocking", "true" );
    return TCL_OK;
}

