/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#include <gdk/gdkkeysyms.h>
#include <time.h>

#include "main.h"
#include "utils.h"
#include "conffile.h"
#include "support.h"
#include "interface.h"
#include "callbacks.h"
#include "groups.h"
#include "lista.h"
#include "windows.h"
#include "chat.h"
#include "search.h"
#include "messages.h"
#ifndef DISABLE_DOCKLET
#include "docklet.h"
#endif
#include "jabber.h"
#include "jabby.h"
#include "messages.h"
#include "xmms-info.h"

gint t_status_map[] = {0, 0, JABBY_PRESENCE_AVAILABLE,
  JABBY_PRESENCE_XA, JABBY_PRESENCE_AWAY, JABBY_PRESENCE_DND,
  JABBY_PRESENCE_CHAT, JABBY_PRESENCE_INVISIBLE, JABBY_PRESENCE_UNAVAILABLE };

gint j_status_map[]={STATUS_UNAVAILABLE, STATUS_AVAILABLE,
  STATUS_CHATTY, STATUS_AWAY, STATUS_EXT_AWAY, STATUS_DND, STATUS_INVISIBLE};

//gchar* remove_amp(gchar *s)
//{
//  gchar *n=NULL, *n2=NULL, *amp;
//
//  if(!s)
//    return NULL;
//  while(*s)
//  {
//    if(*s == '&')
//      amp = g_strdup("&amp;");
//    else
//      amp = g_strdup_printf("%c", *s);
//    if(!n)
//      n = g_strdup(amp);
//    else
//    {
//      n2 = g_strdup_printf("%s%s", n, amp);
//      g_free(n);
//      n = n2;
//    }
//    s++;
//  }
//  return n;
//}

void desc_list_add(gchar *s)
{
  GList *l;
  gchar *s2;

  l = desc_list;
  while(l)
  {
    s2 = (gchar*) l->data;
    if(!strcmp(s, s2))
    {
      desc_list = g_list_remove(desc_list, l->data);
      break;
    }
    l = l->next;
  }
  desc_list = g_list_prepend(desc_list, g_strdup(s));
}

void desc_list_append(gchar *s)
{
  GList *l;
  gchar *s2;

  l = desc_list;
  while(l)
  {
    s2 = (gchar*) l->data;
    if(!strcmp(s, s2))
    {
      desc_list = g_list_remove(desc_list, l->data);
      break;
    }
    l = l->next;
  }
  desc_list = g_list_append(desc_list, g_strdup(s));
}


void frees(gpointer d1, gpointer d2)
{
  g_free((gchar*)d1);
}

void desc_list_clear()
{
  g_list_foreach(desc_list, frees, NULL);
  g_list_free(desc_list);
  desc_list = NULL;
}

void play_sound(gint sound)
{
  if(!playpath)
  {
    info("Okrel program zewntrzny do odtwarzania dwikw.");
    return;
  }
  if(!sounds[sound])
  {
    info("Nie zdefiniowano dwiku dla zdarzenia.");
    return;
  }
  if(!fork())
  {
    gchar *args[]={"","",NULL};

    args[0]=playpath;
    args[1]=sounds[sound];
    execvp(playpath,args);
    _exit(1);
  }
}


gint get_miliseconds (void)
{
  struct timeval tv;

  if (gettimeofday (&tv, NULL) == -1)
    return 0;
  return tv.tv_usec/1000;
}

gchar *get_localtime(const time_t *t2)
{
  struct tm tm;
  time_t t;
  gchar s[9],s1[11], *s2;

  t=time(NULL);
  if(!t2)
    localtime_r(&t,&tm);
  else
    localtime_r(t2,&tm);
  strftime(s,9,"%Y%m%d",&tm);
  strftime(s1,11,"%H:%M:%S",&tm);
  s2=g_strdup_printf("%s %s",s,s1);
  return s2;
}

const gchar *textview_get_text(GtkWidget *textview)
{
  GtkTextBuffer *buffer;
  GtkTextIter start, end;

  buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));
  gtk_text_buffer_get_start_iter(buffer, &start);
  gtk_text_buffer_get_end_iter(buffer, &end);
  return gtk_text_buffer_get_text(buffer, &start, &end, TRUE);
}

void textview_append_pixmap(GtkWidget *textview, gint emots_num)
{
  GtkTextBuffer *buffer;
  GtkTextIter end;

  buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));
  gtk_text_buffer_get_end_iter(buffer, &end);
  gtk_text_buffer_insert_pixbuf(buffer, &end,
                                gtk_image_get_pixbuf(
                                      GTK_IMAGE(emots_pics[emots_num])));
}

void textview_append(GtkWidget *textview, const gchar *str, gint scroll,
                     const gchar *tag, const gchar *tag2)
{
  GtkTextBuffer *buffer;
  GtkTextIter end;
  GtkTextMark *mark;

  buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));
  gtk_text_buffer_get_end_iter(buffer, &end);
  gtk_text_buffer_insert_with_tags_by_name(buffer, &end,
                                           str, -1, tag, tag2, NULL);
  if(scroll)
  {
    gtk_text_buffer_get_end_iter(buffer, &end);
    mark = gtk_text_buffer_create_mark(buffer,"_end",&end,FALSE);
    gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(textview), mark, 0.0,
                                 TRUE, 0.5, 0.5);
    gtk_text_buffer_delete_mark_by_name(buffer,"_end");
  }
}

void textview_clear(GtkWidget *textview)
{
  GtkTextBuffer *buffer;
  GtkTextIter start, end;

  buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));
  gtk_text_buffer_get_start_iter(buffer, &start);
  gtk_text_buffer_get_end_iter(buffer, &end);
  gtk_text_buffer_delete(buffer, &start, &end);
}

void status_jabber_button_set(int status)
{
  GtkWidget *button;
  GList *widgets;
  GtkWidget *image;

  button=lookup_widget(window1,"button_status_jabber");
  widgets=gtk_container_get_children(GTK_CONTAINER(button));
  if(widgets)
  {
    gtk_container_remove(GTK_CONTAINER(button),(GtkWidget*)widgets->data);
    g_list_free(widgets);
  }
  switch(status)
  {
    case JABBY_PRESENCE_UNAVAILABLE:
      image = lookup_widget(window1,"j_offline");
      break;
    case JABBY_PRESENCE_AWAY:
      image = lookup_widget(window1,"j_away");
      break;
    case JABBY_PRESENCE_CHAT:
      image = lookup_widget(window1,"j_chatty");
      break;
    case JABBY_PRESENCE_INVISIBLE:
      image = lookup_widget(window1,"j_invisible");
      break;
    case JABBY_PRESENCE_XA:
      image = lookup_widget(window1,"j_na");
      break;
    case JABBY_PRESENCE_DND:
      image = lookup_widget(window1,"j_dnd");
      break;
    case JABBY_PRESENCE_AVAILABLE:
    default:
      image = lookup_widget(window1,"j_online");
  }
  gtk_container_add (GTK_CONTAINER (button), image);
  /* Set tooltip for Jabber status icon */
  {
	gchar *s, *s1;
  
	if (desc)
    	s1 = g_strdup_printf ("Status Jabbera: %s\nOpis: %s", j_statusy[j_status_map[status]], desc);
	else
		s1 = g_strdup_printf ("Status Jabbera: %s", j_statusy[j_status_map[status]]);
	s = utf(s1);
	gtk_tooltips_set_tip (status_tooltips, button, s, NULL);
	g_free(s1);
	g_free(s);
  }
}

void status_gg_button_set(int status)
{
  GtkWidget *button;
  GList *widgets;
  GtkWidget *image;

  button=lookup_widget(window1,"button_status_gg");
  widgets=gtk_container_get_children(GTK_CONTAINER(button));
  if(widgets)
  {
    gtk_container_remove(GTK_CONTAINER(button),(GtkWidget*)widgets->data);
    g_list_free(widgets);
  }
  switch(status)
  {
    case JABBY_PRESENCE_AWAY:
    case JABBY_PRESENCE_DND:
    case JABBY_PRESENCE_XA:
      image = lookup_widget(window1,"gg_away");
      break;
    case JABBY_PRESENCE_INVISIBLE:
      image = lookup_widget(window1,"gg_invisible");
      break;
    case JABBY_PRESENCE_AVAILABLE:
    case JABBY_PRESENCE_CHAT:
      image = lookup_widget(window1,"gg_online");
      break;
    case JABBY_PRESENCE_UNAVAILABLE:
    default:
      image = lookup_widget(window1,"gg_offline");
      break;
  }
  gtk_container_add (GTK_CONTAINER (button), image);
  /* Set tooltip for GG status icon */
  {
	gchar *s, *s1;
  
	if (desc)
    	s1 = g_strdup_printf ("Status GG: %s\nOpis: %s", j_statusy[j_status_map[status]], desc);
	else
		s1 = g_strdup_printf ("Status GG: %s", j_statusy[j_status_map[status]]);
	s = utf(s1);
	gtk_tooltips_set_tip (status_tooltips, button, s, NULL);
	g_free(s1);
	g_free(s);
  }
}

void status_button_set(int status)
{
  GtkWidget *button;
  GList *widgets;
  GtkWidget *image;

  button=lookup_widget(window1,"button_status");
  widgets=gtk_container_get_children(GTK_CONTAINER(button));
  if(widgets)
  {
    gtk_container_remove(GTK_CONTAINER(button),(GtkWidget*)widgets->data);
    g_list_free(widgets);
  }
  switch(status)
  {
    case TLEN_STATUS_UNAVAILABLE:
      image = lookup_widget(window1,"im_offline");
      break;
    case TLEN_STATUS_AWAY:
      image = lookup_widget(window1,"im_away");
      break;
    case TLEN_STATUS_CHATTY:
      image = lookup_widget(window1,"im_chat");
      break;
    case TLEN_STATUS_INVISIBLE:
      image = lookup_widget(window1,"im_invisible");
      break;
    case TLEN_STATUS_EXT_AWAY:
      image = lookup_widget(window1,"im_beback");
      break;
    case TLEN_STATUS_DND:
      image = lookup_widget(window1,"im_occupied");
      break;
    case TLEN_STATUS_AVAILABLE:
    default:
      image = lookup_widget(window1,"im_online");
  }
  gtk_container_add (GTK_CONTAINER (button), image);
  /* Set tooltip for Tlen.pl status icon */
  {
	gchar *s, *s1;
  
	if (desc)
    	s1 = g_strdup_printf("Status Tlen: %s\nOpis: %s",
				opisy[status-2], desc);
	else
		s1 = g_strdup_printf("Status Tlen: %s", opisy[status-2]);
	s = utf(s1);
	gtk_tooltips_set_tip(status_tooltips, button, s, NULL);
	g_free(s1);
	g_free(s);
  }
}

void work_offline()
{
  users_list_clear();
  list_reload_all();

  if(preferences & PREF_XMMS_INFO)
    xmms_info_enable(FALSE, 0);
  if(scroll1)
  {
    gtk_widget_destroy(scroll1);
    treeview1=scroll1=NULL;
  }
  if(timerid)
  {
    gtk_timeout_remove(timerid);
    timerid=0;
  }
  if(timerid2)
  {
    gtk_timeout_remove(timerid2);
    timerid2=0;
  }
  if(timerid3)
  {
    gtk_timeout_remove(timerid3);
    timerid3=0;
  }
  if(notify_timerid){
  	gtk_timeout_remove(notify_timerid);
	notify_timerid = 0;
  }
  if(session)
  {
    tlen_presence (session,TLEN_STATUS_UNAVAILABLE,
                   statusy[TLEN_STATUS_UNAVAILABLE]);
    session=NULL;
  }
  if(jabber_logged())
  {
    jabber_logout();
    jabber_free();
  }

  online=FALSE;
  status=TLEN_STATUS_UNAVAILABLE;
  status_button_set(status);
  status_jabber_button_set(JABBY_PRESENCE_UNAVAILABLE);
  status_gg_button_set(JABBY_PRESENCE_UNAVAILABLE);
#ifndef DISABLE_DOCKLET
  if(status_docklet) docklet_change_status(status);
#endif
  gtk_window_set_icon(GTK_WINDOW(window1),
                      gtk_image_get_pixbuf(GTK_IMAGE(icons[status])));
  if(window_search)
    window_search_close();
  if(window_prefs)
  {
    gtk_widget_destroy(window_prefs);
    window_prefs=NULL;
  }
  if(window_card)
  {
    gtk_widget_destroy(window_card);
    window_card=NULL;
  }
  if(window_desc)
  {
    gtk_widget_destroy(window_desc);
    window_desc=NULL;
  }
//  refresh_treeview();
}

void wyloguj()
{
  //zapis ustawia do pliku
  create_file();
  save_preferences();
  file_write_expanded_groups();

  if(window_gg)
  {
    gtk_widget_destroy(window_gg);
    window_gg = NULL;
  }
  if(window_sms)
  {
    gtk_widget_destroy(window_sms);
    window_sms = NULL;
  }
  if(window_archive)
    window_archive_cancel();

  work_offline();
  clear_lists();
  clear_pointers();
  if(window1)
    gtk_widget_destroy(window1);
  
  window1=NULL;
}

void wyjscie()
{
  wyloguj();
  gtk_main_quit();
}

GtkWidget *j_create_icon(gint status)
{
  switch(status)
  {
    case JABBY_PRESENCE_UNAVAILABLE:
      return create_pixmap(window1,"j_offline.png");
    case JABBY_PRESENCE_AWAY:
      return create_pixmap(window1,"j_away.png");
    case JABBY_PRESENCE_DND:
      return create_pixmap(window1,"j_dnd.png");
    case JABBY_PRESENCE_XA:
      return create_pixmap(window1,"j_na.png");
    case JABBY_PRESENCE_CHAT:
      return create_pixmap(window1,"j_chatty.png");
    case JABBY_PRESENCE_INVISIBLE:
      return create_pixmap(window1,"j_invisible.png");
    case JABBY_PRESENCE_AVAILABLE:
    default:
      return create_pixmap(window1,"j_online.png");
  }
}

GtkWidget *wp_create_icon(gint status)
{
  switch(status)
  {
    case JABBY_PRESENCE_UNAVAILABLE:
      return create_pixmap(window1,"wp_offline.png");
    case JABBY_PRESENCE_AWAY:
      return create_pixmap(window1,"wp_away.png");
    case JABBY_PRESENCE_DND:
      return create_pixmap(window1,"wp_dnd.png");
    case JABBY_PRESENCE_XA:
      return create_pixmap(window1,"wp_na.png");
    case JABBY_PRESENCE_CHAT:
      return create_pixmap(window1,"wp_online.png");
    case JABBY_PRESENCE_INVISIBLE:
      return create_pixmap(window1,"wp_invisible.png");
    case JABBY_PRESENCE_AVAILABLE:
    default:
      return create_pixmap(window1,"wp_online.png");
  }
}

GtkWidget *gg_create_icon(gint status)
{
  switch(status)
  {
    case JABBY_PRESENCE_UNAVAILABLE:
      return create_pixmap(window1,"gg_offline.png");
    case JABBY_PRESENCE_AWAY:
      return create_pixmap(window1,"gg_away.png");
    case JABBY_PRESENCE_DND:
      return create_pixmap(window1,"gg_away.png");
    case JABBY_PRESENCE_XA:
      return create_pixmap(window1,"gg_away.png");
    case JABBY_PRESENCE_CHAT:
      return create_pixmap(window1,"gg_online.png");
    case JABBY_PRESENCE_INVISIBLE:
      return create_pixmap(window1,"gg_invisible.png");
    case JABBY_PRESENCE_AVAILABLE:
    default:
      return create_pixmap(window1,"gg_online.png");
  }
}


GtkWidget *create_icon(gint status)
{
  switch(status)
  {
    case TLEN_STATUS_UNAVAILABLE:
      return create_pixmap(window1,"offline.png");
    case TLEN_STATUS_AWAY:
      return create_pixmap(window1,"away.png");
    case TLEN_STATUS_DND:
      return create_pixmap(window1,"occupied.png");
    case TLEN_STATUS_EXT_AWAY:
      return create_pixmap(window1,"beback.png");
    case TLEN_STATUS_CHATTY:
      return create_pixmap(window1,"chat.png");
    case TLEN_STATUS_INVISIBLE:
      return create_pixmap(window1,"invisible.png");
    case TLEN_STATUS_AVAILABLE:
    default:
      return create_pixmap(window1,"online.png");
  }
}


GtkWidget *notify_create_icon(gint type)
{
	switch(type) {
		case NOTIFY_NEWMSG:
		default:
			return create_pixmap(window1,"notify_newmsg.png");
	}

}




gint timer (gpointer data)
{
  fd_set rd, wr;
  int retval;
  struct tlen_event *event;
  struct timeval tv;
  static gchar *s = NULL;
  
  tv.tv_sec = 0;
  tv.tv_usec = 1;

  FD_ZERO (&rd);
  FD_ZERO (&wr);
  if(session->error)
  {
    info("Wystpi bad poczenia!!!");
    work_offline();
    return TRUE;
  }
  if ((session->check & TLEN_CHECK_READ))
    FD_SET (session->fd, &rd);
  if ((session->check & TLEN_CHECK_WRITE))
    FD_SET (session->fd, &wr);

  if ((retval = select (session->fd + 1, &rd, &wr, NULL, &tv) == -1))
  {
    perror ("select");
    //FIXME
  }

  if (session && (FD_ISSET (session->fd, &rd) || FD_ISSET (session->fd, &wr)))
  {
    tlen_watch_fd (session);
    while ((event=tlen_getevent(session))!=NULL)
    {
	  tleenx_print(DEBUG, "new event\n");
      switch (event->type)
      {
        case TLEN_EVENT_SUBSCRIBE:
          {

            struct user *u=get_user(event->subscribe->jid);
            if(!u)
            {
              tlen_accept_subscribe(session,event->subscribe->jid);
              tlen_addcontact(session,"",event->subscribe->jid,"");
              add_user("",event->subscribe->jid,"","from","","",
                       TLEN_STATUS_UNAVAILABLE, USER_TLEN);
            }
            else
            {
              if(!strcmp(u->subscription,"none"))
              {
                tlen_accept_subscribe(session,event->subscribe->jid);
                add_user(NULL,event->subscribe->jid,NULL,"from","",NULL,
                         TLEN_STATUS_UNAVAILABLE, -1);
              }
              else
                add_user(NULL,event->subscribe->jid,NULL,"both",NULL,NULL,-1,
                         -1);
            }
            if(preferences & PREF_BEEPONA)
              play_sound(SOUNDA);
            my_create_window_authorize(event->subscribe->jid);
            break;
          }
        case TLEN_EVENT_SUBSCRIBED:
          {
            struct user *user;

            user = get_user(event->subscribe->jid);
            if(user)
            {
              if(!strcmp(user->subscription, "from"))
                add_user(NULL,event->subscribe->jid,NULL,"both",NULL,"",-1,
                         -1);
              else
                add_user(NULL,event->subscribe->jid,NULL,"to",NULL,"",-1,
                         -1);
              list_reload_all();
            }
            break;
          }
        case TLEN_EVENT_UNSUBSCRIBE:
          {
            tlen_accept_unsubscribe(session,event->subscribe->jid);
            if(get_user(event->subscribe->jid))
            {
              add_user(NULL,event->subscribe->jid,"","none","","",
                       TLEN_STATUS_UNAVAILABLE, -1);
              list_reload_all();
              tlen_request_unsubscribe(session,event->subscribe->jid);
            }
            break;
          }
        case TLEN_EVENT_UNSUBSCRIBED:
          {
//            tlen_removecontact(session,event->subscribe->jid);
//            del_user(event->subscribe->jid);
//            if(get_user(event->subscrib)
            add_user(NULL,event->subscribe->jid,"","none","","",
                     TLEN_STATUS_UNAVAILABLE, -1);
              list_reload_all();
            break;
          }

        case TLEN_EVENT_MESSAGE:
          message_show(
                       event->message->from,
                       event->message->body,
                       event->message->stamp,
                       event->message->type);
		  notify_start(NOTIFY_NEWMSG, event->message->from);
          break;
        case TLEN_EVENT_PRESENCE:
          {
            struct user *user;
            gchar *d;

            user=get_user(event->presence->from);
            if(user)
            {
#ifndef DISABLE_DOCKLET
              if (event->presence->status < TLEN_STATUS_UNAVAILABLE)
              {
                gchar *tip;

                tip = g_strdup_printf ("%s jest dostpny",
                                       event->presence->from);
                docklet_set_tip (tip);
                g_free (tip);
              }
#endif
              if(preferences & PREF_BEEPONS)
                if((event->presence->status != TLEN_STATUS_UNAVAILABLE) &&
                   (event->presence->status != TLEN_STATUS_INVISIBLE))
                  if((user->status == TLEN_STATUS_UNAVAILABLE) ||
                     (user->status == TLEN_STATUS_INVISIBLE))
                  {
                    beep=1;
                  }

              d = event->presence->description;
              add_user(NULL, event->presence->from, NULL, NULL,
                       (!d)?"":d,NULL,
                       event->presence->status, USER_TLEN);
              window_talk_update_on_presence(event->presence->from);
              if(beep)
                play_sound(SOUNDS);
              beep=0;
              list_refresh();
            }
			tleenx_print(DEBUG, "presence from %s with state %s and message %s",
                     event->presence->from,
                     statusy[event->presence->status],
                     event->presence->description);
            break;
          }
        case TLEN_EVENT_NEWMAIL:
          {
//            GtkWidget *label;

            if(preferences & PREF_NEWMAIL)
            {
              if(preferences & PREF_BEEPONN)
                play_sound(SOUNDN);
              newmail(event->newmail->from, event->newmail->subject);
            }
            break;
          }
        case TLEN_EVENT_WEBMSG:
          {
            if(preferences & PREF_BEEPONW)
              play_sound(SOUNDW);
            my_create_window_webmsg(event->webmsg->from, event->webmsg->email,
                                    event->webmsg->site, event->webmsg->body);
            break;
          }
        case TLEN_EVENT_PUBDIR_GOTDATA:
          {
            if(window_card)
            {
              window_card_gotdata(event);
              window_card_hide_thobber();
            }
            break;
          }
        case TLEN_EVENT_PUBDIR_GOTUPDATEOK:
          {
            if(window_card)
              window_card_hide_thobber();
            break;
          }
        case TLEN_EVENT_GOTSEARCHITEM:
          {
            if(window_search)
            {
              struct tlen_pubdir *pubdir;

              pubdir = tlen_new_pubdir();
              memcpy((void*)pubdir, (void*)event->pubdir, sizeof(*pubdir));
              pubdir->firstname = g_strdup(event->pubdir->firstname);
              pubdir->lastname = g_strdup(event->pubdir->lastname);
              pubdir->nick = g_strdup(event->pubdir->nick);
              pubdir->city = g_strdup(event->pubdir->city);
              pubdir->email = g_strdup(event->pubdir->email);
              pubdir->school = g_strdup(event->pubdir->school);
              pubdir->id = g_strdup(event->pubdir->id);
              pubdir_list_add(pubdir);
            }
            break;
          }
        case TLEN_EVENT_ENDSEARCH:
          {
            GtkWidget *image;

            if(window_search)
            {
              image=lookup_widget(window_search,"thobber");
              gtk_widget_hide(image);
              search_update();
            }
            break;
          }
      }
      tlen_freeevent(event);
    }     /* while(event=tlen_getevent(session)) */


  }

  if(s != desc_xmms)
    set_status(status);
  s = desc_xmms;
  return (TRUE);

}


gint pinguj(gpointer data)
{
  if(session)
    tlen_ping (session);
  return TRUE;
}


/* timer function to do some nice stuff like changing docklet icon on new
 * msg arrival etc. TODO
 * !!! I'm still workin' on this stuff - do not touch! --esack !!! */
gint notify_timer(gpointer data)
{
	GList *ulist = users_list;
	struct user *user = NULL;

#ifndef DISABLE_DOCKLET
	if(status_docklet)
		docklet_notify_blink();
#endif
	
	while(ulist) {
		user = (struct user*)ulist->data;
		if(user)
			switch(user->pending_event) {
				case NOTIFY_NEWMSG:
					tleenx_print(DEBUG, "notify_timer(): new msg from %s\n",
							user->jid);
					list_refresh();
					break;
			}
		ulist = ulist->next;
		user = NULL;
	}
	
	return TRUE;
}


gpointer initialization(gpointer g)
{
  struct tlen_event *event;
  struct timeval tv;
  int terminate=0;


  while((!terminate) && (!session->error))
  {
    fd_set rd, wr;
    int retval;

    tv.tv_sec = 60;
    tv.tv_usec = 0;
    FD_ZERO (&rd);
    FD_ZERO (&wr);

    if ((session->check & TLEN_CHECK_READ))
      FD_SET (session->fd, &rd);
    if ((session->check & TLEN_CHECK_WRITE))
      FD_SET (session->fd, &wr);

    if ((retval = select (session->fd + 1, &rd, &wr, NULL, &tv) == -1))
    {
      perror ("select");
      gtk_exit(1);
    }
    if (session && (FD_ISSET (session->fd, &rd) || FD_ISSET (session->fd, &wr)))
    {
      tlen_watch_fd (session);
      while (((event=tlen_getevent(session))!=NULL))
      {
        if(session->error == TLEN_ERROR_UNAUTHORIZED)
        {
          return NULL;
        }
        switch (event->type)
        {
          case TLEN_EVENT_AUTHORIZED:
            {
              tlen_getroster(session);
              break;
            }
          case TLEN_EVENT_GOTROSTERITEM:
            {
              //            gchar *el;
              gchar *name, *group, *ask;

              if(!(event->roster->name))
                name = g_strdup("");
              else
                name = g_strdup(event->roster->name);
              if(!(event->roster->group))
                group = g_strdup("");
              else
                group = g_strdup(event->roster->group);
              if(!(event->roster->ask))
                ask = g_strdup("");
              else
                ask = g_strdup(event->roster->ask);
              add_user(name, event->roster->jid, group,
                       event->roster->subscription, "",
                       ask,
                       TLEN_STATUS_UNAVAILABLE, USER_TLEN);
              g_free(name);
              g_free(group);
              g_free(ask);
              break;
            }
          case TLEN_EVENT_ENDROSTER:
            {
              tlen_presence(session,status,
                            opisy[status-2]);
			  add_virtualusers();
              terminate=1;
              online=TRUE;
              break;
            }
        }
        tlen_freeevent(event);
        if(terminate)
          break;
      }     /* while(event=tlen_getevent(session)) */

    }
  }
  return NULL;
}

gint oczekiwanie(gpointer data)
{
  static gboolean blank=FALSE;

  if(blank)
  {
    gtk_window_set_title(GTK_WINDOW(window1),"");
#ifndef DISABLE_DOCKLET
    if(status_docklet) docklet_change_status(TLEN_STATUS_UNAVAILABLE);
#endif
    blank=FALSE;
  }
  else
  {
    gtk_window_set_title(GTK_WINDOW(window1),"TleenX2");
#ifndef DISABLE_DOCKLET
    if(status_docklet) docklet_change_status(TLEN_STATUS_AVAILABLE);
#endif
    blank=TRUE;
  }
  if(!online)
  {
    if(session->error)
    {
      tlen_presence (session,TLEN_STATUS_UNAVAILABLE,
                     opisy[TLEN_STATUS_UNAVAILABLE-2]);
      session=NULL;
      info("Wystpi bd podczas logowania");
      wyloguj();
      my_create_window_login();
      return FALSE;
    }
    tleenx_print(DEBUG, ".");
  }
  else
  {
    gchar *title, *s;
    GtkWidget *widget;

    gtk_timeout_remove(timerid);
    widget=lookup_widget(window1, "togglebutton_hide");
    if(preferences & PREF_HIDE_OFFLINE)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
    list_reload_all();
    timerid2 = gtk_timeout_add (60000, pinguj , NULL);
    timerid = gtk_timeout_add (1000, timer , NULL);
    timerid3 = gtk_timeout_add (300000, chat_list_flush , NULL);
	notify_timerid = gtk_timeout_add(600, notify_timer, NULL);
    title=g_strdup_printf("TleenX2 - %s",pname);
    s = utf(title);
    gtk_window_set_title(GTK_WINDOW(window1),s);
    g_free(s);
    status_button_set(status);
#ifndef DISABLE_DOCKLET
    if(status_docklet) docklet_change_status(status);
#endif
    gtk_window_set_icon(GTK_WINDOW(window1),
                        gtk_image_get_pixbuf(GTK_IMAGE(icons[status])));
    g_free(title);

    if(preferences & PREF_JABBER_CONNECT)
    {
      jabber_new();
      jabber_login();
    }
    if(preferences & PREF_XMMS_INFO)
      xmms_info_enable(TRUE, 0);
    if((preferences & PREF_LIST_EXPANDED) &&
       (preferences & PREF_GROUPS_LIST))
      gtk_tree_view_expand_all(GTK_TREE_VIEW(treeview1));
    return FALSE;
  }
  return TRUE;
}

void work_online()
{
  GError *er;

  session = tlen_init();
  tlen_set_auth(session, profile->login, profile->password);
  tlen_set_hub_blocking(session,0);
  tlen_login(session);
  if(session->error)
  {
    info("Wystpi bd podczas logowania.");
    wyloguj();
    my_create_window_login();
  }
  g_thread_create(initialization,NULL,FALSE,&er);
  timerid = gtk_timeout_add (1000, oczekiwanie , NULL);
}

void info(gchar *info)
{
  GtkWidget *window, *label;
  gchar *s;

  window = create_window_info();
  label = lookup_widget(window,"label");
  s = utf(info);
  gtk_label_set_text(GTK_LABEL(label),s);
  g_free(s);
  gtk_widget_show(window);
}

gboolean file_exists(const gchar *filename)
{
  FILE *f;

  f=fopen(filename,"r");
  if(!f)
    return FALSE;
  fclose(f);
  return TRUE;
}

gchar *filenameutf(gchar *in)
{
  gsize r,w;

  return g_filename_to_utf8(in,-1,&r,&w,NULL);
}

gchar *filenamefromutf(gchar *in)
{
  gsize r,w;

  return g_filename_from_utf8(in,-1,&r,&w,NULL);
}

gchar *utf(const gchar *in)
{
  gsize r, w;
//  return (!in) ? NULL : g_locale_to_utf8(in, -1, &r, &w, NULL);
  return (!in) ? NULL: g_convert(in,-1,"UTF-8","iso-8859-2",&r,&w,NULL);
}

gchar *fromutf(const gchar *in)
{
  gsize r, w;
//  return (!in) ? NULL : g_locale_from_utf8(in, -1, &r, &w, NULL);
  return (!in) ? NULL: g_convert(in,-1,"iso-8859-2","UTF-8",&r,&w,NULL);
}


void set_status(gint tlen_status)
{
  gchar *u = NULL, *nou = NULL;
  GString *s = NULL;


  if(desc || desc_xmms || desc_time)
    s = g_string_new("");
  if(desc)
    s = g_string_append(s, desc);
  if(desc_xmms)
  {
    if(desc)
      s = g_string_append(s, "\n");
    g_string_append_printf(s, "NL: %s", desc_xmms);
  }
  if(desc_time)
  {
    if(desc || desc_xmms)
      s = g_string_append(s, "\n");
    g_string_append_printf(s, "[%s]", desc_time);
  }
  if(s)
  {
    nou = g_string_free(s, FALSE);
    u = utf(nou);
  }
  status_button_set(status);
  if(jabber_logged())
  {
    status_jabber_button_set(t_status_map[status]);
//    if(jabber_registered_to_gg())
//      status_gg_button_set(t_status_map[status]);
  }
  if(online)
  {
    if(nou)
      tlen_presence(session,status,nou);
    else
      tlen_presence(session,status, opisy[status-2]);
    gtk_window_set_icon(GTK_WINDOW(window1),
                        gtk_image_get_pixbuf(GTK_IMAGE(icons[status])));
#ifndef DISABLE_DOCKLET
    if(status_docklet) docklet_change_status(status);
#endif
    if(jabber_logged())
    {
      jabber_presence(t_status_map[status], u, NULL);
      if (jabber_registered_to_gg() && profile->ggserver)
        jabber_presence(t_status_map[status], u, profile->ggserver);
    }
  }
  else
    work_online();
  g_free(nou);
  g_free(u);
}


void tleenx_print(TleenxPrintType type, const gchar *format, ...)
{
	va_list args;
	gchar *output = NULL;
  
	if(!format)
		return;
 
	va_start(args, format);
	output = g_strdup_vprintf(format, args);
	va_end(args);
	
	if(!output) 
		return;
	
	switch(type) {
		case INFO:
			g_print("INFO: %s", output);
			break;
		case DEBUG:
			if(preferences & PREF_DEBUGON)
				g_print("DEBUG: %s", output);
			break;
		case ERROR:
			g_printerr("ERROR: %s", output);
			break;
		case WARNING:
			g_printerr("WARNING: %s", output);
			break;
	}
	
	g_free(output);  

}




