// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef GRAMMAR_INC
#define GRAMMAR_INC

#include "Dictionary.h"

namespace Torch {

/** This class contains the grammar of accepted sentences for a
    speech recognition experiment such as the one using SpeechHMM
    A grammar is a transition table where each node is a word.
    The user is responsible to set the transition table as he wishes.
    (by default, there are no transition!)

    @author Samy Bengio (bengio@idiap.ch)
*/
class Grammar : public Object
{
  public:
    /** the number of words in the grammar (different than the number
        of words in the dictionary, because the same word can appear twice
        in the grammar)
    */
    int n_words;
    /// the index of the words (in the dictionary object)
    int* words;
    /** this vector is used in SpeechHMM to keep the state index in the
        decoding state matrix, corresponding to the given word
    */
    int* start;
    /** the transition matrix. each true transition (i,j) means the
        word whose index is i can be followed by the word whose index is j
    */
    bool** transitions;

    ///
    Grammar(int n_words_);
    virtual ~Grammar();
};


}

#endif
