// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef INPUTS_SELECT_INC
#define INPUTS_SELECT_INC

#include "GradientMachine.h"

namespace Torch {

/** Machine which select a block of adjacent
    inputs, and put them in the outputs.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class InputsSelect : public GradientMachine
{
  public:
    int offset;

    //-----

    /** Select #n_selected_# inputs from #offset_#.
        (The input #offset_# will be included).
    */
    InputsSelect(int n_inputs_, int offset_, int n_selected_);

    //-----

    virtual void init();
    virtual int numberOfParams();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);
    virtual ~InputsSelect();
};


}

#endif
