// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MACHINE_INC
#define MACHINE_INC

#include "Object.h"
#include "Measurer.h"
#include "List.h"

namespace Torch {

/** #Object# which can compute some outputs,
    given some inputs.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class Machine : public Object
{
  public:
    /// Number of inputs for the machine
    int n_inputs;

    /// Number of outputs
    int n_outputs;

    /** The outputs of the machine.
        Usually, the list contains only one node.

        The integer in each node is the number
        of components in the pointer #ptr# of this node.
        
        The sum of these integers is #n_outputs#.
    */
    List *outputs;

    ///
    Machine();

    /** Given #inputs#, update #outputs#.
        The integer in each node of #inputs # is the number
        of components in the pointer #ptr# of this node.
        The sum of these integers is #n_inputs#.
    */
    virtual void forward(List *inputs) = 0;

    /// Reset the machine.
    virtual void reset() = 0;

    virtual ~Machine();
};


}

#endif

