#include "tra.h"

char*
trapath(char *name)
{
	char *home;

	if(name[0] == '/'
	|| (name[0] == '.' && name[1] == '/')
	|| (name[0] == '.' && name[2] == '.' && name[3] == '/'))
		return estrdup(name);

	home = getenv("home");
	if(home == nil)
		sysfatal("cannot read user name");

	return esmprint("%s/lib/tra/%s", home, name);
}


Replica*
dialreplica(char *name)
{
	char *bin;
	int p[2];

	bin = trapath(name);
	if(access(bin, 1) < 0)
		sysfatal("access %s: %r", bin);

	if(pipe(p) < 0)
		sysfatal("pipe: %r");

	switch(rfork(RFPROC|RFFDG|RFNOWAIT)){
	case -1:
		sysfatal("rfork dialreplica: %r");

	case 0:
		close(p[0]);
		dup(p[1], 0);
		dup(p[1], 1);
		execl(bin, name, nil);
		sysfatal("exec %s: %r", bin);

	default:
		close(p[1]);
		break;
	}
	return fd2replica(p[0], p[0]);
}

