/** 
  * CTrafStatsList.cc: Function definitions for the list stuff
  * Thankfully, STL templates did most of the complicated work 
  * for me so I just had to link the right bits into the right
  * hooks.

  * Extra functions: 
  * Constructor from single Entry;
  * Copy constructor
  * overloaded insertion (using insertion sort makes sense when you 
    know you always start with an empty list)
  * overloaded clear operator
  * storeToDatabase: takes a PgConnection pointer to a PostgreSQL database
    and stores all entries into said database.
  
*/
#include "trafstats.h"
#include "CTrafStatsList.h"
#include <iostream.h>

extern int verbosity;

CTrafStatsList::CTrafStatsList(const CTrafStatsEntry& entry) {
        push_front(entry);
}


CTrafStatsList::CTrafStatsList(CTrafStatsList& copy) {
        iterator i;
        for (i=copy.begin(); i!=copy.end(); ++i) {
                push_back(*i);
        }
	iCount = copy.count();
}

CTrafStatsList::CTrafStatsList& CTrafStatsList::insert(const CTrafStatsEntry& entry) {
	iterator i;
	iCount++;
	if(verbosity >= LOG_DEBUG+6) {
		syslog(LOG_DEBUG,"[sniffer] Seeking insert point.");
	}
	// Find the proper insert point.
	for(i=begin(); *i < entry && i!=end(); ++i);
	if(verbosity >= LOG_DEBUG+6) {
		syslog(LOG_DEBUG,"[sniffer] Insert point found.");
	}
	// Now, the current i is either a match for, or 'larger than'
	// the entry. 

	if(i->matches(entry)) { 
		// We already had this entry, so just add
		*i += entry;
		DLOG("Matched " << entry.asString()
			<< " with " << i->asString() << endl);
		return *this;
	} // else
	DLOG("New entry: " << entry.asString());	
	// New entry, call insert from parent class.
	list<CTrafStatsEntry>::insert(i,entry);
	
	return *this;
}

void CTrafStatsList::clear() {
	// The parent class already implements clear(), just need to zero 
	// the count
	list<CTrafStatsEntry>::clear();
	iCount=0;
}

bool CTrafStatsList::storeToDatabase(PgDatabase* conn) {
	// Store all entries into database.
        iterator i;
        for (i=begin(); i!=end(); ++i) {
		if(verbosity >= LOG_DEBUG) {
			syslog(LOG_DEBUG,"%s",i->asQuery().c_str());
		}
		int output=conn->ExecCommandOk(i->asQuery().c_str());
		if(!output && verbosity >= LOG_ERR) {
			syslog(LOG_ERR,"Insert query failed: %s",
				conn->ErrorMessage());
			syslog(LOG_ERR,"Query was: <%s>",
				i->asQuery().c_str());
		}
        }
	return true;
};
