#ifndef CAPLAYERSETTINGSDIALOG_H
#define CAPLAYERSETTINGSDIALOG_H

#include <ClanLib/core.h>
#include "caimagehueselector.h"
#include "calineedit.h"
#include "cadialog.h"

/** Dialog for adjusting player settings (Name, color, car, face)
    @author Andrew Mustun
*/
class CAPlayerSettingsDialog : public CADialog {
public:
    CAPlayerSettingsDialog();
    ~CAPlayerSettingsDialog();

    virtual void buildScreen();
    virtual void on_button_release( CL_InputDevice *device, const CL_Key &key );

    char* getPlayerName();
    int   getPlayerHue();

private:
    //! Line edit for players name

    CALineEdit*  nameInput;
    //! Car image hue selector.
    CAImageHueSelector* carImage;
};

#endif
