// system.c - TI99 Emulation System
//
// Copyright (c) 2001-2002, Timothy M. Stark
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// TIMOTHY M STARK BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of Timothy M Stark shall not
// be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from
// Timothy M Stark.

#include "ti99/defs.h"

#define TI99_KEY       "TI99"
#define TI99_NAME      "TI99 Series Emulator"
#define TI99_VERSION   "v0.1 (Alpha)"

// ******************************************************

DEVICE ti99_System; // Look at end of this file.

void *ti99_Create(MAP_DEVICE *newMap, int argc, char **argv)
{
	TI99_SYSTEM *ti99sys;

	if (ti99sys = (TI99_SYSTEM *)calloc(1, sizeof(TI99_SYSTEM))) {
		ti99sys->Unit.devName    = newMap->devName;
		ti99sys->Unit.keyName    = newMap->keyName;
		ti99sys->Unit.emuName    = newMap->emuName;
		ti99sys->Unit.emuVersion = newMap->emuVersion;

#ifdef DEBUG
		d99_BuildOpcodes();
#endif /* DEBUG */

		newMap->sysMap      = newMap;
		newMap->sysDevice   = ti99sys;
		newMap->Device      = ti99sys;
	}

	return ti99sys;
}

extern DEVICE ti99_System_994;
extern DEVICE ti99_System_994A;

DEVICE *ti99_Systems[] =
{
	&ti99_System_994,    // TI-99/4 Home Computer
	&ti99_System_994A,   // TI-99/4A Home Computer
//	&ti99_System_Geneve, // Geneve System
//	&ti99_System_99010,  // TI-990/10 Minicomputer
//	&ti99_System_99010A, // TI-990/10A Minicomputer
//	&ti99_System_99012,  // TI-990/12 Minicomputer
	NULL,
};

extern COMMAND ti99_Commands[];
extern COMMAND ti99_SetCommands[];
extern COMMAND ti99_ShowCommands[];

DEVICE ti99_System =
{
	// Description Information
	TI99_KEY,     // Device Type Name
	TI99_NAME,    // Emulator Name
	TI99_VERSION, // Emulator Version
	ti99_Systems, // Listing of TI99 Series Systems
	DF_SELECT,    // Device Flags
	DT_SYSTEM,    // Device Type

	ti99_Commands,     // Commands
	ti99_SetCommands,  // Set Commands
	ti99_ShowCommands, // Show Commands

	// Function Calls
	ti99_Create,    // Create Routine
	NULL,           // Configure Routine
	NULL,           // Delete Routine
	NULL,           // Reset Routine
	NULL,           // Attach Routine
	NULL,           // Detach Routine
	NULL,           // Info Routine
	NULL,           // Boot Routine
	ti99_Execute,   // Execute Routine
#ifdef DEBUG
	NULL,           // Debug Routine
#endif /* DEBUG */
};

