/*********************************************************************************
 *  TTCN-3 Parser - A Java based TTCN-3 Parser using ANTLR
 *  Copyright (C) 2000, 2001 Testing Technologies IST GmbH
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *********************************************************************************/
/* -----------------------------------------------------------------------------
 *
 *  AUTHOR:      Theofanis Vassiliou-Gioles
 *  DATE:        August, 2000
 *
 *  REVISION INFO:
 *	$Revision: 1.2 $ $Date: 2000/12/24 12:49:48 $
 *
 * -----------------------------------------------------------------------------
 */
import java.io.*;
import antlr.*;
import antlr.collections.AST;
import java.net.URL;

public class TTCN3Tool {
    public static void main(String[] argv) {

	ColumnAST 	theASTRoot;
	P		parser = null;
	L		lexer  = null;
	boolean 	errorOccured = false;

	String fileName = "test.ttcn3";

	if(argv.length != 0) fileName = argv[0];
    
	System.out.println("TTthreeParser version 1.4, Copyright (C) 2000 Testing Technologies IST GmbH");
	System.out.println("TTthreeParser is free software and comes with ABSOLUTELY NO WARRANTY;");
	System.out.println("for details consult the COPYRIGHT file.");

	System.out.println("Parsing : " + fileName);

	try 
	{
	    lexer = new L(new DataInputStream(new FileInputStream(fileName)));
	    lexer.setTokenObjectClass("ColumnToken");
	    lexer.setFilename(fileName);
	    parser = new P(lexer);
	    parser.setFilename(fileName);
	    parser.setASTNodeClass("ColumnAST");
	    parser.pr_TTCN3Module();
	} 
	catch(RecognitionException ex) 
	{
	    System.out.println(ex.getFilename()+ ":" + ex.getLine()+":"+ ex.getColumn()+":"+ex.getMessage());
	    System.out.println("Aborting Parsing ... ");
	    errorOccured = true;
	    return;
	}
	catch(TokenStreamRecognitionException tex) 
	{
	    RecognitionException ex = tex.recog;

	    System.out.println(ex.getFilename()+ ":" + ex.getLine()+":"+ ex.getColumn()+":"+ex.getMessage());
	    System.out.println("Aborting Parsing ... ");
	    errorOccured = true;
	    return;
	}
	catch(TokenStreamException ex)
	{
	    System.out.println(ex.getMessage());
	    System.out.println("Aborting Parsing ... ");
	    errorOccured = true;
	    return;
	}
	catch(FileNotFoundException ex)
	{
	    System.out.println("Error while opening " + fileName + ": " + ex.getMessage());
	    return;
	}
	catch(IOException ex)
	{
	    System.out.println("IO Exception : " + ex.getMessage());
	    return;
	}

	if(errorOccured || parser.errorOccured)
	{
	    System.out.println("(1) Errors occured while parsing");
	    System.exit(1);
	}
	else
	{
	    System.out.println("TTCN-3 Test Suite parsing completed");
	    System.exit(0);
	}
    }
}











