//-*-c++-*-
/*
 Author: Delorme Maxime
 Email : Maxime.Delorme@gmail.com

 Last modification : 29/07/2005 (fr) 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include "tulip/GlAugmentedDisplay.h"

using namespace std;

namespace tlp
{
  GlAugmentedDisplay::GlAugmentedDisplay() {
  }

  GlAugmentedDisplay::~GlAugmentedDisplay() {
  }

  void GlAugmentedDisplay::draw(GlGraph* graph) {
    // Virtual function
  }

  void GlAugmentedDisplay::changeRenderOptions() {
    // Virtual function
  }

  void GlAugmentedDisplay::setup()  {
    glPushAttrib(GL_ALL_ATTRIB_BITS);
    renderOptions.setup();
  }

  void GlAugmentedDisplay::unsetup()  {
    glPopAttrib();
  }

  void GlAugmentedDisplay::setRenderOptions(const GlADRenderOptions &renderOptions)
  {
    this->renderOptions.setRenderOptions(renderOptions);
  }

  void GlAugmentedDisplay::setRenderState(GlADRenderState renderState, bool value) {
    renderOptions.setRenderState(renderState, value);
  }

  bool GlAugmentedDisplay::getRenderState(GlADRenderState renderState) const {
    return renderOptions.getRenderState(renderState);
  }
}
