//-*-c++-*-
/*
 Author: Delorme Maxime
 Email : Maxime.Delorme@gmail.com

 Last modification : 24/08/2005 (fr) 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include "tulip/GlHudRect4.h"
#include <math.h>

using namespace std;

namespace tlp {

  GlHudRect4::GlHudRect4() {
    for(int i=0; i < N_RECT_POINTS; ++i){
      colors[i] = new Color();
      positions[i] = new Coord();
    }
  }
  //============================================================
  GlHudRect4::GlHudRect4(const Coord &topLeftPos, const Coord &topRightPos, const Coord &bottomRightPos, const Coord &bottomLeftPos, const Color &color) {
    positions[0] = new Coord(topLeftPos);
    positions[1] = new Coord(topRightPos);
    positions[2] = new Coord(bottomRightPos);
    positions[3] = new Coord(bottomLeftPos);
    for(int i=0; i < N_RECT_POINTS; ++i)
      colors[i] = new Color(color);
  }
  //============================================================
  GlHudRect4::GlHudRect4(Coord positions[4], const Color &color) {
    for(unsigned int i=0; i < N_RECT_POINTS; ++i) {
      this->positions[i] = new Coord(positions[i]);
      colors[i] = new Color(color);
    }			 			       
  }
    //============================================================
  GlHudRect4::~GlHudRect4() {
    for(unsigned int i=0; i < N_RECT_POINTS; ++i) {
      delete positions[i];
      delete colors[i];
    }
  }
  //============================================================
  void GlHudRect4::draw(GlGraph *graph) {
    setup();
    
    GLfloat* glCols[N_RECT_POINTS];
    Coord points[N_RECT_POINTS];
    
    for(unsigned int i=0; i < N_RECT_POINTS; ++i)
      points[i] = *positions[i];
    for(unsigned int i=0; i < N_RECT_POINTS; ++i)
      glCols[i] = colors[i]->getGL();
    for(unsigned int i=0; i < N_RECT_POINTS; ++i)
      points[i] = transformCoordinates(points[i]);

    if (getRenderState(GlAD_Solid)) {
      glBegin(GL_QUADS);
      for(unsigned int i=0; i < N_RECT_POINTS; ++i) { 
	glColor4fv(glCols[i]);
	glVertex3d(points[i][0], points[i][1], points[i][2]);
      }
      glEnd();
    }
    if (getRenderState(GlAD_Wireframe)) {
      glBegin(GL_LINE_STRIP);
      if (getRenderState(GlAD_Solid)) {
	GLfloat colBk[4] = {0.0f, 0.0f, 0.0f, 255.0f};
	for(int i=0; i < N_RECT_POINTS; ++i)
	  glCols[i] = colBk;
      }
      for(unsigned int i=0; i <= N_RECT_POINTS; ++i) {
	unsigned int id = i % N_RECT_POINTS;
	glColor4fv(glCols[id]);
	glVertex3d(points[id][0], points[id][1], points[id][2]);
      }
      glEnd();
    }
    unsetup();
  }
  //============================================================
  Coord GlHudRect4::getPosition(int id) const {
    if (id < 0 || id >= N_RECT_POINTS)
      return Coord(0, 0, 0);
    
    return *positions[id];
  }
  //============================================================
  Color GlHudRect4::getColor(int id) const {
    if (id < 0 || id >= N_RECT_POINTS)
      return Color(0, 0, 0, 0);
    return *colors[id];
  }
  //============================================================
  void GlHudRect4::setPosition(int id, const Coord &position) {
    if (id < 0 || id >= N_RECT_POINTS)
      return;
    delete positions[id];
    positions[id] = new Coord(position);
  }
  //============================================================
  void GlHudRect4::setColor(int id, const Color &color) {
    if (id < 0 || id >= N_RECT_POINTS)
      return;

    delete colors[id];
    colors[id] = new Color(color);
  }
  //============================================================
  void GlHudRect4::translate(const Coord delta) {
    for(unsigned int i=0; i < N_RECT_POINTS; ++i)
      *positions[i] += delta;
  }
  //============================================================
  void GlHudRect4::rotate(double angle) {
    Coord centerRect = (*positions[0] + *positions[2]) / 2.0;

    for(unsigned int i=0; i < N_RECT_POINTS; ++i) {

      double x = positions[i]->getX() - centerRect[0];
      double y = positions[i]->getY() - centerRect[1];
	
      double length = sqrt((x * x) + (y * y));

      x /= length;
      y /= length;

      double baseAngle = acos(x);
      if (y < 0)
	baseAngle *= -1.0;
	
      positions[i] = new Coord(cos(angle + baseAngle), sin(angle + baseAngle), 1);
      *positions[i] = *positions[i] * length + centerRect;
      positions[i]->setZ(1);
    }
  }
}
