//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef SQUARIFIEDTREEMAP_H
#define SQUARIFIEDTREEMAP_h

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

#include <vector>
#include <utility>
#include "tulip/TulipPlugin.h"
#include "tulip/RectangleArea.h"

typedef std::vector<tlp::node> vecNode;
typedef stdext::hash_map<tlp::node, float> mapNode;
typedef std::pair<tlp::node, float> pairNodeF;
typedef std::vector<pairNodeF> pairVector;
typedef pairVector::iterator pairIterator;

/** \addtogroup layout */
/*@{*/
/// SquarifiedTreeMap.h - An implementation of a squarified treemap layout.
/** This plugin is an implementation of a Squarified treemap layout.
 * 
 *  Squarified Treemaps : \n
 *  Bruls, M., Huizing, K., & van Wijk, J. J. \n
 *  In Proc. of Joint Eurographics and IEEE TCVG Symp. on Visualization \n
 *  (TCVG 2000) IEEE Press, pp. 33-42.
 * 
 *  \note This algorith only works on tree.
 *  Let n be the number of nodes, the algorithm complexity is in O(n).
 *
 *  \author Julien Testut, Antony Durand, Pascal Ollier, Yashvin Nababsing, \n 
 *  Sebastien Leclerc, Thibault Ruchon, Eric Dauchier \n
 *  University Bordeaux I France
 */
class SquarifiedTreeMap: public tlp::LayoutAlgorithm {
   friend class SquarifiedTreeMapUnitTests; 

public:
    SquarifiedTreeMap(const tlp::PropertyContext&);
    ~SquarifiedTreeMap();

    bool check(std::string&);
    bool run();

private:
    tlp::SizeProperty*     size;   
    tlp::DoubleProperty*    metric;
    tlp::IntegerProperty*   glyph;
    mapNode    sumChildrenMetric;
    float      aspectRatio;
    
    void    layRow(pairIterator firstChildNode, pairIterator endChildNode,
                   int depth, tlp::RectangleArea rectArea, float listMetric);
    void    squarify(tlp::node n, tlp::RectangleArea rectArea, int depth);
    float   findWorstRatio(float metric1, float metric2, float listMetric, 
                           const tlp::RectangleArea& rectArea);
    float   initializeMapSum(tlp::node n);
    bool    verifyMetricIsPositive();       

};
/*@}*/
#endif
