<?php
/**
 * $Horde: turba/delete.php,v 1.29.4.1 2005/01/03 12:25:47 jan Exp $
 *
 * Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

@define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';

$source = Util::getFormData('source');
$driver = &Turba_Driver::singleton($source, $cfgSources[$source]);

$key = Util::getFormData('key');
if (!is_a($result = $driver->delete($key), 'PEAR_Error')) {
    if (!empty($_SESSION['turba_search_results'])) {
        require_once TURBA_BASE . '/lib/List.php';
        require_once TURBA_BASE . '/lib/Object.php';
        $list = Turba_List::unserialize($_SESSION['turba_search_results']);
        $list->remove($key);
        $_SESSION['turba_search_results'] = $list->serialize();
    }

    header('Location: ' . Util::getFormData('url', Horde::url($prefs->getValue('initial_page'), true)));
    exit;
}

$notification->push(sprintf(_("There was an error deleting this contact: %s"), $result->getMessage()), 'horde.error');
$title = _("Deletion failed");
require TURBA_TEMPLATES . '/common-header.inc';
require TURBA_TEMPLATES . '/menu.inc';
require $registry->get('templates', 'horde') . '/common-footer.inc';
