<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup BASE
 * @module acl_ins
 * @package acl
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();

 /* Check Input */
 $msg = "";

 $obj = array();

 $gotourl = "mytutos.php";
 if ( !isset($_POST['id']) ) {
   $msg .= "Missing ID<br>";
 } else {
   if (! is_Array($_POST['id'])) {
     $id[0] = $_POST['id'];
   } else {
     $id = $_POST['id'];
   }
   foreach($id as $val) {
     $x = getObject($dbconn,$val);
     if ( $x == -1 ) {
       $msg .= sprintf($lang['Err0040'],"Object ". $val);
     } else if ( ! $current_user->isadmin() && ! $x->del_ok() ) {
       # we need delete permissions but talk about modify !
       $msg .= sprintf($lang['Err0024'],$lang[$x->getType()]);
	   if ($val->getType() != "url") {
         $gotourl = $val->getURL();
	   }
     } else {
       $obj[] = &$x;
     }
     unset($x);
   }
 }
 if ( isset($_POST['keep']) ) {
   $keep = true;
 } else {
   $keep = false;
 }
 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   foreach($obj as $val) {
     if ( ! $keep ) {
       unset($val->acl);
	 }
     if ( isset($_POST['r']) ) {
       @reset($_POST['r']) ;
       while ( list ($i,$f) = @each ($_POST['r']) ) {
         acl_raise($val,$f,$tutos[seeok]);
       }
     }
     if ( isset($_POST['m']) ) {
       @reset($_POST['m']) ;
       while ( list ($i,$f) = @each ($_POST['m']) ) {
         acl_raise($val,$f,$tutos[modok]);
       }
     }
     if ( isset($_POST['d']) ) {
       @reset($_POST['d']) ;
       while ( list ($i,$f) = @each ($_POST['d']) ) {
         acl_raise($val,$f,$tutos[delok]);
       }
     }
     $msg .= acl_save($val);
     if ($val->getType() != "url") {
       $gotourl = $val->getURL();
	 }
   }
   $dbconn->Commit("WORK");
 }

 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: acl_ins.php,v 1.24.2.2 2003/06/18 14:34:32 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
