<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup appointment
 * @module app_ins
 * @package appointment
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("appointment","new");

 if ( ! isset($_POST['gotourl']) ) {
   $gotourl="app_new.php";
 } else {
   $gotourl=$_POST['gotourl'] ;
 }
 $msg = "";

 $a = new appointment($dbconn);
 #
 # ID
 #
 if ( isset($_POST['id']) ) {
   $gotourl= addUrlParameter($gotourl,"id=".$_POST['id']);
   $a->read($_POST['id']);
 }


 if ( isset($_POST['t_ignore']) ) {
   $a->t_ignore = 1;
 } else {
   $a->t_ignore = 0;
 }
 if ( isset($_POST['r_ignore']) ) {
   $a->r_ignore = $_POST['r_ignore'];
 } else {
   $a->r_ignore = 0;
 }
 $gotourl= addUrlParameter($gotourl,"t_ignore=".$a->t_ignore);
 $gotourl= addUrlParameter($gotourl,"r_ignore=".$a->r_ignore);

 # Set the Start and End time

 $a->start->setDateTimeF("start");
 if ( (1 != $a->start->checkDMY()) || (-1 == $a->start->getTimeStamp() ) ) {
   $msg .= sprintf($lang['Err0038'],$lang['StartDate']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"start=".$a->start->getYYYYMMDDHHMM() );
 }

 $a->end->setDateTimeF("end");
 if ( (1 != $a->end->checkDMY()) || (-1 == $a->end->getTimeStamp()) ) {
   $msg .= sprintf($lang['Err0038'],$lang['EndDate']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"end=".$a->end->getYYYYMMDDHHMM() );
 }

 #
 # Checks
 #
 if ( ($a->start->ts > $a->end->ts) && ($a->r_ignore == 0) ) {
   # Start after End
   $msg .= $lang['Err0002'] ."<br>";
 }

 if ( !isset($_POST['people']) || (count($_POST['people']) < 1)) {
   # No Participants
   $msg .= $lang['Err0001'] ."<br>";
 } else {
   $cnt = 0;
   foreach ($_POST['people'] as $f) {
     if ( $f != "" ) {
       $gotourl= addUrlParameter($gotourl,"people[]=".$f );
       $cnt++;
       $obj = GetObject($dbconn, $f);
       if (  $obj->id == $f ) {
         $a->participant[$f] = &$obj;
         $a->participant_state[$f] = 0;
       }
       unset($obj);
     }
   }
   if ( $cnt == 0 ) {
     $msg .= $lang['Err0001'] ."<br>";
   }
 }

 if ( !isset($_POST['mod_allow']) ) {
   $msg .= "Missing mod_allow<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"mod_allow=".$_POST['mod_allow'] );
   $a->mod_allow = $_POST['mod_allow'];
 }

 if ( !isset($_POST['creator']) ) {
   $msg .= "Missing creator<br>";
 } else {
   $a->creator = new tutos_user($dbconn);
   $a->creator->read($_POST['creator']);
 }
 #
 # TRACE
 #
 if ( !isset($_POST['trace']) ) {
   $a->setTrace(0);
 } else {
   $a->setTrace($_POST['trace']);
 }
 $gotourl= addUrlParameter($gotourl,"trace=".$a->trace );
 #
 # EMAIL
 #
 if ( !isset($_POST['email']) ) {
   $a->email = 0;
 } else {
   $a->email = $_POST['email'];
 }
 $gotourl= addUrlParameter($gotourl,"email=".$a->email );
 #
 # OUTSIDE
 #
 if ( !isset($_POST['outside']) ) {
   $a->SetLocation(0);
 } else {
   $a->SetLocation($_POST['outside']);
 }
 $gotourl= addUrlParameter($gotourl,"outside=".$a->outside );
 #
 # REPEAT
 #
 if ( !isset($_POST['repeat']) ) {
   $a->repeat = 0;
 } else {
   $a->repeat = $_POST['repeat'];
 }
 $gotourl= addUrlParameter($gotourl,"repeat=".$a->repeat);

 if ( $a->repeat == 0 ) {
   $a->r_arg      = "";
 } else if ( $a->repeat == 1 ) {
   $a->r_arg      = Date("w",$a->start->GetTimeStamp());
 } else if ( $a->repeat == 2 ) {
   $a->r_arg      = Date("j",$a->start->GetTimeStamp());
 } else if ( $a->repeat == 3 ) {
   $a->r_arg      = Date("j/n",$a->start->GetTimeStamp());
 } else if ( $a->repeat == 4 ) {
   $a->r_arg      = "";
 }
 #
 # REMEMBER
 #
 if ( !isset($_POST['remember']) ) {
   $a->setRemember(0);
 } else {
   $a->setRemember($_POST['remember']);
 }
 $gotourl= addUrlParameter($gotourl,"remember=".$a->remember );
 #
 # DESCRIPTION
 #
 if ( isset($_POST['descr']) && ! empty($_POST['descr']) ) {
   $a->SetDescription(StripSlashes(trim($_POST['descr'])));
 }
 $gotourl = addUrlParameter($gotourl,"descr=". UrlEncode($a->descr) );
 #
 # VISITOR
 #
 # Clear Visitor Address
 $a->visitor = new tutos_address($dbconn);
 if ( isset($_POST['vfn']) && !empty($_POST['vfn']) ) {
   $a->visitor = check_field(StripSlashes($_POST['vfn']),"vfn","vl","acd");
 } else {
   if ( isset($_POST['vid']) && !empty($_POST['vid']) ) {
     if ( $_POST['vid'] != -1 ) {
       $a->visitor = getObject($dbconn,$_POST['vid']);
     }
   }
 }
 #
 # PRODUCT
 #
 $p = new product($dbconn);
 if ( isset($_POST['pfn']) && !empty($_POST['pfn']) ) {
   $p = check_field(StripSlashes($_POST['pfn']),"pfn","pl","p");
 } else {
   if ( isset($_POST['pid']) && !empty($_POST['pid']) ) {
     if ( $_POST['pid'] != -1 ) {
       $p->read($_POST['pid']);
     }
   }
 }
 $a->setProduct($p);
 # other modules
 $msg .= module_parseforms($current_user,$a,$gotourl);

 # check availability of participants and resources
 if ( ($msg == "") && (isset($_POST['check']) && $_POST['check'] == 1) ) {
   $gotourl= addUrlParameter($gotourl,"check=".$_POST['check'] );
   $a->check_participants($msg);
 }


 ##################################################
 # End of Checks
 ##################################################
 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   $msg .= $a->save();
   $dbconn->Commit("WORK");

   /* Go back to calendar */
   $gotourl = "calendar.php";
   $gotourl= addUrlParameter($gotourl,"id=".$a->id);
 }

$_SESSION['MSGID'.$a->id] = UrlEncode($msg);
$gotourl = addUrlParameter($gotourl,"msgid=MSGID". $a->id);

 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
/*
 *
 *   CVS Info:  $Id: app_ins.php,v 1.31.2.2 2003/06/14 10:28:46 gokohnert Exp $
 *   $Author: gokohnert $
 *
 */
?>