<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup bug
 * @module bug_show
 * @package bug
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bug","show");
 loadlayout();

 /**
  * display a bug
  */
 class bug_show extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $tutos,$lang;

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">". sprintf($lang['Showing'],$lang['Bug'] ." ". $this->obj->getFullName()) ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['createdby']);
     echo $this->showdata($this->obj->creator->getLink());
     echo $this->showfield($lang['atDateTime']);
     echo $this->showdata($this->obj->creation->getDateTime());

     echo "</tr><tr>\n";
     echo $this->showfield($lang['BugID']);
     echo $this->showdata(myentities($this->obj->name),3);

     echo "</tr><tr>\n";
     if ( $this->obj->state == 3 ) {
       echo $this->showfield($lang['BugSolvedBy']);
     } else if ( $this->obj->state == 4 )  {
       echo $this->showfield($lang['BugClosedBy']);
     } else {
       echo $this->showfield($lang['BugAssignedTo']);
     }
     if ( $this->obj->solver->id > 0 ) {
       echo $this->showdata($this->obj->solver->getLink(),1);
     } else {
       echo $this->showdata("not solved",1);
     }
     echo $this->showfield($lang['atDateTime']);
     if ( isset($this->obj->solvedate) ) {
       echo $this->showdata($this->obj->solvedate->getDateTime(),1);
     } else {
       echo $this->showdata("&nbsp;",1);
     }
     echo "</tr><tr>\n";

     if ( $this->obj->parent->id > 0 ) {
       echo $this->showfield($lang[$this->obj->parent->getType()]);
       echo $this->showdata($this->obj->parent->getLink(),3);
     } else {
       echo $this->showfield($lang['ProductP']);
       echo $this->showdata($lang['HistoryDeleted'],3);
     }
     echo "</tr><tr>\n";
     echo $this->showfield($lang['BugState']);
     echo $this->showdata($this->obj->getState(),1);
     echo $this->showfield($lang['BugClass']);
     echo $this->showdata($this->obj->getClass(),1);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['BugShort']);
     echo $this->showdata(myentities($this->obj->short),3);

     if ( $this->user->feature_ok(usetimetrack,PERM_SEE) ) {
       $this->obj->readTimetrackSum();
       if ( $this->obj->timetracksum > 0) {
         echo "<tr>\n";
         echo $this->showfield($lang['Timetrack']);
         echo " <td valign=\"top\" colspan=\"3\">\n";
         echo makelink("timetrack_overview.php?link_id=". $this->obj->id ,number_format($this->obj->timetracksum,2),$lang['TimetrackOverview']);
         echo "&nbsp;". $lang['hours'] ."</td>\n";
         echo "</tr>\n";
       }
     }

     echo "</tr><tr>\n";
     echo $this->showfield($lang['BugHistory']);
     echo " <td class=\"pre\" colspan=\"3\">";
     echo "<pre>\n". wordwrap(urlReplace($this->obj->description,0),80) ."\n</pre></td>\n";
     echo "</tr>\n";

     show_module_infolists($this->user,$this->obj,4,$this->format);

     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$current_user;

     $this->name = $lang['BugsDetail'];
     $this->obj = new bug($this->dbconn);

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     } else {
       $msg .= $lang['Err0048'] ."<br>";
       $this->stop = true;
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->name .=": ". $this->obj->getFullName();
     }
     # menu
     $x = bug::getSelectLink($this->user,$lang['Search']);
	 $x[category][] = "obj";
     $this->addmenu($x);

     if ( $this->user->feature_ok(usebugtracking,PERM_NEW) ) {
       # Pre select the same project as the one of the current bug
       $x = array( url => "bug_new.php?pid=".$this->obj->parent->id,
                   text => $lang['NewEntry'],
                   info => $lang['CreateNewBug'],
                   category => array("bug","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => "bug_new.php?id=".$this->obj->id,
                   text => $lang['Modify'],
                   info => sprintf($lang['BugModifyI'],$this->obj->getFullname()),
                   category => array("bug","mod","obj")
                 );
       $this->addMenu($x);
     }

     $x = timetrack::getaddlink($this->user,$this->obj);
     $this->addMenu($x);

     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
     $this->addtohistory();
   }
 }

 $l = new bug_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: bug_show.php,v 1.53.2.5 2003/07/14 17:48:48 gokohnert Exp $
    $Author: gokohnert $
-->