<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_overview
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';
 include_once 'bug.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","overview");
 loadlayout();

 /**
  * show a overview of task for user / project
  */
 class task_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     task_calc($this->parent);

     if ( $tutos[massupdate] == 1 ) {
       echo "<form name=\"actionform\" method=\"get\" action=\"task_overview.php\">\n";
       echo "<script type=\"text/javascript\" language=\"JavaScript\">\n";
       echo "<!--\n";
       echo "function CheckAll2() {\n";
       echo "  for (var i=0; i < document.forms['actionform'].elements.length; i++) {\n";
       echo "   var e = document.forms['actionform'].elements[i];\n";
       echo "   if (e.name != 'checkit')\n";
       echo "     e.checked = document.forms['actionform'].checkit.checked;\n";
       echo "  }\n";
       echo "}\n";
       echo "function disableArg() {\n";
       echo "  tofocus = (document.actionform.action.value == 'timeslice')\n";
       echo "         || (document.actionform.action.value == 'timeslice_s')\n";
       echo "         || (document.actionform.action.value == 'timeslice_e');\n";
       echo "  if ( tofocus ) {\n";
       echo "    document.actionform.arg.disabled = false;\n";
       echo "    document.actionform.arg.value = '';\n";
       echo "    document.actionform.arg.blur();\n";
       echo "  } else {\n";
       echo "    document.actionform.arg.disabled = true;\n";
       echo "    document.actionform.arg.focus();\n";
       echo "    document.actionform.arg.value = '1';\n";
       echo "  }\n";
       echo "}\n";
       echo "//-->\n";
       echo "</script>\n";
     }
     
     if( ! isset($this->start) || $this->start == 0) {
       $this->start = $this->parent->min_start;
       $this->end   = $this->parent->max_end;
     }

     /* We add some date selection */
     echo "<p align=\"center\">\n";
     echo $this->DataTableStart();

     echo " <tr>\n";
     echo $this->showfieldc($lang['StartDate'],0,"start_d");
     echo "  <td colspan=\"3\">\n";
     $this->start->EnterDate("start");
     echo "</td>\n";

     echo "<td align=\"center\" rowspan=\"2\">";
     echo "<input type=\"submit\" value=\"".$lang['Enter']."\">";
     echo "</td>\n";

     echo " </tr>\n";

     echo " <tr>\n";
     echo $this->showfieldc($lang['EndDate'],0,"end_d");
     echo "  <td colspan=\"3\">\n";
     $this->end->EnterDate("end");
     echo "</td>\n";
     echo " </tr>\n";

     echo $this->DataTableEnd();

     echo "<p>\n";

     echo $this->OverviewTableStart();
     $cols = 9;
     echo " <thead>\n";
     echo " <tr>\n";
     echo "  <th colspan=\"". $cols ."\" width=\"100%\">". $lang['TaskOverview'] ." ". $lang['forphrase'] ." " . menulink($this->parent->getURL(),$this->parent->getFullName()) ."</th>\n";
     echo " </tr>\n";
     echo " <tr>\n";
     echo "  <td colspan=\"2\" class=\"desc\" nowrap>&nbsp;". $lang['TaskVolumeFull'] ."&nbsp;</td>\n";
     echo "  <td colspan=\"2\">&nbsp;". number_format($this->parent->sum['volume'],2) ." ". $lang['hours'] ."</td>\n";
     echo "  <th colspan=\"1\" rowspan=\"2\" nowrap>". $lang['AppStart'] ."<br>". $this->start->getDate() ."</th>\n";
     echo "  <th colspan=\"1\" rowspan=\"2\" nowrap>". $lang['AppEnd'] ."<br>". $this->end->getDate() ."</th>\n";
     if (  $this->parent->sum['volume'] != 0 ) {
       $c = ( 100.0 * ( $this->parent->sum['volume_done'] / $this->parent->sum['volume'] ));
     } else {
       $c = 0.0;
     }
     echo "  <td colspan=\"2\" rowspan=\"3\" align=\"right\" class=\"desc\">&nbsp;". $lang['Completed'] .":&nbsp;<font size=\"+2\">". sprintf("%3.2f %%",$c) ."</font></td>\n";
     if ( $tutos[massupdate] == 1 ) {
       # Checkbox column for massupdate
       echo "  <th rowspan=\"3\" nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     } else {
       echo "  <td rowspan=\"3\" nowrap>&nbsp;</td>\n";
     }
     echo " </tr>\n";

     echo " <tr>\n";
     echo "  <td colspan=\"2\" rowspan=\"2\" class=\"desc\" nowrap>&nbsp;". $lang['TaskVolumeDone'] ."&nbsp;</td>\n";
     echo "  <td colspan=\"2\" rowspan=\"2\">&nbsp;". sprintf("%3.2f",$this->parent->sum['volume_done']) ." ". $lang['hours'] ."</td>\n";
     echo " </tr>\n";
     $a = 0;

     echo "<tr>";
     echo "<td colspan=\"2\"><img width=\"208\" height=\"2\" src=\"". $tutos['base'] ."/html/black.png\" alt=\"--------\"></td>";
     if ( $tutos[massupdate] == 1 ) {
     # Checkbox column for massupdate
#     echo "  <td></td>\n";
     }
     echo "</tr>";
     echo " </thead>\n";

     $skipped = 0;
     $this->line = 0;

     if ( $this->parent->getType() == "task" ) {
       $skipped += $this->parent->printRow($this,0,$this->parent,$this->fld, $this->start, $this->end);
     } else {
       foreach ($this->parent->tasklist as $i => $f) {
         $skipped += $this->parent->tasklist[$i]->printRow($this,0,$this->parent,$this->fld, $this->start, $this->end);
         $a++;
       }
     }

     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart($cols-1);
       echo sprintf($lang['withmarked'],$lang['Tasks']);
       echo "<select name=\"action\" onChange=\"disableArg();\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option value=\"-2\">". $lang['Delete'] ."</option>\n";
       @reset($lang['TaskStates']);
       while ( list ($f,$i) = @each ($lang['TaskStates']) ) {
         echo " <option value=\"". $f ."\">". sprintf($lang['SetTo'],$lang['TaskState'],$lang['TaskStates'][$f]) ."</option>\n";
       }
       # Adding the ability to mass update time slice
       echo " <option value=\"timeslice\">".$lang['Reschedule']."</option>\n";
       echo " <option value=\"timeslice_s\">".$lang['Reschedule_s']."</option>\n";
       echo " <option value=\"timeslice_e\">".$lang['Reschedule_e']."</option>\n";
       echo "</select>\n";
       echo " &nbsp;<input name=\"arg\" type=\"text\" value=\"0\" size=\"3\">\n";
       echo $this->UpdateRowEnd(1);
     }
     echo $this->OverviewTableEnd();

     if ( $tutos[massupdate] == 1 ) {
       hiddenFormElements();
       echo $this->getHidden();
       echo "</form>";
     }
     if ($skipped > 0 ) {
       echo "skipped ". $skipped ." (". $lang['TaskStates'][2].") ". $lang['Tasks'];
     }
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * action
    */
   Function action() {
     global $msg,$lang;

     @reset($_GET['mark']);

     switch( $_GET['action'] ) {
     case -2:
       $this->dbconn->Begin("WORK");
       while( list($key, $val) = @each($_GET['mark']) ) {
         $p = new task($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           $msg .= "Unknown TASK ". $val ."<br>\n";
           continue;
         }
         if ( $p->del_ok() ) {
           $msg .= sprintf($lang['TaskDelete'], $p->getFullName()) ."<br>";
           $msg .= $p->delete();
         } else {
           $msg .= $p->getLink() .": ".  sprintf($lang['Err0023'],$lang[$p->getType()])."<br>\n";
         }
         unset($p);
       }
       $this->dbconn->Commit("WORK");
       break;
     case "timeslice":
       $arg = $_GET['arg'];
       // control the given value
       if( !is_numeric($arg) ) {
         $msg .= sprintf($lang['Err0017'], $lang['Reschedule'])."<br>";
         break;
       }
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $p = new task($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->mod_ok() ) {
           $start = $p->s_start;
           $end   = $p->s_end;
           $start->addDays($arg);
           $end->addDays($arg);
           $p->setSStart($start);
           $p->setSEnd($end);
           $msg .= $p->save();
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()])."<br>\n";
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
       break;
     case "timeslice_s":
       $arg = $_GET['arg'];
       // control the given value
       if( !is_numeric($arg) ) {
         $msg .= sprintf($lang['Err0017'], $lang['Reschedule'])."<br>";
         break;
       }
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $p = new task($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->mod_ok() ) {
           $start = $p->s_start;
           $end   = $p->s_end;
           $start->addDays($arg);
           if( $start->getYYYYMMDD() <= $end->getYYYYMMDD() ) {
             $p->setSStart($start);
             $msg .= $p->save();
           } else {
             $msg .= $p->getLink() .": ".$lang['Err0002']."<br>\n";
           }
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()])."<br>\n";
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
       break;
     case "timeslice_e":
       $arg = $_GET['arg'];
       // control the given value
       if( !is_numeric($arg) ) {
         $msg .= sprintf($lang['Err0017'], $lang['Reschedule'])."<br>\n";
         break;
       }
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $p = new task($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->mod_ok() ) {
           $start = $p->s_start;
           $end   = $p->s_end;
           $end->addDays($arg);
           if( $start->getYYYYMMDD() <= $end->getYYYYMMDD() ) {
             $p->setSEnd($end);
             $msg .= $p->save();
           } else {
             $msg .= $p->getLink() .": ".$lang['Err0002']."<br>\n";
           }
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()]) ."<br>\n";
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
       break;
     default:
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $p = new task($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->mod_ok() ) {
           $msg .= $p->getLink() ." ". $lang['TaskState'] ." = ".  $lang['TaskStates'][$_GET['action']] ."<br>";
           $msg .= $p->setState($_GET['action']);
           $msg .= $p->save();
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()]) ."<br>\n";
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
       break;
     }
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$tutos; 

     $this->fld = "";
     $this->name = $lang['TaskOverview'];

     if ( isset($_GET['id']) ) {
       $this->parent = GetObject($this->dbconn,$_GET['id']);
       $this->addHidden("id",$this->parent->id);
       $this->name .= " : ". $this->parent->getFullName();
     } else {
       $msg .= $lang['Err0048'];
       $this->stop = true;
     }
     if ( isset($_GET['fld']) ) {
       $this->fld = $_GET['fld'];
     }

     if ( isset($_GET['start']) )
       $this->start = new DateTime($_GET['start']);
     else
       if( isset($_GET['start_d']) ) {
	 $start = sprintf("%04d%02d%02d", $_GET['start_y'],
			  $_GET['start_m'], $_GET['start_d']);
	 $this->start = new DateTime($start);
       }

     if ( isset($_GET['end']) )
       $this->end = new DateTime($_GET['end']);
     else
       if( isset($_GET['end_d']) ) {
	 $end = sprintf("%04d%02d%02d", $_GET['end_y'],
			$_GET['end_m'], $_GET['end_d']);
	 $this->end = new DateTime($end);
       }


     # menu

     // The PNG Gantt fonctionnality, using JpGraph Tools, to be installed
     if( $tutos[usejpgraph] ) {
       $x = array( url => "task_gantt.php?id=". $this->parent->id,
                   text => $lang['TaskGantt'],
                   info => $lang['TaskGantt'],
                   category => array("task","view")
                 );
       $this->addMenu($x);
     }

     if( $this->parent != -1 && $this->parent->getType() !=  "address" ) {
       $x = array( url =>  "task_overview.php?id=".$this->parent->id, 
                   text => $lang['TaskGantt'],
                   info => sprintf($lang['TaskOverviewInfo'],$this->parent->getFullName()),
                   category => array("task","view")
		   );

       $x[text] = $lang['TaskOverview'];
       $this->addMenu($x);
       $x[text] = $lang['TaskOverview'] ."++";
       $x[url] = "task_overview.php?id=".$this->parent->id."&amp;fld=worker";
       $this->addMenu($x);
     }
   }
 }

 $l = new task_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
CVS Info:  $Id: task_overview.php,v 1.50.2.4 2003/08/22 17:48:07 gokohnert Exp $
 $Author: gokohnert $
 -->