<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("address","new");

 /**
  * display a address/location change/create form
  */
 class address_new extends layout {
   /**
    * Prepare address form
    */
   Function ask_address() {
     global $lang,$table,$tutos;

     $this->assign('adr_title',
		   array('name'  => 'title',
			 'label' => $lang['AdrTitle'],
			 'value' => myentities($this->obj->title),
			 'size'  => $table['address']['title'][size]));

     $this->assign('f_name',
		   array('name'  => 'f_name',
			 'label' => $lang['AdrFirstName'],
			 'value' => myentities($this->obj->f_name),
			 'size'  => $table['address']['f_name'][size]));

     $this->assign('m_name',
		   array('name'  => 'm_name',
			 'label' => $lang['AdrMiddleName'],
			 'value' => myentities($this->obj->m_name),
			 'size'  => $table['address']['m_name'][size]));

     $this->assign('l_name',
		   array('name'  => 'l_name',
			 'label' => $lang['AdrLastName'],
			 'value' => myentities($this->obj->l_name),
			 'size'  => $table['address']['l_name'][size]));

     
     // BIRTHDAY
     // $this->add_entry ($lang['AdrBirthday'],'birthday',$this->obj->birthday,$this->modadr,0,3);


     /**
      * FIXME: To be re implemented with templates
      *
     if ( class_exists('tutos_file')
	  && $this->user->feature_ok(usedocmanagement,PERM_NEW) ) {
       // Picture
       if ( $this->modadr ) {
         $this->obj->read_picture();
         $this->add_entry ($lang['AdrPicture'],'picture',$this->obj->pic_file,$this->modadr,30,3);
       }
     }

     // Reference to modules
     if ( $this->modadr ) {
       module_addforms($this->user,$this->obj,4);
     }
     */
   }

   /**
    * Address editing form
    */
   Function info() {
     global $lang,$table;

     $this->assign('action', 'address_ins.php');

     // echo $this->DataTableStart();

     if ( $this->obj->id > 0 ) {
       $this->assign("id", $this->obj->id);
       // Its an update
       $title = $lang['AdrBChangeTitle'];
     }
     else {
       $title = $lang['AdrBNewTitle'];
     }

     $title .= " / ";

     if ( $this->loc->id > 0 ) {
       $this->assign('loc_id', $this->loc->id);
       $title .= sprintf($lang['AdrLocChange'],$this->obj->getFullName());
     }
     else {
       $title .= sprintf($lang['AdrLocCreate'],$this->obj->getFullName());
     }

     $this->assign('title', $title);

     /*
     if ( $this->obj->id > 0)  {
       echo "<tr><td colspan=\"4\" align=\"right\">&nbsp;";
       echo acl_link($this->obj);
       echo "</td></tr>\n";
     }
     */
     $this->ask_address();

     /*
     if ( $this->loc->id > -1)  {
       echo "<tr><td colspan=\"4\" align=\"right\">&nbsp;";
       echo acl_link($this->loc);
       echo "</td></tr>\n";
     }
     */
     $this->loc->ask_location($this);

     $this->assign('InputOk',   $lang['InputOk']);
     $this->assign('ChangesOk', $lang['ChangesOk']);
     $this->assign('Enter', $lang['Enter']);
     $this->assign('Reset', $lang['Reset']);

     $this->assign('focus', "addrnew.name");
     $this->assign('FldsRequired', $lang['FldsRequired']);

     $this->template('address_new');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['Addresses'];
     $this->obj = new tutos_address($this->dbconn);
     $this->loc = new location($this->dbconn);
     $this->modloc = true;
     $this->modadr = true;

     if ( isset($_GET['id']) && ($_GET['id'] != "-1" )) {
       $id = $_GET['id'];
       # Modify Base Address
       $this->obj->read($id);
       $this->obj->read_locs_data();
       if ($this->obj->id < 0) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     }

     if ( isset($_GET['loc_id']) && ($_GET['loc_id'] != "-1" )) {
       $loc_id = $_GET['loc_id'];
       $this->loc->read($loc_id);
     } else if ( isset($_GET['loc_id']) && ($_GET['loc_id'] == "-1" )) {
       # use a empty new location
     } else {
       # if there is no default location use a empty new location
#       foreach ($this->obj->location as $loc_id => $this->loc) {
#	   }
	 }

     if ( isset($loc_id) ) {
       if ( ($loc_id == -1) ) {
         $this->loc->id = $loc_id;
       } else {
         $this->loc->lname = $this->obj->loc[$loc_id];
         if ($this->loc->id < 0) {
           $msg .= sprintf($lang['Err0040'],$lang[$this->loc->getType()]);
           $this->stop = true;
         } else if ( ! $this->loc->mod_ok() ) {
           $msg .= sprintf($lang['Err0024'],$lang[$this->loc->getType()]);
           $this->stop = true;
         }
       }
	 }

     if ( isset($this->loc->company) ) {
       $this->loc->company_name = $this->loc->company->name;
     }
     if ( isset($this->loc->department) ) {
       $this->loc->department_name = $this->loc->department->name;
     }
     if ( isset($_GET['company']) ) {
       $this->loc->company_name = StripSlashes($_GET['company']);
     }
     if ( isset($_GET['department']) ) {
       $this->loc->department_name = StripSlashes($_GET['department']);
     }
     if ( isset($_GET['lname']) ) {
       $this->loc->lname = StripSlashes($_GET['lname']);
     }
     if ( isset($_GET['category']) ) {
       $this->loc->category = $_GET['category'];
     }
     if ( isset($_GET['cploc']) ) {
       $this->loc->cploc = $_GET['cploc'];
     } else {
       $this->loc->cploc = 0;
     }
     if ( isset($_GET['cl']) ) {
       $cl = $_GET['cl'];
       foreach ($cl as $f) {
         $c = new company($this->dbconn);
         $c->read($f);
         $this->loc->cl[$f] = $c;
       }
     }
     if ( isset($_GET['dl']) ) {
       $dl = $_GET['dl'];
       foreach ($dl as $f)  {
         $d = new department($this->dbconn);
         $d->read($f);
         $this->loc->dl[$f] = $d;
       }
     }
     foreach($this->loc->larray as $i => $f) {
       if ( isset($_GET[$f]) ) {
         $this->loc->$f = StripSlashes($_GET[$f]);
       }
       $i++;
     }
     if ( isset($_GET['f_name']) ) {
       $this->obj->f_name = StripSlashes($_GET['f_name']);
     }
     if ( isset($_GET['m_name']) ) {
       $this->obj->m_name = StripSlashes($_GET['m_name']);
     }
     if ( isset($_GET['l_name']) ) {
       $this->obj->l_name = StripSlashes($_GET['l_name']);
     }
     if ( isset($_GET['bd']) ) {
       $this->obj->birthday->setDateTime($_GET['bd']);
     }
     if ( isset($_GET['pic_path']) ) {
       $this->obj->pic_file->pic_path = StripSlashes($_GET['pic_path']);
     } else {
       $this->obj->pic_file->pic_path = "";
     }
     if (($this->obj->id < 0) && !$this->user->feature_ok(useaddressbook,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }


     // Menu      
     $x = tutos_address::getSelectLink($this->user,$lang['Search']);
     $x['category'][] = "obj";
     $x['image'] = 'search';
     $this->addMenu($x);

     if ( $this->user->feature_ok(useaddressbook,PERM_NEW) ) {
       $x = array('url'   => "address_new.php",
                  'text'  => $lang['AdrBNew'],
                  'info'  => $lang['AdrBNewInfo'],
		  'image' => 'new',
                  'confirm' => false,
                  'category' => array("address","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array('url'   => $this->obj->getModURL(),
                  'text'  => $lang['AdrBMod'],
                  'info'  => sprintf($lang['AdrBModInfo'],
				     $this->obj->getFullName()),
		  'image' => 'modify',
                  'confirm' => false,
		  'category' => array("address","mod","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array('url'   => $this->obj->getDelURL(),
                  'text'  => $lang['AdrBDel'],
                  'info'  => sprintf($lang['AdrBDelInfo'],
				     $this->obj->getFullName()),
		  'image' => 'delete',
                  'confirm' => true,
                  'category' => array("address","del","obj")
                 );
       $this->addMenu($x);
     }


     if ( $this->user->admin == 1 ) {
       $x = array('url'   => "team_new.php",
                  'text'  => $lang['TeamCreate'],
                  'info'  => $lang['TeamCreateI'],
		  'image' => 'teams',
                  'confirm' => false,
                  'category' => array("team","new","support")
                 );
       $this->addMenu($x);
     }
     if ( $this->user->feature_ok(usecompany,PERM_NEW) ) {
       $x = array( url => "company_new.php",
                   confirm => false,
                   text => $lang['CompanyCreate'],
                   info => $lang['CompanyCreateInfo'],
                   category => array("company","new","support")
                 );
       $this->addMenu($x);
	 }
     if ( $this->user->feature_ok(usedepartment,PERM_NEW) ) {
       $x = array( url => "department_new.php",
                   confirm => false,
                   text => $lang['DepartmentCreate'],
                   info => $lang['DepCreateInfo'],
                   category => array("department","new","support")
                 );
       $this->addMenu($x);
     }
     if ( $this->obj->id > 0 ) {
       $x = array('url'   => $this->obj->getURL(),
                  'text'  => $lang['AdrSeeEntry'],
                  'info'  => sprintf($lang['AdrSeeEntryI'],
				     $this->obj->getFullName()),
                  'category' => array("address","view")
                 );
       $this->addMenu($x);

       if ( $this->obj->isUser() != 0 ) {
         if ( $this->obj->user->mod_ok() ) {
           $x = array('url'   => "user_new.php?id=". $this->obj->id ,
                      'text'  => $lang['UserModify'],
                      'info'  => sprintf($lang['UserModInfo'],
					 $this->obj->getFullName()),
		      'image' => 'new',
                      'category' => array("user","module","mod")
                     );
           $this->addMenu($x);
         }
       } else if ( $this->user->feature_ok(useuser,PERM_NEW) )  {
           $x = array('url'   => "user_new.php?id=". $this->obj->id ,
                      'text'  => $lang['UserCreate'],
                      'info'  => sprintf($lang['UserNewInfo'],
					 $this->obj->getFullName()),
		      'image' => 'new',
                      'category' => array("user","module","new")
                     );
           $this->addMenu($x);
       }
     }

     add_module_newlinks($this,$this->obj);
     
     web_StackStartLayout($this,"address_new.php","address_new.php?".$_SERVER['QUERY_STRING']);     
   }
 }

 $l = new address_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: address_new.php,v 1.59.2.3 2004/09/15 09:06:15 tapoueh Exp $
    $Author: tapoueh $
-->
