<?php
/**
 * Copyright 2003 by Jeroen Baten
 * $Id: invoice_print_pdf.php,v 1.2 2003/12/08 17:20:40 gokohnert Exp $
 * create a pdf file of an invoice
 *
 * @modulegroup invoice
 * @module invoice_new
 * @package invoice
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once '../pdflib/class.ezpdf.php';


 /* Check if user is allowed to use it */
 check_user();
 loadmodules("invoice","new");
 loadmodule("invoice");
 loadlayout();

 /* ---------------------------------------------------------------------------
  *
  */

 class invoice_new extends layout {
   /**
    * generate a pdf stream
    */
   Function info() {
     global $lang,$tutos;
	$pdf = new Cezpdf();
	$pdf->selectFont('../pdflib/fonts/Helvetica.afm');
	$pdf->ezText($lang['Accountant'].": ".$this->obj->acc->getFullname());
	$pdf->ezText($lang['InvoiceName'].": ".$this->obj->name);
	$pdf->ezText($lang['InvoiceState'].": ".$lang['InvoiceStates'][$this->obj->state]);
	$pdf->ezText($lang['InvoiceCustomer'].": ".$this->obj->customer->getFullname());
	$pdf->ezText($lang['InvDateSent'][0].": ".$this->obj->datesent[0]->getDate());
	$pdf->ezText($lang['InvDateDue'][0].": ".$this->obj->datedue[0]->getDate());

     $showed = array();
     $this->obj->read_pos();
     @reset($this->obj->pos) ;
	 $invoicelines=array();
	 # here we are going to store orderlines in an array for later tablegeneration.
     while ( list ($i,$f) = @each ($this->obj->pos) ) {
       $f->read_ref();
       $showed[$f->ref->id] = 1;
		$invoicelines[]=array(	$lang['InvPosPos']=>sprintf("%04d",$f->pos),
			$lang['InvPosItems']=>number_format($f->items,2,$lang['DecPoint'],$lang['ThousandPoint']),
			$lang['InvPosDesc']=>$f->description,
			$lang['InvPosSingle']=>number_format($f->sum_single ,2,$lang['DecPoint'],$lang['ThousandPoint']),
			$lang['InvPosTax']=>number_format($f->tax ,2,$lang['DecPoint'],$lang['ThousandPoint']),
			$lang['InvPosSum']=>number_format($f->getTotal(),2,$lang['DecPoint'],$lang['ThousandPoint']),
			$lang['Currency']=>$f->currency);
			$sum+=$f->getTotal();
       unset($f);
     }
	# add total sum to invoice. I do not completely understand what's happening here, but at least it works.
	 $sum = $this->obj->getTotal();
     $pre = "";
     foreach($sum as $cur => $val) {
       if ( $val != 0 ) {
         $x = array($val,$cur);
		 $invoicelines[]=array($lang['InvPosDesc']=>'Totaal',$lang['InvPosSum']=>number_format($val,2,$lang['DecPoint'],$lang['ThousandPoint']));
       }
     }


	$pdf->ezTable($invoicelines);
#	now we reach the end of the creation of the invoice so let's make a stream.

$pdf->ezStream();

   }
   /**
    * naviagte
    */
	# no navigation!, just a pdf stream!
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$HTTP_GET_VARS,$lang, $tutos;

     $this->obj = new invoice($this->dbconn);
     $this->name = $lang['Invoice'];

     if ( isset($HTTP_GET_VARS['id']) ) {
       $this->obj->read($HTTP_GET_VARS['id']);
       if ($i->id == -1) {
         $msg .= sprintf($lang['Err0040'],$lang[$i->getType()]) . "<BR>";
         $this->stop = true;
       }
       $this->name .= " : ". $this->obj->getFullName();
       $this->obj->read_ref();
     } else {
       $this->name = $lang['InvoiceCreate'];
     }
     if ( isset($HTTP_GET_VARS['state']) ) {
       $this->obj->state = $HTTP_GET_VARS['state'];
     }
     if ( isset($HTTP_GET_VARS['name']) ) {
       $this->obj->name = UrlDecode(Stripslashes($HTTP_GET_VARS['name']));
     }
     if ( isset($HTTP_GET_VARS['link_id']) ) {
       $this->obj->link_id = $HTTP_GET_VARS['link_id'];
       if ( $this->obj->id == -1 ) {
         $this->obj->read_ref();
         if ( $this->obj->ref->getType() == "product" ) {
           # Preset the custumer if possible
            $this->obj->ref->readroles();
           if ( isset($this->obj->ref->role[6][0]) ) {
             $this->obj->customer = $this->obj->ref->role[6][0];
           }
         } else if ( $this->obj->ref->getType() == "installation" ) {
           $this->obj->customer = $this->obj->ref->customer;
         }
       }
     } else if ( $this->obj->id == -1 ) {
       # new and no link_id
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]) . "<BR>";
       $this->stop = true;
     }

     # Customer
     preset_from_array_or_input($this->obj,'customer',"i");
     if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     $m = invoice::getSelectLink($this->user,$lang['Search']);
     $this->addmenu($m);
     add_module_newlinks($this,$this->obj);
   }
 }
 $l = new invoice_new($current_user);


 $l->prepare();
 $l->info();

 $dbconn->Close();

?>