<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup file
 * @module file_ins
 * @package file
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('file','ins');
 loadmodule('file');

 $f = new tutos_file($dbconn);

 /* Check Input */
 $msg = "";
 $log = "";
 $links = array();

 if ( empty($_POST['gotourl']) ) {
   $gotourl = "file/file_new.php";
 } else {
   $gotourl = $_POST['gotourl'];
 }

 if ( isset($_POST['id']) ) {
   $f->read($_POST['id']);
   $gotourl = addUrlParameter($gotourl,"id=". $f->id,true);
 }
 if ( $f->id == -1 ) {
   # Versioning System could only be set at first save

   if ( isset($_POST['vsys']) ) {
     $f->vsys = $_POST['vsys'];
   }
 }
 if ( isset($_POST['save']) ) {
   $f->savemode = $_POST['save'];
 }

 if ( !isset($_REQUEST['link_id']) ||  !is_array($_REQUEST['link_id'])) {
   $msg .= sprintf($lang['Err0009'],$lang['FileReference']) ."<br>";
 } else {
   foreach($_REQUEST['link_id'] as $i => $j) {
     $l = getObject($f->dbconn,$j);
     if ($l != -1) {
       $links[$l->id] = &$l;
     }
     $gotourl = addUrlParameter($gotourl,"link_id[]=". UrlEncode($l->id),true);
     unset($l);
   }
 }

 # add a new reference
 if (isset($_POST['reftype']) && ($_POST['reftype'] != "0") ) {
   $l = array();
   # search the appropiate object class
   $c = trim($_POST['reftype']);
   $n = trim($_POST['refname']);
   $gotourl = addUrlParameter($gotourl,"reftype=". UrlEncode($c),true);
   $gotourl = addUrlParameter($gotourl,"refname=". UrlEncode($n),true);
   if (class_exists($c)) {
     $x = new $c($dbconn);
     if (method_exists($x,"search_by_name")) {
       $x->search_by_name($l,$current_user,$n);
       if ( 1 == count($l)) {
         # cool we got an exact input
         foreach ($l as $x) {
           $links[$x->id] = &$x;
           unset ($x);
         }
       } else if ( count($l) > $tutos[maxselect]) {
         $msg .= sprintf($lang['Err0018'],$lang[$c].":".$n,count($l)) ."<br>";
         $msg .= $lang['Err0006'] ."<br>";
       } else if ( count($l) < $tutos[maxselect]) {
         $msg .= sprintf($lang['Err0018'],$lang[$c].":".$n,count($l)) ."<br>";
         foreach ($l as $x) {
           $gotourl = addUrlParameter($gotourl,"refl[]=". UrlEncode($x->id),true);
           unset ($x);
         }
       }
     }
   }
 }

 # delete  references
 if ( isset($_POST['del']) && is_array($_POST['del'])) {
   foreach($_POST['del'] as $i => $j) {
     unset($links[$j]);
     $gotourl = addUrlParameter($gotourl,"del[]=". UrlEncode($j),true);
   }
 }

 # Manage the list of links
 unset($f->links);
 foreach($links as $l) {
   $f->addReference($l);
 }

 # check for at least one reference
 if (count($f->links) == 0) {
   $msg .= sprintf($lang['Err0009'],$lang['FileReference']) ."<br>";
 }

 $file = 'none';
 # Hack for Konquerer
 if ( isset($_POST['file']) ) {
   $file = $_POST['file'];
   if ( $file != "none" ) {
     $farr = $HTTP_POST_FILES["file"];
     if ( $farr['name'] == "" ) {
       $file = "none";
     }
   }
   $farr = $HTTP_POST_FILES['file'];
 } else if ( isset($HTTP_POST_FILES['file']) ) {
   $file = $HTTP_POST_FILES['file']['name'];
   $farr = $HTTP_POST_FILES['file'];
 }
 if ( $file == "" ) {
   $file = 'none';
 }

 # via filesystem import
 if (isset($_GET['file'])) {
   $file = $_GET['file'];
   $import = true;
   $farr = array();
   $farr['name'] = $file;
   $farr['tmp_name'] = $tutos[sessionpath]."/". $file;
   $farr['size'] =  filesize($farr['tmp_name']);
   $farr['type'] = $_GET['ct'];
   $f->nocheck = true;
 } else {
   $import = false;
 }

 # New files need a path !
 if ( ($file == "none") && ($f->id == -1)  ) {
   $msg .= sprintf($lang['Err0009'],$lang['FileName']) ."<br>";
 }

 if ( ( !isset($_POST['name']) || trim($_POST['name']) == "") && ($file == "none") ) {
   $msg .= sprintf($lang['Err0009'],$lang['FileName']) ."<br>";
   $name = "";
 } else {
   $name = trim($_REQUEST['name']);
 }

 if ( $name != "" ) {
   $gotourl = addUrlParameter($gotourl,"name=". UrlEncode(StripSlashes($name)),true);
 }

 if ( isset($_REQUEST['version']) && ($_REQUEST['version'] != "") ) {
   $version = $_REQUEST['version'];
 } else {
   $version = "";
 }
 $gotourl = addUrlParameter($gotourl,"version=". UrlEncode(StripSlashes($version)),true);


 if ( isset($_POST['locked']) && ($f->locked != $_POST['locked']) ) {
   if ( $_POST['locked'] > 0 ) {
     $f->locker = new tutos_address($dbconn);
     $f->locker->read($_POST['locked']);
     $log = $log . sprintf($lang['FileLockedBy'],$f->locker->getFullName()) ."\n";
   } else {
     $log = $log . sprintf($lang['FileUnlockedBy'],$current_user->getFullName()) ."\n";
   }
   $f->locked = $_POST['locked'];
 }

 if ( isset($_POST['afn']) ) {
   # Check the author full name
   $author = check_field($_POST['afn'],"afn","al","at");
 }

 if ( $file != "none" ) {
   if ( $f->id > 0 ) {
     $log .=  "Changed Document \n";
     if ( $f->filename != $farr['name'] ) {
       $log = $log . sprintf($lang['FileChanged'],$lang['FileName'],$f->filename,$farr['name']) ."\n";
     }
     if ( $f->filesize != $farr['size'] ) {
       $log = $log . sprintf($lang['FileChanged'],$lang['FileSize'],$f->filesize,$farr['size']) ."\n";
     }
     if ( $f->filetype != $farr['type'] ) {
       $log = $log . sprintf($lang['FileChanged'],$lang['FileType'],$f->type,$farr['type']) ."\n";
     }
   }
   if ( $name == "") {
     $name = $farr['name'];
   }
   if ( isset($farr['tmp_name']) && file_exists($farr['tmp_name']) ) {
     $f->tmploc = $farr['tmp_name'];
     $f->filesize = $farr['size'];
     $f->setFilename($farr['name']);
     $f->filetype = $farr['type'];
   } else {
     if ( isset($farr['tmp_name']) ) {
       $msg .= sprintf($lang['File_Err001'],$farr['tmp_name']);
     } else {
       $msg .= sprintf($lang['File_Err001'],"");
     }
   }
 }

 # other modules
 $msg .= module_parseforms($current_user,$f,$gotourl);

 if ( $msg == "" ) {
   $f->oldversion = $f->version;
   $f->setVersion($version);

   if ( isset($_POST['aid']) ) {
     $author = getObject($f->dbconn,$_POST['aid']);
   }
   if ( isset($author) ) {
     if ( $f->author->id != $author->id ) {
       $log = $log . sprintf($lang['FileChanged'],$lang['FileAuthor'],$f->author->getFullName(),$author->getFullName()) ."\n";
     }
     $f->setAuthor($author);
   }

   if ( ($f->name != $name) && ($f->name != "") ) {
     $log = $log . sprintf($lang['FileChanged'],$lang['FileNameDoc'],$f->name,$name) ."\n";
   }
   $f->setName($name);

   if ( $log != "" ) {
     $log = "----------- <b>". Date("j M Y  H:i:s") ." -- ". $current_user->getFullName() ." </b>---\n" . $log;
     $f->logtxt = $log. $f->logtxt;
   }
   # Save the new part of logmessage for RCS
   $f->newlog = $log;

   $dbconn->Begin("WORK");
   $msg .= $f->save();
   $dbconn->Commit("WORK");

   if ( $f->id != -1 ) {
     $gotourl = $f->getURL();
   }
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 if (!$import) {
   Header("Status: 302 Moved Temporarily");
   Header("Location: ". dirname(getBaseUrl()) ."/". $gotourl);
 } else {
   echo $msg;
 }
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: file_ins.php,v 1.10.2.1 2004/04/14 17:39:19 tapoueh Exp $
  *  $Author: tapoueh $
  */
?>