/*
 * Copyright (c) 1999 Ivo van der Wijk
 * 
 * The tux image is (c) Larry Ewing (lewing@isc.tamu.edu)
 * The dustpuppy image is (c) Illiad (http://www.userfriendly.org)
 * The bsd daemon ("Chuck") is (c) Eric Green
 * The luxus image is (c) Urs M. E. Streidl (http://www.gigaperls.org/linux/)
 * 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TUXEYES_H
#define _TUXEYES_H

#include "figure.h"

/*
 * This include depends on the includes done by tuXeyes.cpp!
 */

class	tuxWidget: public QWidget
{
	figure	*tuxImg;

	static	const	int	timerInterval;	// how often to poll
public:
	tuxWidget(figure *fig, QWidget *parent=0, const char *name=0);
	void	paintEyes();
	void	paintEvent(QPaintEvent *);
	void	timerEvent(QTimerEvent *);
	void	resizeEvent(QResizeEvent *);

protected:
	void	keyPressEvent(QKeyEvent *);
private:
	// scales
	float	xScale, yScale;
	float	avg;

	Display	*display;
	Window	root;
	int	oldX, oldY;
	float	leftX, leftY, rightX, rightY;

	// geometry changes
	int	origWidth, origHeight;
};

#endif

