<?php	// TWIG		Commonly used functions.	?>
<?php

if( !isset($included["common.inc.php3"] ) )
	{
	Function TWIGGoToFeature( $GoToFeature )
		{
		GLOBAL $context;

   		$gtfeature = unserialize( URLDecode( stripslashes( $GoToFeature ) ) );

		$context["feature"] = $gtfeature["command"];
		$context["action"] = $gtfeature["action"];
		$context["options"] = $gtfeature["options"];
		}

 	Function TWIGPrintError( $string ) 
		{
		GLOBAL $TWIGphrase;

		if( !$TWIGphrase["Error"] ) { $TWIGphrase["Error"] = "Error"; }

  		echo "<b>" . $TWIGphrase["Error"] . "</b>: <i>$string</i><br>\n";
 		}

	Function TWIGDebug( $string, $level = 10 )
		{
		GLOBAL $config;

		if( $level < 1 ) { $level = 1; }

		if( $config["debug"] >= $level ) { echo "<font color=\"#FF0000\"><b>DEBUG:</b>" . $string . "</font><BR>\n"; flush(); }
		}

 	// Create link with some status info
 	Function TWIGLink( $text="", $feature="", $action="", $params="", $target="", $sother = "", $cother = "" ) 
		{
  		GLOBAL $config;
  		
		TWIGDebug( "TWIGLink( \"" . $text . "\", \"" . $feature  . "\", \"" . $action . "\", \"" . $params . "\", \"" . $target . "\" );", 30 );

		$str = $config["baseurl"];
  		$str .= "?ts=" . mktime();	// Make each URL unique (screw you n+2.0!)
  		$str .= TWIGSession( "get", $sother );
		$str .= TWIGContext( "get", $feature, $action, $cother );
  		if( $params ) { $str .= "&" . $params; }

 		return "<a href=\"$str\" $target>$text</a>";
 		}

 	Function TWIGMailto( $address, $fullname = "" ) 
		{
  		GLOBAL $config, $login;
  		
		TWIGDebug( "TWIGMailto( \"" . $address. "\" );", 30 );

		if( !$address ) { $address = $config["defaults"]["mail"]["fromaddress"]; }
		if( !strstr( $address, "@" ) ) { $address .= "@" . $config["fromdomain"]; }

		if( TWIGCheckACL( $login["username"], 2001, TWIGConvertAccess( "read" ) ) )
			{
			if( $fullname )
				{
				$email = twigLink( $fullname, "mail", "compose", "form[to]=" . URLEncode( "\"" . $fullname . "\" <" . $address . ">" ) ) . "&nbsp";
				}
			else
				{
				$email = twigLink( $address, "mail", "compose", "form[to]=" . URLEncode( "<" . $address . ">" ) ) . "&nbsp";
				}
			}
		else
			{
			if( $fullname )
				{
				$email = "<a href=\"mailto:" . $address . "\">" . $fullname . "</a>";
				}
			else
				{
				$email = "<a href=\"mailto:" . $address . "\">" . $address . "</a>";
				}
			}

 		return $email;
 		}

	Function TWIGCheckAdmin( $username = "" ) 
		{
		GLOBAL $config, $login;

		TWIGDebug( "TWIGCheckAdmin( \"" . $username . "\");" );

		if( !$username ) { $username = $login["username"]; }

		if( file_exists( "features/admin/users/" . $username . ".admin" ) )
			{
			return TRUE;
			}

  		return TWIGIsMemberOfACLGroup( $username, "TWIGAdministrators" );
 		}

	Function TWIGFormatDisplayString( $str )
		{
		return TWIGFindHtml( nl2br( htmlspecialchars( str_replace( "\r", "", $str ) ) ) );
		}

	Function TWIGMassage( $str ) 
		{ // Fixes fu for things like NetPositive
  		return htmlspecialchars( str_replace( "\r", "", $str ) );
 		} 

	Function TWIGFindHtml( $string = "" ) 
		{  
		GLOBAL $config, $disabled, $login;

		TWIGDebug( "TWIGFindHtml( \"" . $string . "\" );", 30 );
  
		if( !$disabled["FindHTML"] )
			{

			$bstring = trim( $string );

	                $bstring = eregi_replace( "&lt;", " ", $bstring );
        	        $bstring = eregi_replace( "&gt;", " ", $bstring );
			$bstring = eregi_replace( "&quot;"," ", $bstring );
			$bstring = str_replace( "\t", " ", $bstring );
        	        $bstring = eregi_replace( "\[", " ", $bstring );
                	$bstring = eregi_replace( "\]", " ", $bstring );
			$bstring = eregi_replace( "[<>'()*]", " ", $bstring );
			$bstring = eregi_replace( "MAILTO:", " ", $bstring );
        	        $bstring = eregi_replace( "HTTP:", " http:", $bstring );
                	$bstring = eregi_replace( "HTTPS:", " https:", $bstring );
			$bstring = eregi_replace( "FTP:", " ftp:", $bstring );   

			$string_split = split( " ", $bstring );
   
			$fstrings["http"] = array();
			$fstrings["ftp"] = array();
			$fstrings["nohttp"] = array();
			$fstrings["noftp"] = array();
			$fstrings["mail"] = array();

			for( $i = 0, $j = sizeof( $string_split ); $i < $j; $i++ )
				{
				$csplit = trim( strtoupper( $string_split[$i] ) );
				$string_split[$i] = trim( eregi_replace( "[,.;:]$", " ", $string_split[$i] ) );

   				if( strstr( $csplit, "HTTP://" ) || strstr( $csplit, "HTTPS://" ) ) { $fstrings["http"][$string_split[$i]] = 1; }
				else if( strstr( $csplit, "FTP://" ) ) { $fstrings["ftp"][$string_split[$i]] = 1; }
				else if( strstr( $csplit, "@" ) && strstr( $csplit, "." ) ) { $fstrings["mail"][$string_split[$i]] = 1; }
				else if( eregi( "WWW\..*\..", $csplit ) ) { $fstrings["nohttp"][$string_split[$i]] = 1; }
				else if( eregi( "FTP\..*\..", $csplit ) ) { $fstrings["noftp"][$string_split[$i]] = 1; }
				}
	
			$ret = $string;
		
			while( list( $key, $val ) = each( $fstrings["http"] ) ) 
				{
				$ret = eregi_replace( preg_quote( $key ), "<a href=\"" . $key . "\" target=_blank>" . $key . "</a>", $ret );
				}
	
			while( list( $key, $val ) = each( $fstrings["ftp"] ) ) 
				{
				$ret = eregi_replace( preg_quote( $key ), "<a href=\"" . $key . "\" target=_blank>" . $key . "</a>", $ret );
				}

			while( list( $key, $val ) = each( $fstrings["nohttp"] ) ) 
				{
				$ret = eregi_replace( preg_quote( $key ), "<a href=\"http://" . $key . "\" target=_blank>" . $key . "</a>", $ret );
				}
	
			while( list( $key, $val ) = each( $fstrings["noftp"] ) ) 
				{
				$ret = eregi_replace( preg_quote( $key ), "<a href=\"ftp://" . $key . "\" target=_blank>" . $key . "</a>", $ret );
				}

			while( list( $key, $val ) = each( $fstrings["mail"] ) ) 
				{
				$ret = eregi_replace( preg_quote( $key ), "<a href=\"mailto:" . $key . "\">" . $key . "</a>", $ret );
				}

			if( TWIGCheckACL( $login["username"], 2001, TWIGConvertAccess( "read" ) ) )
				{
				$ret = eregi_replace( "=[ \"]mailto:", "=\"" . $config["baseurl"] . "?" . twigsession() . twigcontext( "get", "mail", "compose" ) . "&form[to]=", $ret );
				}

		    	return $ret;
			}
		else 
			{ 
			return $string; 
			}
		}

	Function TWIGLoadLanguageFile( $filepath, $filename, $lang )
		{
		GLOBAL $config, $TWIGphrase, $dayNamesShort, $dayNames, $monthNames;

		TWIGDebug( "TWIGLoadLanguageFile( \"" . $filepath . "\", \"" . $filename . "\", \"" . $lang . "\" );" );

		if( !$filename ) { $sep = ""; } else { $sep = "."; }

 		if( file_exists( $filepath . $filename . $sep . $lang . ".strings.php3" ) ) 
   			{
			TWIGDebug( "TWIGLoadLanguageFile() - including " . $filepath . $filename . $sep . $lang . ".strings.php3", 20 );
   			include( $filepath . $filename . $sep . $lang . ".strings.php3" );
   			} 
		else 
			{
			TWIGDebug( "TWIGLoadLanguageFile() " . $lang . " not found - including " . $filepath . $filename . ".english.strings.php3", 20 );
   			include( $filepath . $filename . $sep . "english.strings.php3" );
   			}
		}

	// Takes an array and generates TWIG menus
	//
	// Menu types include:	0 - Traditional TWIG text
	//			1 - Drop Down List
	//			2 - Button Bar
	//			3 - Traditional TWIG secondary bar
	//			4 - Vertical bulleted list
	//			5 - Tab list  
	//			6 - Simple list
	//			7 - Button Bar without text
	//
	Function TWIGGenerateMenu( &$contents, $menutype = "", $imagepath = "primary", $sother = "", $cother = "" )
		{
		global $config, $disabled, $context, $TWIGphrase, $dbconfig;

		TWIGDebug( "TWIGGenerateMenu( array, array );" );

		if( !$menutype ) { $menutype = GetPref( "mstyle1", $dbconfig["global_prefs_table"], $config["defaults"]["global"]["mstyle1"] ); }

		$j = count( $contents );

		switch( $menutype )
 			{
			case 0:
				$ret = "<font face=\"" . $config["cellfont"] . "\" size=" . $config["textfontsize"] . ">";

  				for( $i = 0; $i < $j; $i++ ) 
					{
					$ret .=  twigLink( "<B>" . $contents[$i]["desc"] . "</B>", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother ); 

					if( $i + 1 < $j ) { $ret .= " | "; } 
  					}

				$ret .= "</font>";
				break;
			case 1:
				$ret .= "<form method=post>\n";
				$ret .= TWIGSession( "put", $sother );
				$ret .= TWIGContext( "put", "", "", $cother );
				$ret .= $TWIGphrase["Feature"] . ": ";
				$ret .= "<SELECT name=GoToFeature>\n";

  				for( $i = 0; $i < $j; $i++ ) 
					{
					if( $context["feature"] == $contents[$i]["command"] && $context["action"] == $contents[$i]["action"]) { $selected = "SELECTED "; }
					else { $selected = ""; }

					$ret .=  "<option " . $selected . "value=\"" . URLEncode( serialize( $contents[$i] ) ) . "\">" . $contents[$i]["desc"] . "</option>\n"; 
  					}

				$ret .= "</select><input type=submit value=\"" . $TWIGphrase["Go"] . "\"></form>";
				
				break;
			case 2:
  				for( $i = 0; $i < $j; $i++ ) 
					{
 					$ret .= "<WBR>" . twigLink( "<img src=\"" . $config["imgdir"] . "menus/" . $imagepath ."/" . $config["language"] . "/" . $contents[$i]["image"] . "\" border=0 alt=\"" . $contents[$i]["desc"] . "\">", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother ); 
  					}
				break;
			case 3:
				$ret = "<font face=\"" . $config["cellfont"] . "\" size=" . $config["textfontsize"] . ">";

  				for( $i = 0; $i < $j; $i++ ) 
					{
					$ret .=  twigLink( $contents[$i]["desc"], $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother ); 

					if( $i + 1 < $j ) { $ret .= " | "; } 
  					}

				$ret .= "</font>";
				break;
			case 4:
  				for( $i = 0; $i < $j; $i++ ) 
					{
					$ret .=  "&#149;&nbsp;" . twigLink( $contents[$i]["desc"], $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother ) . "<BR>\n"; 
  					}

				break;
			case 5:
				$selected = -1;
				$ret = "<font face=\"" . $config["cellfont"] . "\" color=\"" . $config["celltext"] . "\" size=\"" . $config["textfontsize"] . "\">\n";

  				for( $i = 0; $i < $j; $i++ ) 
					{
					if( $context["feature"] == $contents[$i]["command"] && $context["action"] == $contents[$i]["action"]) { $selected = $i;}
					$tabcontents[$i] =  twigLink( $contents[$i]["desc"], $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother ); 
  					}
	
				$ret .= TWIGGenerateTabs( $tabcontents, $selected );
				$ret .= "\n</font>\n";

				break;
			case 6:
				$ret = "";

  				for( $i = 0; $i < $j; $i++ ) 
					{
					$ret .=  twigLink( "<B>" . $contents[$i]["desc"] . "</B>", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother ); 

					if( $i + 1 < $j ) { $ret .= " | "; } 
  					}

				break;
			case 7:
  				for( $i = 0; $i < $j; $i++ ) 
					{
 					$ret .= twigLink( "<img src=\"" . $config["imgdir"] . "menus-nt/" . $imagepath ."/" . $contents[$i]["image"] . "\" border=0 alt=\"" . $contents[$i]["desc"] . "\">", $contents[$i]["command"], $contents[$i]["action"], $contents[$i]["options"], $contents[$i]["target"], $sother, $cother ); 
  					}
				break;
			}

		return $ret;
		}

  	Function TWIGGenerateTable( &$headers, &$contents, $columns = 0, $width = "100%", $align = "" )
		{
		GLOBAL $config;

		TWIGDebug( "TWIGGenerateTable( array, array, \"" . $columns . "\" );" );

		if( !$columns ) { $columns = count( $headers ); }

		echo "<table border=0 cellspacing=0 cellpadding=0 width=$width ";
		// For some silly reason, Netscape will render stuff left or right of a table.
		// The GenerateTable( ..., $align ) option is really here for centering, anyhow.
		if( $align ) { echo "align=$align"; }
		echo ">\n"; 
		echo "<tr>"; 

		for( $i = 0, $j = 0; $i < $columns && $j < $columns; $j++, $i++ ) 
			{
			if( is_array( $headers[$i] ) )
				{
				if( $headers[$i]["bgcolor"] ) { $bgcolor = $headers[$i]["bgcolor"]; } else { $bgcolor = $config["cellheadcolor"]; }
				if( $headers[$i]["colspan"] ) { $colspan = " COLSPAN=" . $headers[$i]["colspan"]; $j += $headers[$i]["colspan"] - 1; } else { $colspan = ""; }
				if( $headers[$i]["align"] ) { $align = " align=" . $headers[$i]["align"]; } else { $align = ""; }
				if( $headers[$i]["valign"] ) { $valign = " valign=" . $headers[$i]["valign"]; } else { $valign = ""; }
				if( $headers[$i]["nowrap"] ) { $nowrap = " NOWRAP"; } else { $nowrap = ""; }

			  	echo "<td bgcolor=\"", $bgcolor, "\"", $colspan, $align, $valign, $nowrap, "><font face=\"", $config["cellfont"], "\" size=", $config["textfontsize"], " color=\"", $config["cellheadtext"], "\"><b>", $headers[$i]["header"], "</b></font></td>"; 
				}
			else
				{
			  	echo "<td bgcolor=\"", $config["cellheadcolor"], "\"><font face=\"", $config["cellfont"], "\" size=", $config["textfontsize"], " color=\"", $config["cellheadtext"], "\"><b>", $headers[$i], "</b></font></td>"; 
				}
			}

		echo "</tr>\n"; 

		for( $i = 0, $j = count( $contents ); $i < $j; $i++ )
			{
			echo "<tr bgcolor=\"";
			if( $i % 2 ) { echo $config["cellcoloralt"]; } else { echo $config["cellcolor"]; }
			echo "\">";
	
			for( $k = 0, $l = 0; $k < $columns && $l < $columns; $l++, $k++ )
				{
				if( is_array( $contents[$i][$k] ) )
					{
					if( $contents[$i][$k]["bgcolor"] ) { $bgcolor = " bgcolor=\"" . $contents[$i][$k]["bgcolor"] . "\""; } else { $bgcolor = ""; }
 					if( $contents[$i][$k]["colspan"] ) { $colspan = " COLSPAN=" . $contents[$i][$k]["colspan"]; $l += $contents[$i][$k]["colspan"] - 1; } else { $colspan = ""; }
					if( $contents[$i][$k]["align"] ) { $align = " align=\"" . $contents[$i][$k]["align"] . "\""; } else { $align = ""; }
					if( $contents[$i][$k]["valign"] ) { $valign = " valign=\"" . $contents[$i][$k]["valign"] . "\""; } else { $valign = " valign=center"; }
					if( $contents[$i][$k]["nowrap"] ) { $nowrap = " NOWRAP"; } else { $nowrap = ""; }

				  	echo "<td", $bgcolor, $colspan, $align, $valign, $nowrap, "><font face=\"", $config["cellfont"], "\" size=", $config["textfontsize"], ">", $contents[$i][$k]["contents"], "</font></td>";
					}
				else
					{
				  	echo "<td valign=center><font face=\"", $config["cellfont"], "\" size=", $config["textfontsize"], ">", $contents[$i][$k], "</font></td>"; 
					}
				}
		
			echo "</tr>\n";
			}

		echo "</table>\n"; 
		}

	Function TWIGGenerateTabs( &$contents, $selected = -1 )
		{
		GLOBAL $img, $config;

		TWIGDebug( "TWIGGenerateTabs( array, \"" . $selected . "\" );" );

		if( !$config["tabcolorlight"] ) { $config["tabcolorlight"] = "#c6c6c6"; }
		if( !$config["tabcolordark"] ) { $config["tabcolordark"] = "#848484"; }

 		$tabbuffer = "<table border=0 cellpadding=0 cellspacing=0>\n";
 		$tabbuffer .= "<tr align=bottom>\n";
		
		for( $i = 0, $j = count( $contents ); $i < $j; $i++ )
			{
		 	$tabbuffer .= "<td>\n";
	  		$tabbuffer .= "<table border=0 cellpadding=0 cellspacing=0>\n";
			if( $i == $selected ) 
				{
				$tabbuffer .= "<tr height=1><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#000000\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#000000\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				$tabbuffer .= "<tr height=30><td height=30 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><font face=\"" . $config["cellfont"] . "\" size=" . $config["textfontsize"] . ">[" . $contents[$i] . "]</font></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolordark"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"#000000\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				$tabbuffer .= "<tr height=4><td height=4 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=4 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=4 bgcolor=\"" . $config["tabcolordark"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=4 bgcolor=\"#000000\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				}
			else
				{
				$tabbuffer .= "<tr height=1><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#000000\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				$tabbuffer .= "<tr height=1><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=1 width=1 bgcolor=\"#000000\"></td><td height=1 width=1 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				$tabbuffer .= "<tr height=30><td height=30 bgcolor=\"#FFFFFF\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><font face=\"" . $config["cellfont"] . "\" size=" . $config["textfontsize"] . ">" . $contents[$i] . "</font></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolorlight"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"" . $config["tabcolordark"] . "\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td><td height=30 bgcolor=\"#000000\"><img src=\"" . $img["empty"] . "\" alt=\"\"></td></tr>\n";
				}
			$tabbuffer .= "</table>\n";
 			$tabbuffer .= "</td>\n";
			}

 		$tabbuffer .= "</tr></table>\n";

		return $tabbuffer;
		}

  	Function TWIGGenerateLeftRightOptions( &$left, &$right, $name, $lefthead, $righthead, $size = 5 )
		{
		GLOBAL $config;

		TWIGDebug( "TWIGGenerateLeftRightOptions( array, array, \"" . $name . "\", \"" . $lefthead . "\", \"" . $righthead . "\", \"" . $size . "\" );" );

		$buf  = "<table border=0 cellspacing=0 cellpadding=0>\n";
		$buf .= " <tr>\n"; 
		$buf .= "  <td>" . $lefthead . "</td>\n"; 
		$buf .= "  <td>&nbsp;</td>\n"; 
		$buf .= "  <td>" . $righthead . "</td>\n"; 
		$buf .= " </tr>\n"; 
		$buf .= " <tr>\n"; 
		$buf .= "  <td>\n"; 

		if( is_array( $left ) )
			{
			reset( $left );
 			while( list( $key, $val ) = each( $left ) )
				{
				$buf .= "   <input type=hidden name=" . $name . "_orig_left[" . $key . "] value=\"" . urlencode( $left[$key] ) . "\">\n";
				}
			}

		$buf .= "   <select name=" . $name . "_sel_left[] size=" . $size . " multiple>\n";

		if( is_array( $left ) )
			{
			reset( $left );
 			while( list( $key, $val ) = each( $left ) )
				{
				$buf .= "    <option value=" . $key . ">" . $left[$key] . "</option>\n";
				}
			}

		$buf .= "   </select>\n";
		$buf .= "  </td>\n";
		$buf .= "  <td valign=middle>\n"; 
		$buf .= "   <input type=submit name=" . $name . "_sub value=\"&gt;&gt;\"><BR><BR><input type=submit name=" . $name . "_unsub value=\"&lt;&lt;\">";
		$buf .= "  </td>\n";
		$buf .= "  <td>\n"; 

		if( is_array( $right ) )
			{
			reset( $right );
 			while( list( $key, $val ) = each( $right ) )
				{
				$buf .= "   <input type=hidden name=" . $name . "_orig_right[" . $key . "] value=\"" . urlencode( $right[$key] ) . "\">\n";
				}
			}

		$buf .= "   <select name=" . $name . "_sel_right[] size=" . $size . " multiple>\n";

		if( is_array( $right ) )
			{
			reset( $right );
 			while( list( $key, $val ) = each( $right ) )
				{
				$buf .= "    <option value=" . $key . ">" . $right[$key] . "</option>\n";
				}
			}

		$buf .= "   </select>\n";
		$buf .= "  </td>\n";
		$buf .= " </tr>\n";
		$buf .= "</table>\n";

		return $buf;
		}

 	Function TWIGProcessLeftRightOptions( $name )
		{
		$varvarname_sub = $name . "_sub";
		$varvarname_unsub = $name . "_unsub";
		$varvarname_left = $name . "_left";
		$varvarname_right = $name . "_right";
		$varvarname_sel_left = $name . "_sel_left";
		$varvarname_sel_right = $name . "_sel_right";
		$varvarname_orig_left = $name . "_orig_left";
		$varvarname_orig_right = $name . "_orig_right";
		GLOBAL $$varvarname_sub, $$varvarname_unsub;
		GLOBAL $$varvarname_left, $$varvarname_right;
		GLOBAL $$varvarname_sel_left, $$varvarname_sel_right;
		GLOBAL $$varvarname_orig_left, $$varvarname_orig_right;

		TWIGDebug( "TWIGProcessLeftRightOptions( \"" . $name . "\" )" );

 		if( ${$name . "_sub"} || ${$name . "_unsub"} )
 			{
 			if( ${$name . "_unsub"} )
 				{
 				if( is_array( ${$name . "_sel_right"} ) )
 					{
 					while( list( $key, $val ) = each( ${$name . "_sel_right"} ) )
 						{
						${$name . "_orig_left"}[$val] = ${$name . "_orig_right"}[$val];
						unset( ${$name . "_orig_right"}[$val] );
 						}
 					}
 				}

 			if( ${$name . "_sub"} )
 				{
 				if( is_array( ${$name . "_sel_left"} ) )
 					{
 					while( list( $key, $val ) = each( ${$name . "_sel_left"} ) )
 						{
						${$name . "_orig_right"}[$val] = ${$name . "_orig_left"}[$val];
						unset( ${$name . "_orig_left"}[$val] );
 						}
 					}
 				}
			}
	
		if( is_array( ${$name . "_orig_left"} ) )
			{
			reset( ${$name . "_orig_left"} );
			while( list( $key, $val ) = each( ${$name . "_orig_left"} ) )
				{
				${$name . "_left"}[$key] = urldecode( $val );
				}
			}

		if( is_array( ${$name . "_orig_right"} ) )
			{
			reset( ${$name . "_orig_right"} );
			while( list( $key, $val ) = each( ${$name . "_orig_right"} ) )
				{
				${$name . "_right"}[$key] = urldecode( $val );
				}
			}
 		}

	Function TWIGPrevNext( $currentlow, $total, $pagesize, $context, $linkoption, $displaytype="arrows")
	  	{
	  	GLOBAL $img, $config, $TWIGphrase, $dbconfig;

		if( !$displaytype ) { $displaytype = GetPref( "prevnext", $dbconfig["global_prefs_table"], $config["defaults"]["global"]["prevnext"] ); }

	  	if( $pagesize < 1 ) { $pagesize = 1; }
	  	if( $currentlow > $total ) { $currentlow = $total; }

	  	$currenthigh = $currentlow + $pagesize - 1;

	  	if( $currenthigh > $total ) { $currenthigh = $total; }
	  	if( $currentlow == $currenthigh ) { $current = $currentlow; } else { $current = $currentlow . " - " . $currenthigh; } 

	  	if( $currentlow > 1 )
	    		{
	    		$prevhigh = $currentlow - 1;
	    
			if( ( $currentlow - $pagesize ) > 0) { $prevlow = $currentlow - $pagesize; } else { $prevlow = 1; }

	    		if( $prevlow == $prevhigh ) { $prev = "$prevlow"; } else { $prev = $prevlow . " - " . $prevhigh; }
	    		}

	  	if( $currenthigh < $total )
	    		{
	    		$nextlow = $currenthigh + 1;
	    		$nexthigh = $currenthigh + $pagesize; 

	    		if( $nexthigh > $total ) { $nexthigh = $total; }
	    		if( $nextlow == $nexthigh ) { $next = "$nextlow"; } else { $next = $nextlow . " - " . $nexthigh; }
	    		}

	  	if( $pagesize > 1 ) 
	    		{
	    		if( ( $current + $pagesize ) > $total ) { $currentstr = $current - $total; } else { $currentstr = $current . " - " . ( $current + $pagesize - 1 ); }
	    		}

  		include( "lib/prevnext/" . $displaytype . ".prevnext.php3" );

	  	return $out;
	  	}

	// Function to decode a MIME-encoded string
	// Returns the original string, if not MIME
	// See rfc1522 for details
	// Unabashedly ripped from imp - anoah
	Function TWIGDecodeMimeString( $string ) 
  		{
   		GLOBAL $config;
  
		TWIGDebug( "TWIGDecodeMimeString( \"" . $string . "\" );", 30 );

  		$pos = strpos( $string, "=?" );

  		if( !is_int( $pos ) ) {	return $string;	}
  
  		$preceding = substr( $string, 0, $pos ); // save any preceding text
  
   		$end = strlen( $string );
   		$search = substr( $string, $pos+2, $end - $pos - 2 ); // the mime header spec says this is the longest a single encoded word can be

  		$d1 = strpos( $search, "?" );
  		if( !is_int( $d1 ) ) { return $string; }
  
   		$charset = strtolower(substr( $string, $pos+2, $d1 ));
  		$search = substr( $search, $d1+1 );
  
  		$d2 = strpos( $search, "?" );
  		if( !is_int( $d2 ) ) { return $string; }
  
  		$encoding = substr( $search, 0, $d2 );
  		$search = substr( $search, $d2+1 );
  
  		$end = strpos( $search, "?=" );
  		if( !is_int( $end ) ) { return $string; }
  
  		$encoded_text = substr( $search, 0, $end );
  		$rest = substr( $string, ( strlen( $preceding . $charset . $encoding . $encoded_text ) + 6 ) );
  
  		switch( $encoding ) 
			{
  			case "Q":
  			case "q":
				// the new twig way: str_replace is faster
    				$encoded_text = str_replace( "_", " ", $encoded_text );
    				$decoded = quoted_printable_decode( $encoded_text );

				// the old twig way: ereg is slower, but works in old php
    				// $encoded_text = ereg_replace( '_', ' ', $encoded_text );
    				// $decoded = quoted_printable_decode( $encoded_text );

    				break;
  			case "B":
  			case "b":
    				$decoded = urldecode( base64_decode( $encoded_text ) );

    				break;
  			default:
    				$decoded = "=?" . $charset . "?" . $encoding . "?" . $encoded_text . "?=";

    				break;
  			}

   		if( $config["globalcharset"] ) 
			{ 
  			if( $config["globalcharset"] != $charset ) 
				{
 				$from = $config["charactersets"][$charset];
				$to =  $config["charactersets"][$config["globalcharset"]];

  				if( $from && $to ) { $decoded = convert_cyr_string( $decoded, $from, $to ); }	
  				}
  			}
  
  		return $preceding . $decoded . TWIGDecodeMimeString( $rest );
		}

	Function TWIGProcessGPCString( $string )
		{
		global $config;

		if( !isset( $config["GMQGPC"] ) ) { $config["GMQGPC"] = get_magic_quotes_gpc() + 1; }

		if( $config["GMQGPC"] == 2 )
			{
			return stripslashes( $string );
			}
		else
			{
			return $string;
			}
		}

	Function TWIGProcessGPCtoSQL( $string )
		{
		global $config;

		if( !$config["GMQGPC"] ) { $config["GMQGPC"] = get_magic_quotes_gpc() + 1; }

		if( $config["GMQGPC"] == 1 )
			{
			return addslashes( $string );
			}
		else
			{
			return $string;
			}
		}

        Function TWIGBytesToText( $size = 0 )
                {
                $ranges = array( "B", "KB", "MB", "GB", "TB" );

                if( $size == 0 ) { return "0" . $ranges[0]; }

                $range = floor( floor( log10( $size ) ) / 3 );
                $val = substr( $size / pow( 10, 3 * $range), 0, 3 );

                $ret = sprintf( "%3.0f%s", $val, $ranges[$range] );

                return $ret;
                }	

	Function TWIGdate($format, $timestamp)
		{
		GLOBAL $dayNames, $monthNames;
	
		$str = date( $format, $timestamp );
		$str = str_replace( date( "l", $timestamp ), $dayNames[date( "w", $timestamp )], $str );
		$str = str_replace( date( "F", $timestamp ), $monthNames[date( "n", $timestamp )], $str );

		return $str;
		}

  	Function TWIGExecuteServerCommands( $opencon, $CmdArray )
 		{
 		$cmdtotal = count( $CmdArray );
		$fnum = 0;
 	
 		for( $cmdnum = 0; $cmdnum < $cmdtotal; $cmdnum++ )
 			{
 			if( $CmdArray[$cmdnum][0] ) { fwrite( $opencon, $CmdArray[$cmdnum][0] . "\r\n" ); }
 	
 			if( $CmdArray[$cmdnum][1] )
 				{
 				$chr = "";
 				$rstring = "";
 				while( ord( $chr ) != 10 ) 
 					{ 
 					$rstring .= $chr;
 					$chr = fgetc( $opencon );
 					}
 			
 				if( substr( $rstring, 0, strlen( $CmdArray[$cmdnum][1] ) ) != $CmdArray[$cmdnum][1] ) 
					{	
					$failures[$fnum]["sequence"] = $cmdnum;
					$failures[$fnum]["command"] = $CmdArray[$cmdnum][0];
					$failures[$fnum]["expected"] = $CmdArray[$cmdnum][1];
					$failures[$fnum]["result"] = $rstring;
					$failures[$fnum]["type"] = $CmdArray[$cmdnum][2];
						
					$fnum++;

					if( $CmdArray[$cmdnum][2] == 0 )
						{
						return $failures;
						}
					}
 				}
 			}
 	
		$failures["count"] = $fnum;

		return $failures;
 		}

	Function TWIGPrintESCErrors( $ESCErrors )
		{
		for( $i = 0; $i < $ESCErrors["count"]; $i++ )
			{
			if( $ESCErrors[$i]["type"] == 1 )
				{
				TWIGPrintError( "Warning on server command(" . $ESCErrors[$i]["sequence"] . "): " . $ESCErrors[$i]["command"] . " expected result: " . $ESCErrors[$i]["expected"] . " received result: " . $ESCErrors[$i]["result"] . " (" . substr( $ESCErrors[$i]["result"], 0, strlen( $ESCErrors[$i]["expected"] ) ) . ")" );
				}
			else
				{
				TWIGPrintError( "Error on server command(" . $ESCErrors[$i]["sequence"] . "): " . $ESCErrors[$i]["command"] . " expected result: " . $ESCErrors[$i]["expected"] . " received result: " . $ESCErrors[$i]["result"] . " (" . substr( $ESCErrors[$i]["result"], 0, strlen( $ESCErrors[$i]["expected"] ) ) . ")" );
				}
			}
		}

	Function TWIGGetTimeFormat()
		{
		GLOBAL $config, $dbconfig;

		$ret = $config["timeformat"][GetPref( "timeformat", $dbconfig["global_prefs_table"], $config["defaults"]["global"]["timeformat"] )];

		if( !$ret ) { $ret = $config["timeformat"]["12"]; }

		return $ret;
		}

  	Function TWIGCheckTimeFormat( $fstring )
  		{
  		GLOBAL $config;
 
  		// there should be either "h", "g", "H" or "G" in timeformat, if unsure use "am/pm" 
  
  		if( ereg( "H|G", $fstring ) ) { return 24; }
  		else { return 12; }
  		}
		
	Function TWIGDateTimeFromUTime( $utime )
		{
		$year = date ( "Y", $utime );
		$month = date ( "n", $utime );
		$day = date ( "j", $utime );
		$hour = date( "H", $utime );
		$minute = date( "i", $utime );

		return array( $year, $month, $day, $hour, $minute );
		}

	Function TWIGTimeCleanup( $hour, $minute, $ampm )
		{
		if( !isset( $hour ) )
			{
			$hour = date( "H" );
			}

		if( !isset( $minute ) )
			{
			$minute = date( "i" );
			}
		//$minute = 5 * round( $minute / 5 );
		$minute = $minute - $minute % 5;
		while( $minute > 59 )
			{
			$hour++;
			$minute -= 60;
			}

		if( $ampm == "PM" )
			{
  			if( $hour < 13 )
				{
				$hour += 12;
				}
			}

		if( $ampm == "AM" )
			{
			if( $hour == 12 )
				{
				$hour = 0;
				}
			}

		$day = 0;
		while( $hour > 24 )
			{
			// This is a "remainder" of sorts (well, days, actually ;-).
			$day++;
			$hour -= 24;
			}

		return array( $hour, $minute, $day );
		}

	Function TWIGDateCleanup( $year, $month, $day, $extra_days )
		{
		if( !isset( $year ) )
			{
			$year = date( "Y" );
			}

		if( !isset( $month ) )
			{
			$month = date( "m" );
			}
		while( $month > 12 )
			{
			$year++;
			$month -= 12;
			}
		while( $month < 1 )
			{
			$year--;
			$month += 12;
			}

		if( !isset( $day ) )
			{
			$day = date( "j" );
			}
		$day += $extra_days;

		// The last day of this month is the 0th day of next month
		$lastday = date( "j", mktime(0, 0, 0, $month + 1, 0, $year ) );
		while( $day > $lastday )
			{
			$month++;		// Add the number of days of *this* month
			$day -= $lastday;	// To skip to the correct day of *next* month
			$lastday = date( "j", mktime(0, 0, 0, $month + 1, 0, $year ) );
			}
		while( $day < 1 )
			{
			$month--;
			$lastday = date( "j", mktime(0, 0, 0, $month + 1, 0, $year ) );
			$day += $lastday;	// Add the number of days of *last* month
			}			// To skip to the correct day of *this* month

		// Recalculate the month/year because we just readjusted the day/month
		while( $month > 12 )
			{
			$year++;
			$month -= 12;
			}
		while( $month < 1 )
			{
			$year--;
			$month += 12;
			}

		return array( $year, $month, $day );
		}
  
  	Function TWIGTimeSelector( $prefix, $hour, $minute )
  		{
  		GLOBAL $config;
  
  		$timeformat = TWIGCheckTimeFormat( TWIGGetTimeFormat() );
 
  		if( $timeformat == 24 ) 
 			{ 
 			$hour_start = 0; 
 			$hour_end = 23; 
 			}
  		else
  			{
  			$hour_start=1;
  			$hour_end=12;
 
  			if( $hour > 11 )
  				{
  				$hour -= 12;
  				$ampm = "PM";
  				}
  			else 
 				{ 
 				$ampm = "AM"; 
 				}
 
  			if( $hour == 0 ) { $hour = 12; }
  			}
  			
  		$hour_str = "<select name=\"" . $prefix . "Hour\">\n";
  
  		for( $i = $hour_start; $i <= $hour_end; $i++ )
  			{
  			if( $hour == $i ) { $hour_str .= "<option selected>" . $i . "</option>";}
  			else { $hour_str .= "<option>" . $i . "</option>"; }
  			}
 
  		$hour_str .= "\n</select>";
  
  		$min_str = "<select name=\"" . $prefix . "Minute\">\n";
 
  		for( $i = 0; $i < 60; $i += 5 )
  			{
  			$min = $i;
 
  			if( $min < 10 ) { $min = "0" . $min; }
 
  			if( $minute == $min) { $min_str .= "<option selected>" . $min . "</option>";}
  			else { $min_str .= "<option>" . $min . "</option>"; }
  			}
 
  		$min_str .= "\n</select>\n";
  
  		if( $timeformat == 12 )
  			{
  			$ampm_str = "<select name=\"" . $prefix . "AMPM\">";
 
  			if( $ampm == "AM" ) { $ampm_str .= "<option selected>AM</option>\n<option>PM</option>\n"; }
  			else { $ampm_str .= "<option>AM</option>\n<option selected>PM</option>\n"; }
 
  			$ampm_str .= "</select>\n";
  			}
  		else 
 			{ 
 			$ampm_str = ""; 
 			}
  
  		return $hour_str . "<b>:</b>\n" . $min_str . $ampm_str;
  		}
 
   	Function TWIGDateSelector( $prefix, $year, $month, $day )
   		{
   		GLOBAL $config, $TWIGphrase, $monthNames;
 
	      		$ret .= "<SELECT name=" . $prefix . "Month>\n";
      
 			for( $i = 1; $i <= 12; $i++ )
        				{
        				$ret .= "<option ";
        				if( $month == $i ) { $ret .= "selected "; }
	        			$ret .= "value=" . $i . ">" . $monthNames[$i] . "</option>\n";
        				}
 
 			$ret .= "</SELECT>\n";

	    		$ret .= "<SELECT name=" . $prefix . "Day>\n";
 
      			for( $i = 1; $i <= 31; $i++ )
        				{
        				$ret .= "<option ";
		       			if( $day == $i ) { $ret .= "selected "; }
        				$ret .= "value=" . $i . ">" . $i . "</option>";
        				}
    
	 		$ret .= "</SELECT>\n";

	    		$ret .= "<SELECT name=" . $prefix . "Year>\n";
 	
      			for( $i = $year - 10, $j = $year + 10; $i < $j; $i++ )
        				{
        				$ret .= "<option ";
        				if( $year == $i ) { $ret .= "selected "; }
	        			$ret .= "value=" . $i . ">" . $i . "</option>\n";
        				}
 
    			$ret .= "</SELECT>\n";

 		return $ret;
 		}

	$included["common.inc.php3"] = 1;
	}

?>
