<?php

require( "lib/auth/" . $config["auth_provider"] . ".authpro.inc.php3" );

Function TWIGLogout( $realm = "TWIG" )
	{
	global $config_dir, $error, $mbox, $config, $img, $version, $vhosts, $SERVER_NAME;

	TWIGCheckAuth( $mbox, 1 );

	TWIGCleanSession();
	TWIGCleanContext();

	if( $config["auth_logout_redirect"] ) 
		{  
		header( "Location: " . $config["auth_logout_redirect"] );	
		}

	Header( "WWW-authenticate: basic realm=\"$realm\"" );
	Header( "HTTP/1.0 401 Unauthorized" );

	if( $vhosts[$SERVER_NAME] && is_readable($vhosts[$SERVER_NAME] . "header.inc.php3") ) {include($vhosts[$SERVER_NAME] . "header.inc.php3");}
	else {include($config_dir . "header.inc.php3");}

	TWIGPrintError( "To completely logout you must close your browser now." );

	if( $vhosts[$SERVER_NAME] && is_readable($vhosts[$SERVER_NAME] . "footer.inc.php3") ) {include($vhosts[$SERVER_NAME] . "footer.inc.php3");}
	else {include($config_dir . "footer.inc.php3");}

	exit;
	}

 // Basic Authentication Method
Function TWIGAuth( $realm = "TWIG", $logout = "" ) 
	{
	global $version, $login, $session, $config, $config_dir, $img, $twig_username, $twig_password, $PHP_AUTH_USER, $PHP_AUTH_PW, $vhosts, $SERVER_NAME;

	// Require a username/password from the user
	if( $logout ) 
		{
		if( !$PHP_AUTH_USER || $error["auth"] || $logout ) 
			{
			TWIGLogout( $realm );
			}
		else 
			{
			$login["username"] = $PHP_AUTH_USER;
			$login["password"] = $PHP_AUTH_PW;
			TWIGStoreLogin( $login["username"], $login["password"], $config["auth_timeout"] );
			}
		}
	else if( !is_array( $login ) ) 
		{
		Header( "WWW-authenticate: basic realm=\"$realm\"" );
		Header( "HTTP/1.0 401 Unauthorized" );

		if( $vhosts[$SERVER_NAME] && is_readable($vhosts[$SERVER_NAME] . "header.inc.php3") ) {include($vhosts[$SERVER_NAME] . "header.inc.php3");}
		else {include($config_dir . "header.inc.php3");}

		if( $vhosts[$SERVER_NAME] && is_readable($vhosts[$SERVER_NAME] . "footer.inc.php3") ) {include($vhosts[$SERVER_NAME] . "footer.inc.php3");}
		else {include($config_dir . "footer.inc.php3");}

		exit;
		}
	else 	
		{
		$login["username"] = $PHP_AUTH_USER;
		$login["password"] = $PHP_AUTH_PW;
		list( $validuser, $mbox ) = TWIGCheckAuth( $mbox );

		if( !$validuser ) 
			{
			Header( "WWW-authenticate: basic realm=\"$realm\"" );
			Header( "HTTP/1.0 401 Unauthorized" );

			if( $vhosts[$SERVER_NAME] && is_readable($vhosts[$SERVER_NAME] . "header.inc.php3") ) {include($vhosts[$SERVER_NAME] . "header.inc.php3");}
			else {include($config_dir . "header.inc.php3");}

			TWIGPrintError( "Login failed - Probably a misspelled username or password, please try again." );

			if( $vhosts[$SERVER_NAME] && is_readable($vhosts[$SERVER_NAME] . "footer.inc.php3") ) {include($vhosts[$SERVER_NAME] . "footer.inc.php3");}
			else {include($config_dir . "footer.inc.php3");}

			exit;
			}
		else 
			{ 
			return $mbox; 
			}
		}
 	}
?>
