<?php	// TWIG		Userperms Group related functions.	?>
<?php

//  Current permission bits are as follows:
//	1  :  View Items
//	2  :  Edit Items
//	4  :  Add Items
//	8  :  Delete Items
//	16 :  Group Administrator (view, add, delete, & edit group members)
//
//  So a permissions value of 15 would be everything but admin and so forth.

if( !isset( $included["lib/groups/userperms.groups.inc.php3"] ) )
	{
	$TWIGCurrentGroupFeatures = array( 	array( "name"=>"todo", "table"=>$dbconfig["todo_table"] ),
						array( "name"=>"contacts", "table"=>$dbconfig["contact_table"] ),
						array( "name"=>"schedule", "table"=>$dbconfig["schedule_table"] ),
						array( "name"=>"bookmarks", "table"=>$dbconfig["bookmarks_table"] ),
						array( "name"=>"notes", "table"=>$dbconfig["notes_table"] )
					 );
	//Initialize the group cache
	$TWIGGroupsCache = array( "0" => array( "name" => $TWIGphrase["Unfiled"], "type"=>"userperms"),
				  "*" => array(	"name" => $TWIGphrase["ALL"], "type"=>"userperms")
				);

	Function TWIGGroupsHasPerms($userperms, $reqperms)
		{
		$binreqperms=decbin($reqperms);
		$binuserperms=decbin($userperms);
		$lenreq=strlen($binreqperms);
		$lenuser=strlen($binuserperms);

		if($lenreq>$lenuser) {$fail=TRUE;}
		else
			{
			for ($i=1; $i<=$lenreq; ++$i)
				{
				if($binuserperms[$lenuser-$i]<$binreqperms[$lenreq-$i])
					{
					$fail=TRUE;
					$i=$lenreq;
					}
				}
			}
		return !$fail;
		}

	Function TWIGGroupsCreateSQLGroupQuery($username, $grouplist, $table="", $perms=0)
		{
		TWIGDebug("TWIGGroupsCreateSQLGroupQuery( \"$username\", array, \"$table\", $perms );");

		if( !is_array( $grouplist ) ) { $grouplist = array( "*" ); }
		if ($table) { $table .= "."; }

		for ($i=0, $j=count($grouplist); $i<$j; ++$i)
			{
			if ($ret) {$ret .= " OR ";}
			if($grouplist[$i]=="*")
				{
			  	$ret = "(" . $table . "username = '$username' AND " . $table . "groupid=0)";
				$gm = TWIGGroupsMembership($username);
				if($gm) { $ret .= " OR " . $table . "groupid=" . join($gm, " OR " . $table . "groupid = ");}
				$i=$j;
				}
			elseif($grouplist[$i]=='0') {$ret .= "(" . $table . "username='$username' AND " . $table . "groupid=0)";}
			elseif(TWIGGroupsMemberOf($grouplist[$i],$perms)) {$ret .= $table . "groupid=" . $grouplist[$i];}
			}
		return $ret;
		}

	Function TWIGGroupsGetName($gid) 
		{
  		GLOBAL $dbconfig, $TWIGphrase, $TWIGGroupsCache;
		TWIGDebug( "TWIGGroupsGetName( \"$gid\" );", 20 );
	  	if(!isset($TWIGGroupsCache[$gid]["name"] ))
			{
	   		$result = dbQuery("SELECT groupname FROM " . $dbconfig["groups_table"] . " WHERE id = '$gid'" );
			if(dbNumRows($result)) {$TWIGGroupsCache[$gid]["name"] = dbResult($result, 0, "groupname");}
			else {$TWIGGroupsCache[$gid]["name"] = $TWIGphrase["[empty]"];}
			}
		return $TWIGGroupsCache[$gid]["name"];
   		}

 	Function TWIGGroupsMemberOf($gid, $perms=0) 
		{
	  	GLOBAL $login, $dbconfig, $TWIGGroupsCache, $disabled;
		TWIGDebug( "TWIGGroupsMemberOf( \"$gid\", \"$perms\" );", 20 );

		if ($gid==0) { return TRUE; }
		elseif(isset($TWIGGroupsCache[$gid]["perms"])) { return TWIGGroupsHasPerms($TWIGGroupsCache[$gid]["perms"], $perms); }
		else
			{
			$result=dbQuery("SELECT username,writeperms FROM " . $dbconfig["members_table"] . " WHERE (username='" . $login["username"] . "' OR username='*') AND groupid='$gid'");
			for($i=0, $j=dbNumRows($result); $i<$j; ++$i)
				{
				$groupentry=dbResultArray($result, $i);
				if(($groupentry["username"]=="*") && !$disabled["global_groups"]) {$globalperms=$groupentry["writeperms"];}
				else
					{
					$TWIGGroupsCache[$gid]["perms"]=$groupentry["writeperms"];
					$pass=TWIGGroupsHasPerms($TWIGGroupsCache[$gid]["perms"], $perms);
					$i=$j;
					}
				}
			if (!isset($TWIGGroupsCache[$gid]["perms"]) && isset($globalperms))
				{
				$TWIGGroupsCache[$gid]["perms"]=$globalperms;
				$pass=TWIGGroupsHasPerms($TWIGGroupsCache[$gid]["perms"], $perms);
				}
			}
		return $pass;
		}

	 // Returns members of $gid group with at least $perms access
	 Function TWIGGroupsMembers($gid, $perms=0) 
		{
	  	GLOBAL $dbconfig;
	
		TWIGDebug( "TWIGGroupsMembers( \"$gid\", \"$perms\" );", 20 );

	  	if( $gid == "*" ) {$query = "SELECT username,writeperms FROM " . $dbconfig["members_table"];}
	  	else {$query = "SELECT username,writeperms FROM " . $dbconfig["members_table"] . " WHERE groupid = '$gid'";}
		$result = dbQuery( $query );
	  	for($i=0, $j=dbNumRows($result); $i < $j; ++$i ) 
			{
			if(TWIGGroupsHasPerms(dbResult($result, $i, "writeperms"), $perms)) {$members[] = dbResult($result, $i, "username");}
	  		}
  		return $members;
	 	}
	
	 // Returns Groups $user is a member with at least $perms access
	 Function TWIGGroupsMembership($user, $perms=0) 
		{
	  	GLOBAL $dbconfig, $TWIGGroupsCache, $disabled;

		TWIGDebug( "TWIGGroupsMembership( \"$user\" );", 20 );
	
	  	$result = dbQuery("SELECT groupid,writeperms,username FROM " . $dbconfig["members_table"] . " WHERE username = '$user' OR username='*'");
	
		$j = dbNumRows($result);
	  	for($i = 0; $i < $j; ++$i) 
			{
			$groupdata = dbResultArray($result, $i);
			$gid = $groupdata["groupid"];
			if(!isset($TWIGGroupsCache[$gid]["type"]))
				{
				$result2 = dbQuery( "SELECT type FROM " .  $dbconfig["groups_table"] . " WHERE id='$gid'");
				if(dbNumRows($result2)) {$TWIGGroupsCache[$gid]["type"] = dbResult($result2, 0, "type");}
				}
			if($TWIGGroupsCache[$gid]["type"] == "userperms")
				{
				if(($groupdata["username"]=="*") && !$disabled["global_groups"]) {$globalgroups[]=$groupdata;}
				else
					{
					if(!isset($TWIGGroupsCache[$gid]["perms"])) {$TWIGGroupsCache[$gid]["perms"] = $groupdata["writeperms"];}
					if(TWIGGroupsHasPerms($TWIGGroupsCache[$gid]["perms"], $perms)) {$groups[] = $gid;}
					}
				}
	  		}
		for($i=0, $j=count($globalgroups); $i<$j; ++$i)
			{
			$gid=$globalgroups[$i]["groupid"];
			if(!isset($TWIGGroupsCache[$gid]["perms"])) {$TWIGGroupsCache[$gid]["perms"] = $globalgroups[$i]["writeperms"];}
			if(TWIGGroupsHasPerms($TWIGGroupsCache[$gid]["perms"], $perms)) {$groups[]= $gid;}
			}

		//Kill duplicates caused by global groups
		if($groups)
			{
			sort($groups);
			$groupsfinal[]=$groups[0];
			for($i=1, $j=count($groups); $i<$j; ++$i)
				{
				if($groups[$i] != $groups[$i-1]) {$groupsfinal[] = $groups[$i];}
				}
			return $groupsfinal;
			}
		else {return array();}
	 	}
	
	Function TWIGGroupSortArray($first, $second)
		{
		return strcasecmp($first["description"], $second["description"]);
		}

	Function TWIGGroupsSelect($username = "", $gid = "" , $is_listoption = "", $perms=0)
		{
		GLOBAL $session, $login, $TWIGGroupsCache;
	
		TWIGDebug("TWIGGroupsSelect( \"$username\", \"$gid\", \"$is_listoption\" );");

		if(!$username) {$username=$login["username"];}
	
	  	$groups=TWIGGroupsMembership($username, $perms);
		$garray[]=array("description"=>$TWIGGroupsCache["*"]["name"], "id"=>"*");
		$garray[]=array("description"=>$TWIGGroupsCache["0"]["name"], "id"=>"0");	

		for($x=0, $y=count($groups); $x<$y; ++$x) 
			{
			$garray[] = array("description"=>TWIGGroupsGetName($groups[$x]), "id"=>$groups[$x]);
			}

		usort($garray, TWIGGroupSortArray);

		for($x=0, $y=count($garray); $x<$y; ++$x) 
			{
			if($garray[$x]["id"]==$gid) {$selected=" selected";} else { $selected = ""; }

	                if(!($is_listoption=="" && $garray[$x]["id"]=="*"))
				{ 
				$str .= "<option value=" . $garray[$x]["id"] . $selected . ">" . $garray[$x]["description"] . "</option>\n";
			 	}
			}
	  
		return $str;
	 	}
	
	Function TWIGGroupsSelector($Username = "", $GID = "", $IsListOption = "", $OptionName = "data_thisGroup", $GoName = "TWIGChangeGroup", $perms=0)
		{
		GLOBAL $login, $config, $context, $TWIGphrase;

		TWIGDebug( "TWIGGroupsSelector( \"$Username\", \"$GID\", \"$IsListOption\", \"$OptionName\", \"$GoName\" );" );

		$ret  = "<form action=" . $config["baseurl"] . " method=post>\n";
	   	$ret .= "<font face=\"" . $config["cellfont"] . "\" size=" . $config["textfontsize"] . ">\n";
   		$ret .= TWIGSession("put");
	   	$ret .= TWIGContext("put", $context["feature"]);
   		$ret .= $TWIGphrase["Group"] . ":"; 
   		$ret .= "<select name=" . $OptionName . ">\n";
   		$ret .= TWIGGroupsSelect($Username, $GID, $IsListOption, $perms);
	   	$ret .= "</select>\n";
   		$ret .= "<input type=submit value=\"" . $TWIGphrase["Go"] . "\" name=" . $GoName . ">\n";
   		$ret .= "</font>\n";
  		$ret .= "</form>\n";

		return $ret;
		}

	// Set group query info according to membership, etc.
	// if no group, set to default
	$featureprefix=$context["feature"];
	$featureGroup=$context["feature"] . "Group";
	if(isset($data_thisGroup)) {$session[$featureGroup]=$data_thisGroup;}

	if(!isset($session[$featureGroup])) {$session[$featureGroup]=GetPref("viewgrp", $dbconfig[$context["feature"] . "_prefs_table"], $config["defaults"][$context["feature"]]["viewgrp"]);}
	if(!(isset($session[$featureGroup]) && TWIGGroupsMemberOf($session[$featureGroup]))) {$session[$featureGroup] = "*";}

	//$groupquery is depreciated:  Use TWIGGroupsCreateSQLGroupQuery() instead.
	$groupquery=TWIGGroupsCreateSQLGroupQuery($login["username"], array($session[$featureGroup]), "", 1);
	if (!$groupquery) {$groupquery = "username=" . $login["username"];}

	$included["lib/groups/userperms.groups.inc.php3"] = 1;
	}	
?>
