<?php // ToDo compact display module for Main feature ?>
<!-- Begin Main - ToDo Module -->
<?php
if( true ) // Something about not displaying this feature
	{
	TWIGLoadLanguageFile( "features/todo/strings/", "", $config["language"] );
	require( "features/todo/todo.inc.php3" );
	// Make sure we don't get leftovers from something before us
	unset( $headers );
	unset( $contents );

	$sortorder = array( "item"=>"item", "group"=>"groupid,priority", "priority"=>"priority", "status"=>"completed", "duedate"=>"duedate" );
	$sortordernum = array( "item"=>0, "groupid,priority"=>1, "priority"=>2, "status"=>3, "duedate"=>4 );
	if( !$session["tsortby"] ) { $session["tsortby"] = $sortorder[GetPref( "sortby", $dbconfig["todo_prefs_table"], $config["defaults"]["todo"]["sortby"] )]; }
	if( !$session["tsortby"] ) { $session["tsortby"] = "priority"; }
	$sortway = array( "", " DESC" );
	if( !$session["tsortbyway"] ) { $session["tsortbyway"] = $sortway[GetPref( "sortorder", $dbconfig["todo_prefs_table"], $config["defaults"]["todo"]["sortorder"] )]; }

	$hilights = array( array( "", "" ), array( "", "" ), array( "", "" ), array( "", "" ), array( "", "" ) );
	$hilights[$sortordernum[$session["tsortby"]]] = array( "[", "]" );

	if( $session["tsortbyway"] ) { $tmpsortbyway = ""; } else { $tmpsortbyway = " DESC"; }

	$soitem = array( array( "item"=>"tsortby", "value"=>"item" ), array( "item"=>"tsortbyway", "value"=>$tmpsortbyway ) );
	$sogroup = array( array( "item"=>"tsortby", "value"=>"groupid,priority" ), array( "item"=>"tsortbyway", "value"=>$tmpsortbyway ) );
	$sopriority = array( array( "item"=>"tsortby", "value"=>"priority" ), array( "item"=>"tsortbyway", "value"=>$tmpsortbyway ) );
	$socompleted = array( array( "item"=>"tsortby", "value"=>"completed" ), array( "item"=>"tsortbyway", "value"=>$tmpsortbyway ) );
	$soduedate = array( array( "item"=>"tsortby", "value"=>"duedate" ), array( "item"=>"tsortbyway", "value"=>$tmpsortbyway ) );

	$headers = array(	twigLink( $hilights[0][0] . TWIGPhrase( "Item" ) . $hilights[0][1], "todo", "", "", "", $soitem ),
//				"&nbsp;",
				twigLink( $hilights[1][0] . TWIGPhrase( "Group" ) . $hilights[1][1], "todo", "", "", "", $sogroup ),
//				"&nbsp;",
				twigLink( $hilights[2][0] . TWIGPhrase( "Priority" ) . $hilights[2][1], "todo", "", "", "", $sopriority ),
//				"&nbsp;",
				twigLink( $hilights[3][0] . TWIGPhrase( "Status" ) . $hilights[3][1], "todo", "", "", "", $socompleted ),
//				"&nbsp;",
				twigLink( $hilights[4][0] . TWIGPhrase( "Due Date" ) . $hilights[4][1], "todo", "", "", "", $soduedate )
				);

	$query = "SELECT * FROM " . $dbconfig["todo_table"] . " WHERE ($groupquery) ORDER BY " . $session["tsortby"] . " " . $session["tsortbyway"] . ",completed " . $session["tsortbyway"];
	$result = dbQuery( $query );

	if( !$startmsg ) { $startmsg = 1; }
	$pagesize = GetPref( "pagesize", $dbconfig["todo_prefs_table"], $config["defaults"]["todo"]["pagesize"] );

	if( $submitbutton["selectall"] ) { $marked = " CHECKED"; } else { $marked = ""; }

	$total = dbNumRows( $result );
	if( ( $pagesize == 0 ) || ( $startmsg + $pagesize > $total ) ) { $highitem = $total; } else { $highitem = $startmsg + $pagesize - 1; }

	for( $i = $startmsg - 1; $i < $highitem; $i++ )
		{
		$data = dbResultArray( $result, $i );

		$status = TWIGToDoStatus( $data );
		$itemp = TWIGImage( $img[$status], TWIGPhrase( $status ) );

		switch( $data["duetype"] )
			{
			case 0:
				$ddtemp = TWIGPhrase( "[None]" );
				break;
			case 1:
				$ddtemp = TWIGdate( $config["shortdateformat"], convertSQLTimetoUTime( $data["duedate"] ) );
				break;
			case 2:
				$ddtemp = TWIGdate( $config["shortdateformat"] . " " . TWIGGetTimeFormat(), convertSQLTimetoUTime( $data["duedate"] ) );
				break;
			}

		if( !isset( $data["priority"] ) )
			{
			$priority = "&nbsp;";
			}
		else
			{
			$priority = $data["priority"];
			}

		$today = date( "Ymd",mktime() );
		if( $ddtemp<>TWIGPhrase("[None]") && ($status<>"Complete" && $status<>"Canceled") ) {
				$tdate=date("Ymd",convertSQLTimetoUTime( $data["duedate"] ) );
				if( $tdate<$today && $ddtemp<>TWIGPhrase("[None]") ) {
						$ddclass="duedatepast";
				}
				else {
						if( $tdate==$today ) {
								$ddclass="duedatetoday";
						}
						else {
								$ddclass="duedatefuture";
						}
				}
		}

		$contents[$i] =	array( 	twigLink( TWIGImage( $img["project"], TWIGPhrase( "View ToDo Item" ) ) . $data["item"], "todo", "view", "ItemID=" . $data["id"] ) ,
//					"&nbsp;",
					twigLink( TWIGGroupsGetName( $data["groupid"] ), "todo", "", "session[$featureGroup]=" . $data["groupid"] ),
//					"&nbsp;",
					$priority,
//					"&nbsp;",
					$itemp,
//					"&nbsp;",
					array( "contents"=>$ddtemp, "class"=>$ddclass )
					);
		}
		if ( $i > 0 ) // Only display this block if there are any items to do
			{

?>
<table width="100%" border=0 cellspacing=0 cellpadding=0 class="formbody">
 <tr>
  <td valign="top" class="tabletitle">
   <b>
    <?php echo TWIGLink( TWIGPhrase( "ToDo" ), "todo" ); ?>
   </b>
  </td>
 </tr>
 <tr>
  <td>
   &nbsp;
  </td>
 </tr>
 <tr>
  <td valign="top">
   <?php echo TWIGGenerateTable( $headers, $contents, "", "95%", "center" ); ?>
  </td>
 </tr>
 <tr>
  <td>
   &nbsp;
  </td>
 </tr>
</table>
<?php
			}
}
?>
<!-- End Main - ToDo Module -->
