/* twpsk:  PSK31 for Linux with a Motif interface
 * Copyright (C) 1999-2006 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 3.0 - Jul 2008
 */

#ifndef SECQSOWIDS_H
#define SECQSOWIDS_H

#define SCOPE_HEIGHT 80

#include "GUI.h"
#include "twpskWids.h"
#include "twpskCB.h"
#include "decoderWids.h"
#include "server/server.h"
#include "twpskScope.h"

class DecoderWid {
   private:
      int i;
      int rxScrollFlag;
      int hasfocus;
      Arg args[30];
      char str[64];
      Scope dscope;
      float curfreq;
      int ch;

      Widget dialogShell;
      Widget   mainForm;
      Widget     rxTextSW;
      Widget       rxScrollBar;
      Widget       rxText;
      Widget   bottomForm;
      Widget     scopeDA;
      Widget   rxFreqCombo;
      Widget   pbForm;
      Widget      swapBtn, closeBtn;
      Widget AFCwid, DCDwid, QPSKwid;
      Widget modeForm;
      Widget clrRxPopup;
      XmString xs[5];


 public:

   void setCh (int c)
   {
      ch = c;
   }

   int getCh ()
   {
      return ch;
   }

   void setFreqFocus(int v)
   {
      hasfocus=v;
   }

   Widget getRxText ()
   {
      return rxText;
   }

   void setRxScrollFlag(int f)
   {
      rxScrollFlag = f;
   }

   int getRxScrollFlag ()
   {
      return (rxScrollFlag);
   }

   Boolean getQPSK()
   {
      Boolean value;
      XtVaGetValues(QPSKwid,
         XmNset, &value,
         NULL);
      return value;
   }

   void setQPSK(Boolean value)
   {
      XtVaSetValues(QPSKwid,
         XmNset, value,
         NULL);
   }

   Boolean getAFC()
   {
      Boolean value;
      XtVaGetValues(AFCwid,
         XmNset, &value,
         NULL);
      return value;
   }

   void setAFC(Boolean value)
   {
      XtVaSetValues(AFCwid,
         XmNset, value,
         NULL);
   }

   /* unused */
   void setControls(Boolean QPSK, int LSB, Boolean AFC)
   {
      setQPSK(QPSK);
      //setLSB(LSB);
      setAFC(AFC);
   }


   void setFreq(float freq)
   {
      curfreq = freq;
      //fprintf(stderr,"dw: set: %f\n",freq);
      sprintf(str, "%4.1f", freq);
      XmTextFieldSetString (rxfreqwid, str);
//TJW
      commControl(commChannel, COMM_FREQ, (int)(freq*100));
      }

   float getFreq()
   {
      String str;
      XtVaGetValues (rxfreqwid,  /* Get the freq */
         XmNvalue, &str,
         NULL);
      float f = atof(str);       /* convert to a float */
      //fprintf(stderr,"dw: get: %f\n",f);
      return f;
   }

   DecoderWid()
   {
      visible=0;
      hasfocus=0;
   }

   Widget rxfreqwid, rxUpArrow, rxDownArrow;
   int visible;
   int commChannel;
   static Widget shell;
   void move(int x, int y);
   Scope& getScope() { return dscope; };
   Widget getTextWid() { return rxText; };
   Widget getMainWid() { return dialogShell; };
   Widget getSwapBtn() { return swapBtn; }
   void buildWidgets(Widget shell, AppRes *appRes, int chan);
   void updateDisplay(float freq, int DCD, int IMD);
};


#define MAX_DECODERS 3
extern DecoderWid decoderWids[MAX_DECODERS];

#endif
