#include "AccessVariable.hh"

void 
AccessVariable::print(ostream& os) const {
  os << "AccessVariable of type "
    << variableType << ":\n  ";
  os << "curpos = " << curPos << " ";
  os << "value: " << val;
}


AccessVariable::AccessVariable() :
  AccessVarBase( "", ACCESS ),
  curPos(0){}

AccessVariable::AccessVariable( const string &newname ) : 
  AccessVarBase( newname, ACCESS ),
  curPos(0){}

AccessVariable::AccessVariable( const AccessVariable &v ) : 
  AccessVarBase( v.name, v.variableType ),
  curPos( v.curPos ),
  val( v.val ){}

AccessVariable &
AccessVariable::operator=( const AccessVariable & v) {
  curPos = v.curPos;
  val = v.val;
  variableType = v.variableType;

  return *this;
}

AccessVariable &
AccessVariable::operator=( const string &newVal ){
  curPos = 0;
  val = newVal;

  return *this;
}
