//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef _PORT_ASSOCIATION_HH_
#define _PORT_ASSOCIATION_HH_
#include "tyvis/Types.hh"

class PortAssociation {

public:

  PortAssociation();
  PortAssociation( VHDLType *actual, VHDLType *formal, PortType );
  ~PortAssociation();
  
  void setActual(VHDLType *actual) {
    actualPort = actual;
  }

  void setFormal(VHDLType *formal) {
    formalPort = formal;
  }

  void setMode(PortType portMode) {
    mode = portMode;
  }

  VHDLType *getActual(){
    return actualPort;
  }

  VHDLType *getFormal(){
    return formalPort;
  }

  PortType getMode(){
    return mode;
  }

private:
  VHDLType *actualPort;
  VHDLType *formalPort;
  PortType mode;
};
#endif
