#ifndef TRANSACTION_HH
#define TRANSACTION_HH

#include <new>
#include "tyvis/VHDLData.hh"
#include "tyvis/VHDLVTime.hh"
class VHDLKernel;

class Transaction {
  friend class SignalBase;
public:
  Transaction(const Transaction &);
  ~Transaction(){ delete value; }
  
  Transaction& operator==(const Transaction &) const;

  VHDLKernel *getSourceProcess() const { return sourceProcess; }
  const VHDLVTime &getTime() const { return transactionTime; }
  const unsigned int getSequenceNumber() const { return sequenceNumber; }
  const VHDLData *getValue() const { return value; }

  void *operator new( size_t size );
  void operator delete( void *toDelete );

protected:
  
private:
  VHDLKernel         *sourceProcess;
  const VHDLData     *value;
  const VHDLVTime    transactionTime;
  const unsigned int sequenceNumber;

  /** To create a transaction, ask the SignalBase for a new transaction
      entry by calling createNewTransaction() method... */
  Transaction( VHDLKernel *sourceProcess,
	       const VHDLVTime &,
	       const unsigned int,
	       const VHDLData * );

  static int getNextNumber();
};

#endif
