//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef VECTOR_HH
#define VECTOR_HH

#include <string.h>
#include "tyvis/ArrayInfo.hh"
#include "tyvis/VectorBase.hh"
#include "tyvis/ObjectBase.hh"
#include "tyvis/VHDLType.hh"

template<class type>
class Vector : public VectorBase {
private:
  type *vec;

public:
  Vector() {
    vec = NULL;
    numElems = 0;
    bounds = ArrayInfo();
  }
  
  Vector(ObjectBase::ObjectType, const TypeInfo& = TypeInfo::NULL_TYPE_INFO) {
    vec = NULL;
    numElems = 0;
    bounds = ArrayInfo();
  }

  //  Vector(ObjectBase::ObjectType obj, const Vector&);
  Vector(ObjectBase::ObjectType, char *);

  //Constructor using Array Aggregates
  Vector(ObjectBase::ObjectType, int left, ArrayInfo::ArrayDirn_t dirn,
	 int right, int noofElmntAssns, ...);

  // Constructor for handling char* objects
  Vector(ObjectBase::ObjectType, int, ArrayInfo::ArrayDirn_t, int, char *);
  
  virtual ~Vector();

  void setRange(ObjectBase::ObjectType, const TypeInfo&, ArrayInfo*, int);
  void setRange(ObjectBase::ObjectType, ArrayInfo*, int = 1,
		const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  void setRange(ObjectBase::ObjectType, VectorBase*);
  void setVec(type *v) { vec = v; };
  VectorBase* getNewArray(const ArrayInfo& newBounds, 
			  const ArrayInfo& actualBounds) const;

  virtual VHDLType& operator=(const VHDLType&);
  bool operator==(const VHDLType&) const;
  virtual char* getString() const;
//   Vector& operator=(const char *);
//   bool operator==(Type);
//   bool operator==(Vector);
//   bool operator!=(const VHDLType&) const { return false; };

  void assignSlice(VHDLType*, const ArrayInfo*, const ArrayInfo*);
  void assignSlice(VHDLType*, const ArrayInfo*);
  VHDLType& operator[](const int) const;
  type& operator[](const ScalarType&) const;

  void print(ostream& os = cout) const;

  //WARNING, get_element() is not equivalent to operator []
  //get_element() should be called internally only, and not in the
  // generated code

  virtual VHDLType& get_element(const int index) const {
    return vec[index];
  }

  virtual void setResolutionFunctionId(int resolutionFnId);
  virtual void setTypeConversionFunctionId(int typeConversionFnId);
  virtual void setElaborationInfo(const VHDLType &obj_info);

  VHDLType* clone() const;

  int savantwrite(SavantlineType &);
  int savantread (SavantlineType &);
};

template<class type>
void savantread(AccessVariable<char*> &line, Vector<type>& var) {
  for(int i=0; i<var.numElems; i++) {
    savantread(line, (type&)(var.get_element(i)));
  }
}

template<class type>
void savantread(SavantlineType &line, Vector<type>& var) {
  for(int i=0; i<var.numElems; i++) {
    savantread(line, (type&)(var.get_element(i)));
  }
}

template<class type>
void savantwrite(AccessVariable<char*> &line, Vector<type>& var,
			VHDLData::Side_t justified = RIGHT, int field = 0) {
  for(int i=0; i<var.numElems; i++) {
    savantwrite(line, (type&)(var.get_element(i)), justified, field);
  }
}

template<class type>
void savantwrite(SavantlineType &line, Vector<type>& var,
			VHDLData::Side_t justified = RIGHT, int field = 0) {
  for(int i=0; i<var.numElems; i++) {
    savantwrite(line, (type&)(var.get_element(i)), justified, field);
  }
}

template <class type>
ostream& operator << (ostream& os, const Vector<type>& var) {
//   int i;
//   for(i=0; i<var.numElems; i++) {
//     os << ( type&) (var.get_element(i));
//   }
  var.print(os);
  return os;
}

template<class type>
int savantwrite( VHDLKernel*, AccessVariable<char*> &line, 
		Vector<type>& var, VHDLData::Side_t justified = RIGHT, int field = 0) {
  for(int i=var.bounds.left(); i<=var.bounds.right(); 
      ((var.bounds.dirn() == to)? i++ : i--)) {
    savantwrite(line, (Type&)(var.get_element(i)));
  }
  return NORMAL_RETURN;
}

template<class type>
int savantread(VHDLKernel*, AccessVariable<char*> &line, 
		 Vector<type>& var, VHDLData::Side_t justified = RIGHT, int field = 0) {
  for(int i=var.bounds.left(); i<=var.bounds.right(); 
      ((var.bounds.dirn() == to)? i++ : i--)) {
    savantread(line, (Type&)(var.get_element(i)));
  }
  return NORMAL_RETURN;
}

template<class type>
int savantwrite(VHDLKernel*, SavantlineType &line, 
		Vector<type>& var, VHDLData::Side_t justified = RIGHT, int field = 0) {
  for(int i=var.bounds.left(); i<=var.bounds.right(); 
      ((var.bounds.dirn() == to)? i++ : i--)) {
    savantwrite(line, (Type&)(var.get_element(i)));
  }
  return NORMAL_RETURN;
}

template<class type>
int savantread( VHDLKernel*, 
		SavantlineType &line, 
		Vector<type>& var, 
		VHDLData::Side_t justified = RIGHT, 
		int field = 0 ){
  for(int i=var.bounds.left(); i<=var.bounds.right(); 
      ((var.bounds.dirn() == to)? i++ : i--)) {
    savantread(line, (Type&)(var.get_element(i)));
  }
  return NORMAL_RETURN;
}

template <class type>
int savantwrite( VHDLKernel* base, 
		 SavantlineType &line, 
		 Vector<type>& var, 
		 EnumerationType &side, 
		 IntegerType &width ){
  if (((UniversalInteger &) side.getObject()->readVal()).val == SavantsideType_info.get_right()) {
    savantwrite(base, line, var, RIGHT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
  else {
    savantwrite(base, line, var, LEFT, ((UniversalInteger &) width.getObject()->readVal()).val);
  }
}

#include "tyvis/Vector.cc"
#endif
