//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Ashif S. Harji 1997
// 
// Timeout.cc -- 
// 
// Author           : Ashif S. Harji
// Created On       : Thu Dec 11 10:17:16 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Aug  4 10:02:02 2004
// Update Count     : 67
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uIOManip.h>

uTask T1;						// forward declaration
uTask T2;						// forward declaration

uTask T1 {
    T2 *t2;

    void main();
  public:
    void mem1() {}
    void mem2() {}

    void partner( T2 &t ) {
	t2 = &t;
    } // partner
}; // T1

uTask T2 {
    T1 &t1;

    void main();
  public:
    T2( T1 &t1 ) : t1( t1 ) {}
    void cont() {}
}; // T2

void T1::main(){
    uTime starttime, endtime;

    uAccept( partner );					// close reference cycle

    // Test if timing out works.

    starttime = uThisProcessor().uGetClock().uGetTime();
    
    uAccept( mem1 ){
	uCout << uAcquire << this << " mem1 accepted" << endl << uRelease;
    } uOr uAccept( mem2 ){
	uCout << uAcquire << this << " mem2 accepted" << endl << uRelease;
    } uOr uTimeout( uDuration(1) ) {
	uCout << uAcquire << this << " timeout accepted" << endl << uRelease;	    
    }
    endtime = uThisProcessor().uGetClock().uGetTime();
    uCout << uAcquire << this << " ending at " << endtime - starttime << endl << uRelease;

    t2->cont();

    // Test calls which occur increasingly close to timeout value.

    for ( int i = 0; i < 23; i += 1 ) {
	starttime = uThisProcessor().uGetClock().uGetTime();
	
	uAccept( mem1 ){
	    uCout << uAcquire << this << " mem1 accepted" << endl << uRelease;
	} uOr uAccept( mem2 ){
	    uCout << uAcquire << this << " mem2 accepted" << endl << uRelease;
	} uOr uTimeout( uDuration(1) ) {
	    uCout << uAcquire << this << " timeout accepted" << endl << uRelease;	    

	    uAccept( mem1 ) {				// receive the call after the timeout
	    } uOr uAccept( mem2 );
	} // uAccept

	endtime = uThisProcessor().uGetClock().uGetTime();
	if ( i < 4 ) {
	    uCout << uAcquire << this << " ending at " << endtime - starttime << endl << uRelease;
	} // if

	t2->cont();
    } // for
} // t1::main

void T2::main(){
    // Test if timing out works.

    uAccept( cont );

    // Test calls which occur increasingly close to timeout value.

    uTimeout( uDuration(0, 100000000) );
    t1.mem1();
    uAccept( cont );

    uTimeout( uDuration(0, 500000000) );
    t1.mem2();
    uAccept( cont );

    uTimeout( uDuration(0, 900000000) );
    t1.mem1();
    uAccept( cont );

    for ( int i = 0; i < 20; i += 1 ) {
	uTimeout( uDuration(0, 999200000) );
	t1.mem2();
	uAccept( cont );
    } // for
} // T2::main

void uMain::main(){
    uProcessor processor[1];				// more than one processor
    T1 r1;
    T2 s1( r1 );
    T1 r2;
    T2 s2( r2 );
    
    r1.partner( s1 );
    r2.partner( s2 );
} // uMain::main
