//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// key.h -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:39:05 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Oct 14 10:04:19 2002
// Update Count     : 40
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __KEY_H__
#define __KEY_H__

struct keyword_t {
    const char *text;
    int value;
};

extern keyword_t key[];

enum key_value_t {
    ASM = 512,
    ATTRIBUTE,						// gcc specific
    AUTO,
    BOOL,
    BREAK,
    CASE,
    CATCH,
    CHAR,
    CLASS,
    COMPLEX,						// gcc specific
    CONST,
    CONST_CAST,
    CONTINUE,
    DEFAULT,
    DELETE,
    DO,
    DOUBLE,
    DYNAMIC_CAST,
    ELSE,
    ENUM,
    EXPLICIT,
    EXPORT,
    EXTENSION,						// gcc specific
    EXTERN,
    FALSE_C,						// FALSE often appears in a #define in /usr/include
    FLOAT,
    FOR,
    FRIEND,
    GOTO,
    IF,
    INLINE,
    INT,
    LONG,
    MUTABLE,
    NAMESPACE,
    NEW,
    OPERATOR,
    PRIVATE,
    PROTECTED,
    PUBLIC,
    REGISTER,
    REINTERPRET_CAST,
    RETURN,
    SHORT,
    SIGNED,
    SIZEOF,
    STATIC,
    STATIC_CAST,
    STRUCT,
    SWITCH,
    TEMPLATE,
    THIS,
    THROW,
    TRUE_C,						// TRUE often appears in a #define in /usr/include
    TRY,
    TYPEDEF,
    TYPEOF,
    TYPEID,
    TYPENAME,
    UNION,
    UNSIGNED,
    USING,
    VIRTUAL,
    VOID,
    VOLATILE,
    WCHAR_T,
    WHILE,
    
    ACCEPT,
    ACCEPTRETURN,
    ACCEPTWAIT,
    AT,
    COROUTINE,
    DISABLE,
    DUALEVENT,
    ENABLE,
    MUTEX,
    NOMUTEX,
    OR,
    PTASK,
    RAISE,
    RAISEEVENT,
    RTASK,
    RESUME,
    SIGNAL,
    SIGNALBLOCK,
    STASK,
    SUSPEND,
    TASK,
    THROWEVENT,
    TIMEOUT,
    WAIT,
    WITH,
    WHEN,
    UELSE,
    UTHROW,

    ROUTINE,						// pseudo values (i.e., no associated keywords) denotes kinds of definitions
    MEMBER,
};

#endif // __KEY_H__

// Local Variables: //
// compile-command: "gmake install" //
// End: //
