/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <ug_data_app.h>

static void	ug_data_app_finalize	(UgDataApp* appdata);

static UgDataEntry	data_entry_app[] =
{
	{"status",		G_STRUCT_OFFSET (UgDataApp, list_icon),		UG_DATA_TYPE_INT,		NULL,	NULL},
//	{"category",	G_STRUCT_OFFSET (UgDataApp, category_name), UG_DATA_TYPE_STRING,	NULL,	NULL},
	{"MessageType",	G_STRUCT_OFFSET (UgDataApp, message_type),	UG_DATA_TYPE_INT,		NULL,	NULL},
	{"message",		G_STRUCT_OFFSET (UgDataApp, message),		UG_DATA_TYPE_STRING,	NULL,	NULL},
	{NULL},
};

static UgDataClass data_class_app =
{
	"AppData",			// "DataApp"
	NULL,
	sizeof (UgDataApp),
	data_entry_app,

	(UgInitFunc)		NULL,
	(UgFinalizeFunc)	ug_data_app_finalize,
	(UgAssignFunc)		NULL,
};

// extern
const	UgDataClass*	UgDataAppClass = &data_class_app;

static void	ug_data_app_finalize (UgDataApp* appdata)
{
	g_free (appdata->category_name);
	g_free (appdata->message);
}

UgDataset*	ug_dataset_new_app ()
{
	UgDataset*	dataset;

	dataset = ug_data_new (UgDatasetClass);
	UG_DATASET_APP_CLASS (dataset) = UgDataAppClass;

	// preallocate
	ug_dataset_realloc (dataset, UgDataCommonClass, 0);
	ug_dataset_realloc (dataset, UgDataAppClass, 0);
	return dataset;
}

