/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef UG_ITEM_H
#define UG_ITEM_H

#include <gtk/gtk.h>
#include <ug_list_view.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef	struct	UgItem_				UgItem;

struct	UgItem_
{
//	UG_OBJ_LIST_FIELDS (UgDataClass, UgItem);		// UgDataList
//	UgDataClass*	obj_class;
//	UgItem*			next;
//	UgItem*			prev;

	UgListIcon		list_icon;
	gboolean		mark;			// UG_ITEM_VIEW_COLUMN_TOGGLE
	gchar*			name;			// UG_ITEM_VIEW_COLUMN_NAME
	gchar*			value;			// UG_ITEM_VIEW_COLUMN_VALUE
};

#define ug_item_store_new()		gtk_list_store_new (1, G_TYPE_POINTER)

// if iter->stamp == 0, ug_item_store_realloc_next() will try to get first iter.
UgItem*	ug_item_store_realloc_next (GtkListStore* liststore, GtkTreeIter* iter);

void	ug_item_store_clear_after (GtkListStore* liststore, GtkTreeIter* iter);
void	ug_item_store_set_mark_all (GtkListStore* liststore, gboolean marked);
GList*	ug_item_store_get_marked (GtkListStore* liststore);

#ifdef __cplusplus
}
#endif

#endif  // End of UG_ITEM_H

