/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <ug_proxy_form.h>
#include <ug_data_download.h>
#include <ug_utils.h>

#include <glib/gi18n.h>


//	signal handler
static void on_changed (GtkComboBox* widget, UgProxyForm* pform);

void	ug_proxy_form_init (UgProxyForm* pform, gboolean integrated)
{
	GtkTable*	table;
	GtkWidget*	hbox;
	GtkWidget*	widget;

	// initialize
	widget = gtk_table_new (3, 5, FALSE);
	table  = (GtkTable*) widget;
	if (integrated == FALSE)
		pform->self = widget;
	else {
		pform->self = gtk_frame_new (NULL);
		gtk_container_add (GTK_CONTAINER (pform->self), widget);
		gtk_container_set_border_width (GTK_CONTAINER (widget), 3);
	}

	// create and setup widgets  ---------------------------------------
	pform->host_label = gtk_label_new_with_mnemonic (_("Host:"));
	pform->host_entry = gtk_entry_new ();
	pform->port_label = gtk_label_new_with_mnemonic (_("Port:"));
	pform->port_spin  = gtk_spin_button_new_with_range (0.0, 65535.0, 1.0);
	gtk_entry_set_width_chars (GTK_ENTRY (pform->port_spin), 5);
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), pform->port_spin, FALSE, FALSE, 0);
	gtk_label_set_mnemonic_widget (GTK_LABEL(pform->host_label), pform->host_entry);
	gtk_label_set_mnemonic_widget (GTK_LABEL(pform->port_label), pform->port_spin);
	gtk_entry_set_width_chars (GTK_ENTRY (pform->host_entry), 8);
	gtk_table_attach (table, pform->host_label, 0, 1, 1, 2, GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, pform->host_entry, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	gtk_table_attach (table, pform->port_label, 0, 1, 2, 3, GTK_SHRINK, GTK_SHRINK, 1, 1);
	gtk_table_attach (table, hbox,             1, 2, 2, 3, GTK_FILL, GTK_SHRINK, 1, 1);
//	gtk_table_attach (table, pform->port_spin,  1, 2, 2, 3, GTK_FILL, GTK_SHRINK, 1, 1);

	// attach center separator -----------------------------------------
	gtk_table_attach (table, gtk_vseparator_new (), 2, 3, 0, 3,
	                  GTK_FILL, GTK_FILL, 2, 1);

	// username & password ---------------------------------------------
	pform->username_label = gtk_label_new_with_mnemonic (_("Username:"));
	pform->username_entry = gtk_entry_new ();
	pform->password_label = gtk_label_new_with_mnemonic (_("Password:"));
	pform->password_entry = gtk_entry_new ();
	gtk_entry_set_visibility (GTK_ENTRY (pform->password_entry), FALSE);
	gtk_label_set_mnemonic_widget (GTK_LABEL(pform->username_label),
	                               pform->username_entry);
	gtk_label_set_mnemonic_widget (GTK_LABEL(pform->password_label),
	                               pform->password_entry);
	gtk_entry_set_width_chars (GTK_ENTRY (pform->username_entry), 7);
	gtk_entry_set_width_chars (GTK_ENTRY (pform->password_entry), 7);
	gtk_table_attach (table, pform->username_label, 3, 4, 1, 2, GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, pform->username_entry, 4, 5, 1, 2, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	gtk_table_attach (table, pform->password_label, 3, 4, 2, 3, GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, pform->password_entry, 4, 5, 2, 3, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);

	// proxy type ------------------------------------------------------
	pform->type_combo = gtk_combo_box_new_text ();
	gtk_combo_box_append_text (GTK_COMBO_BOX (pform->type_combo), _("Default"));	// 0
	gtk_combo_box_append_text (GTK_COMBO_BOX (pform->type_combo),   "HTTP");		// 1
	gtk_combo_box_append_text (GTK_COMBO_BOX (pform->type_combo),   "SOCKS v4");	// 2
	gtk_combo_box_append_text (GTK_COMBO_BOX (pform->type_combo),   "SOCKS v5");	// 3

	if (integrated) {
		g_signal_connect (pform->type_combo, "changed", G_CALLBACK (on_changed), pform);
		gtk_combo_box_append_text (GTK_COMBO_BOX (pform->type_combo), _("Don't use"));	// 4
		gtk_combo_box_set_active (GTK_COMBO_BOX (pform->type_combo), 4);
		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), gtk_label_new (_("Proxy:")), FALSE, FALSE, 1);
		gtk_box_pack_start (GTK_BOX (hbox), pform->type_combo, FALSE, FALSE, 2);
		gtk_frame_set_label_widget ((GtkFrame*) pform->self, hbox);
	}
	else {
		gtk_combo_box_set_active (GTK_COMBO_BOX (pform->type_combo), 0);
		pform->type_label = gtk_label_new_with_mnemonic (_("Type:"));
		gtk_label_set_mnemonic_widget (GTK_LABEL(pform->type_label), pform->type_combo);
		gtk_table_attach (table, pform->type_label, 0, 1, 0, 1, GTK_SHRINK, GTK_SHRINK, 3, 1);
		gtk_table_attach (table, pform->type_combo, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 3, 1);
	}

	gtk_widget_show_all (pform->self);
}

void	ug_proxy_form_get  (UgProxyForm* pform, UgDataset* dataset)
{
	UgDataProxy*	proxy;
	gint			index;

	index = gtk_combo_box_get_active ((GtkComboBox*) pform->type_combo);

	proxy = ug_dataset_realloc (dataset, UgDataProxyClass, 0);
	switch (index) {
	case 0:
		proxy->type = UG_DATA_PROXY_DEFAULT;
		break;
	case 1:
		proxy->type = UG_DATA_PROXY_HTTP;
		break;
	case 2:
		proxy->type = UG_DATA_PROXY_SOCKS4;
		break;
	case 3:
		proxy->type = UG_DATA_PROXY_SOCKS5;
		break;
	case 4:		// Don't use
		proxy->type = UG_DATA_PROXY_NONE;
		break;
	}
	ug_str_set (&proxy->user,     gtk_entry_get_text ((GtkEntry*)pform->username_entry),  -1);
	ug_str_set (&proxy->password, gtk_entry_get_text ((GtkEntry*)pform->password_entry),  -1);
	ug_str_set (&proxy->host,     gtk_entry_get_text ((GtkEntry*)pform->host_entry),  -1);
	proxy->port = gtk_spin_button_get_value_as_int ((GtkSpinButton*) pform->port_spin);
}

void	ug_proxy_form_set  (UgProxyForm* pform, UgDataset* dataset)
{
	UgDataProxy*	proxy;
	gint			index = 0;

	proxy = ug_dataset_get (dataset, UgDataProxyClass, 0);
	if (proxy == NULL) {
		gtk_combo_box_set_active ((GtkComboBox*) pform->type_combo, 4);
		gtk_entry_set_text ((GtkEntry*)pform->username_entry,  "");
		gtk_entry_set_text ((GtkEntry*)pform->password_entry,  "");
		gtk_entry_set_text ((GtkEntry*)pform->host_entry,  "");
		gtk_spin_button_set_value ((GtkSpinButton*) pform->port_spin, 0);
		return;
	}

	switch (proxy->type) {
	case UG_DATA_PROXY_DEFAULT:
		index = 0;
		break;
	case UG_DATA_PROXY_HTTP:
		index = 1;
		break;
	case UG_DATA_PROXY_SOCKS4:
		index = 2;
		break;
	case UG_DATA_PROXY_SOCKS5:
		index = 3;
		break;
	case UG_DATA_PROXY_NONE:
		index = 4;
		break;
	}
	gtk_combo_box_set_active ((GtkComboBox*) pform->type_combo, index);
	gtk_entry_set_text ((GtkEntry*)pform->username_entry, (proxy->user)     ? proxy->user     : "");
	gtk_entry_set_text ((GtkEntry*)pform->password_entry, (proxy->password) ? proxy->password : "");
	gtk_entry_set_text ((GtkEntry*)pform->host_entry,     (proxy->host)     ? proxy->host     : "");
	gtk_spin_button_set_value ((GtkSpinButton*) pform->port_spin, proxy->port);
}

// signal
static void on_changed (GtkComboBox* widget, UgProxyForm* pform)
{
	gint		index;
	gboolean	sensitive;

	index = gtk_combo_box_get_active (widget);
	if (index == 4)
		sensitive = FALSE;
	else
		sensitive = TRUE;

	gtk_widget_set_sensitive (pform->host_label, sensitive);
	gtk_widget_set_sensitive (pform->host_entry, sensitive);
	gtk_widget_set_sensitive (pform->port_label, sensitive);
	gtk_widget_set_sensitive (pform->port_spin,  sensitive);
	gtk_widget_set_sensitive (pform->username_label, sensitive);
	gtk_widget_set_sensitive (pform->username_entry, sensitive);
	gtk_widget_set_sensitive (pform->password_label, sensitive);
	gtk_widget_set_sensitive (pform->password_entry, sensitive);
}

