/* Simple converter between RGB / HLS.

   Copyright (C) 2000 Daiki Ueno <ueno@unixuser.org>

   Author: Daiki Ueno <ueno@unixuser.org>
   Created: 2000-05-16

   This file is part of UltraPoint.

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)  
   any later version.                                                   

   This program is distributed in the hope that it will be useful,      
   but WITHOUT ANY WARRANTY; without even the implied warranty of       
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the        
   GNU General Public License for more details.                         

   You should have received a copy of the GNU General Public License    
   along with GNU Emacs; see the file COPYING.  If not, write to the    
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,         
   Boston, MA 02111-1307, USA.                                          

*/

#ifndef __UPT_COLOR_H_
#define __UPT_COLOR_H_

#include "upt.h"

typedef struct _UptColor UptColor;
typedef struct _UptRGBColorSpace UptRGBColorSpace;
typedef struct _UptHLSColorSpace UptHLSColorSpace;

enum {
  COLORSPACE_RGB = 0,
  COLORSPACE_HLS = 1
};

struct _UptRGBColorSpace {
  gdouble red;
  gdouble green;
  gdouble blue;
};

struct _UptHLSColorSpace {
  gdouble hue;
  gdouble lightness;
  gdouble saturation;
};

struct _UptColor {
  gint space;
  union {
    UptRGBColorSpace rgb;
    UptHLSColorSpace hls;
  } data;

  gint ref_count;
  GFreeFunc free;
};

extern UptColor *upt_color_by_name (const gchar *name);
extern UptColor *upt_color_by_rgb (gdouble red, gdouble green, gdouble blue);
extern UptColor *upt_color_by_hls (gdouble hue, gdouble lightness,
				   gdouble saturation);

extern void upt_color_to_hls (UptColor *color);
extern void upt_color_to_rgb (UptColor *color);
extern ggi_pixel upt_color_map (ggi_visual_t visual, UptColor *color);
UptColor *upt_color_unmap (ggi_visual_t visual, ggi_pixel pixel);

#endif
