/* Font manager.

   Copyright (C) 2000 Daiki Ueno <ueno@unixuser.org>

   Author: Daiki Ueno <ueno@unixuser.org>
   Created: 2000-05-16

   This file is part of UltraPoint.

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)  
   any later version.                                                   

   This program is distributed in the hope that it will be useful,      
   but WITHOUT ANY WARRANTY; without even the implied warranty of       
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the        
   GNU General Public License for more details.                         

   You should have received a copy of the GNU General Public License    
   along with GNU Emacs; see the file COPYING.  If not, write to the    
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,         
   Boston, MA 02111-1307, USA.                                          

*/

#ifndef __UPT_FONTS_H_
#define __UPT_FONTS_H_

#include "upt.h"
#include <VFlib-3_6.h>
#include <unicode.h>

typedef struct _UptFont UptFont;
typedef struct _UptCharset UptCharset;

enum {
  CHARSET_ISO_8859_1 = 1 << 0,
  CHARSET_ISO_8859_2 = 1 << 1,
  CHARSET_ISO_8859_3 = 1 << 2,
  CHARSET_ISO_8859_4 = 1 << 3,
  CHARSET_ISO_8859_5 = 1 << 4,
  CHARSET_ISO_8859_6 = 1 << 5,
  CHARSET_ISO_8859_7 = 1 << 6,
  CHARSET_ISO_8859_8 = 1 << 7,
  CHARSET_ISO_8859_9 = 1 << 8,
  CHARSET_JIS_0208 = 1 << 9,
  CHARSET_GB_2312 = 1 << 10,
  CHARSET_KSC_5601 = 1 << 11,
  CHARSET_ISO_10646 = 1 << 12
};

enum {
  FAMILY_DEFAULT =  1,
  FAMILY_FIXED = 0,
  FAMILY_TIMES = 1,
  FAMILY_HELV = 2,
  FAMILY_COUR = 3
};

enum {
  FACE_DEFAULT = 0,
  FACE_NORMAL = 0,
  FACE_BOLD = 1,
  FACE_ITALIC = 2,
  FACE_BOLDITALIC = 3
};

typedef long (*UptConvFunc) (UptCharset *charset,
			     const unicode_char_t codepoint);

struct _UptCharset {
  const gchar *iconv_encoding;
  const gchar *vflib_name;
  UptConvFunc converter;
  gboolean is_agglutinative;

  /* internal use only --- for opened iconv descripter */
  unicode_iconv_t iconv_cd;

  gint ref_count;
  GFreeFunc free;
};
  
struct _UptFont {
  gint pixel_size;
  gint charset_id;
  gint family_id;
  gint face_id;
  gchar *name;

  /* internal use only --- for caching charset */
  UptCharset *charset;
  /* internal use only --- for opened VFlib font id */
  gint id;

  gint ref_count;
  GFreeFunc free;
};

UptFont *upt_find_font (unicode_char_t ucs, gint font_pixel_size,
			gint font_family, gint font_face);
UptFont *upt_font_new (gint pixel_size, gint family_id, gint face_id);

#endif
