# Copyright (C) 2007  Lars Wirzenius <liw@iki.fi>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


"""Unit tests for Unperish info plugin."""


import os
import unittest

import unperishlib


class ProjectInfoTests(unittest.TestCase):

    def setUp(self):
        pm = unperishlib.PluginManager()
        pm.set_plugin_directories(["plugins"])
        pm.load_plugins()
        self.pi = pm.get_operation("project-info")
        
    def testDefinesProjectNameOption(self):
        cli = unperishlib.CommandLineParser()
        self.pi.add_options(cli)
        self.failUnless(cli.has_option("--project-name"))

    def testDefinesProjectVersionOption(self):
        cli = unperishlib.CommandLineParser()
        self.pi.add_options(cli)
        self.failUnless(cli.has_option("--project-version"))


class ProjectInfoFromSetupPyTests(unittest.TestCase):

    def setUp(self):
        app = unperishlib.Application(plugins=["plugins"])
        self.options, _ = app.parse_args(["--distutils=testsetup.py"])
        self.oper = app.get_plugin_manager().get_operation(
                                            "project-info-from-setup.py")
        f = file("testsetup.py", "w")
        f.write("print 'pink'\n")
        f.write("print '1.2.3'\n")
        f.close()

    def tearDown(self):
        if os.path.exists("testsetup.py"):
            os.remove("testsetup.py")

    def testSetsUpOptionParsingCorrectly(self):
        self.failUnlessEqual(self.options.distutils, "testsetup.py")

    def testDoesNothingWithoutSetupPy(self):
        os.remove("testsetup.py")
        self.oper.do_it(self.options)
        self.failUnlessEqual(self.options.project_name, None)
        self.failUnlessEqual(self.options.project_version, None)

    def testSetsProjectInfoWhenSetupPyGivesThem(self):
        self.oper.do_it(self.options)
        self.failUnlessEqual(self.options.project_name, "pink")
        self.failUnlessEqual(self.options.project_version, "1.2.3")
