
#
# GLX Server Extension
# Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
# Copyright (C) 1998, 1999  Terence Ripperda (ripperda@sgi.com)
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# STEVEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
# ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

proc splitit {data} {
    global number args decode name encodeproto encode_nogen decode_nogen
    foreach t $data {
	set tname [lindex $t 0]
	set tnumber [lindex $t 1]
	set targs [lindex $t 2]
	set args($tname) $targs
	set number($tname) $tnumber
	if {![info exists name($tnumber)]} {
	    set name($tnumber) $tname
	}
	for {set i 3} {$i < [llength $t]} {incr i 2} {
	    set what [lindex $t $i]
	    if {$what == "decode"} {
		set decode($tname) [lindex $t [expr $i+1]]
	    } elseif {$what == "encodeproto"} {
		set encodeproto($tname) [lindex $t [expr $i+1]]
	    } elseif {$what == "encode_nogen"} {
		set encode_nogen($tname) [lindex $t [expr $i+1]]
	    } elseif {$what == "decode_nogen"} {
	    } elseif {$what == "swap_decode"} {
	    } else {
		puts "unknown optional..."
		exit 1
	    }
	}
    }
}

proc GLsizeof {type} {
    if {$type == "float"} {
	return 4
    } elseif {$type == "enum"} {
	return 4
    } elseif {$type == "bitfield"} {
	return 4
    } elseif {$type == "double"} {
	return 8
    } elseif {$type == "uint"} {
	return 4
    } elseif {$type == "int"} {
	return 4
    } elseif {$type == "boolean"} {
	return 1
    } elseif {$type == "short"} {
	return 2
    } elseif {$type == "ushort"} {
	return 2
    } elseif {$type == "byte"} {
	return 1
    } elseif {$type == "ubyte"} {
	return 1
    } else {
	puts "NEED TYPE: $type"
	exit 1
    }
}

proc gen_header {} {
    set f [open render.h "w"]
    puts $f "/* Automatically generated by genlib.tcl */"
    puts $f "#include \"glxlib.h\""
    puts $f "#include \"glxcommon.h\""

    global number args encodeproto encode_nogen
    set names [lsort [array names number]]
    foreach nm $names {
	if {[info exists encode_nogen($nm)]} {
	    continue
	}
	if {[info exists encodeproto($nm)]} {
	    puts -nonewline $f $encodeproto($nm)
            puts $f ";"
	} else {
	    puts -nonewline $f "void __glx_$nm\("
	    set first 1
	    foreach t $args($nm) {
		if {[string first unused $t] == -1} {
		    if {!$first} {
			puts -nonewline $f ", "
		    } else {
			set first 0
		    }
		    set type [lindex $t 0]
		    set aname [lindex $t 1]
		    if {[llength $t] == 2} {
			set star ""
			set const ""
		    } else {
			set star "*"
			set const "const "
		    }
		    puts -nonewline $f "$const GL$type$star $aname"
		}
	    }
	    puts $f "\);"
	}
    }
    close $f
}

proc gen_lib {} {
    set f [open render.c "w"]
    puts $f "/* Automatically generated by genlib.tcl */"
    puts $f "#include \"glxlib.h\""
    puts $f "#include \"buffer_macros.h\""
    puts $f "#include \"glxcommon.h\""

    global number args encodeproto encode_nogen
    set names [lsort [array names number]]
    foreach nm $names {
	if {[info exists encode_nogen($nm)]} {
	    continue
	}
	if {[info exists encodeproto($nm)]} {
	    puts $f $encodeproto($nm)
	} else {
	    puts -nonewline $f "void __glx_$nm\("
	    set first 1
	    foreach t $args($nm) {
		if {[string first unused $t] == -1} {
		    if {!$first} {
			puts -nonewline $f ", "
		    } else {
			set first 0
		    }
		    set type [lindex $t 0]
		    set aname [lindex $t 1]
		    if {[llength $t] == 2} {
			set star ""
			set const ""
		    } else {
			set star "*"
			set const "const "
		    }
		    puts -nonewline $f "$const GL$type$star $aname"
		}
	    }
	    puts $f "\)"
	}

	puts $f "{"
	set have_c 0
	# offset = 4 for opcode/length
	set offset 4
	set offset_other ""
	foreach t $args($nm) {
	    set type [lindex $t 0]
	    set aname [lindex $t 1]
	    
	    if {[llength $t] == 2} {
		incr offset [GLsizeof $type]
	    } else {
		set nt [lindex $t 2]
		if {[string match "\[0-9\]\[0-9\]" $nt] || [string match "\[0-9\]" $nt]} {
		    incr offset [expr $nt*[GLsizeof $type]]
		} else {
		    append offset_other "+([GLsizeof $type]*$nt)"
		}
		if {[string first unused $t] == -1} {
		    puts $f "\tint n_$aname = $nt;"
		    if {!$have_c} {
			puts $f "\tint _cnt;"
			set have_c 1
		    }
		}
	    }
	}
	puts $f "\tint _size=$offset$offset_other;"
	puts $f "\tchar* buffer=NULL;"
        puts $f "\t__GLX_GET_RENDER_BUFFER(buffer, $number($nm), _size, 0);"
	set offset 4
	set offset_other ""
	foreach t $args($nm) {
	    if {[string first unused $t] == -1} {
		set type [lindex $t 0]
		set aname [lindex $t 1]
		if {[llength $t] == 2} {
		    puts $f "\t__GLX_PUT_$type\(buffer, $aname\);"
		    incr offset [GLsizeof $type]
		} else {
		    puts $f "\tfor(_cnt=0;_cnt<n_$aname;_cnt++){"
		    puts $f "\t\t__GLX_PUT_$type\(buffer, $aname\[_cnt\]\);"
		    puts $f "\t}"
		    set nt [lindex $t 2]
		    if {[string match "\[0-9\]\[0-9\]" $nt] || [string match "\[0-9\]" $nt]} {
			incr offset [expr $nt*[GLsizeof $type]]
		    }
		}
	    }
	}
	#puts $f "\tprintf(\"$nm\\n\");"
	puts $f "}"
	puts $f ""
    }
    close $f
}

source genGL.tcl

splitit $GLcalls
gen_header
gen_lib
