
/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 * Copyright (C) 1998, 1999  Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEPHEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef GLXLIB_H
#define GLXLIB_H 1

#include "Xlibint.h"

#include "GL/gl.h"
#include "GL/glx.h"
#include "GL/GLXproto.h"
#include "config.h"
#include "glxcommon.h"
#include "macros.h"

/* XXX can I do some macro magic here on strings to include? */
#define GLX_EXTENSION_STRING "GLX_g200_direct GLX_no_hw_accel"

#define MALLOC_STRUCT(T)  (struct T *) malloc( sizeof(struct T) )

#define GL_CLIENT_PACK_BIT (1<<20)
#define GL_CLIENT_UNPACK_BIT (1<<21)

/*
 * Bits to indicate what state has to be updated (NewState)
 */
#define NEW_LIGHTING    0x01
#define NEW_RASTER_OPS  0x02
#define NEW_TEXTURING   0x04
#define NEW_POLYGON     0x08
#define NEW_DRVSTATE0   0x10 /* Reserved for drivers */
#define NEW_DRVSTATE1   0x20 /* Reserved for drivers */
#define NEW_DRVSTATE2   0x40 /* Reserved for drivers */
#define NEW_DRVSTATE3   0x80 /* Reserved for drivers */
#define NEW_ALL         0xff


/* default GL_UNPACK settings */
/* used to determine if unpacking is needed or not */
#define DEFAULT_UNPACK_SWAP_BYTES  GL_FALSE
#define DEFAULT_UNPACK_LSB_FIRST   GL_FALSE
#define DEFAULT_UNPACK_ROW_LENGTH  0
#define DEFAULT_UNPACK_SKIP_PIXELS 0
#define DEFAULT_UNPACK_SKIP_ROWS   0
#define DEFAULT_UNPACK_ALIGNMENT   4


char *GET_render_large_buffer(
   const  int   parmSize,           /* size of fixed small parms (unpadded) */
   const  int   dataSize,           /* size of variable large parm (unpadded) */
   const  int   opCode,             /* request command opcode */
   const  int   incr               /* min allocation incr for large data */
);

void GET_packed_buffer( char *dest, const unsigned char *source,
                 const int width, const int height, GLenum type, GLenum format);

void PUT_unpacked_bitmap(
         char*  dest,
   const unsigned char*  source,
   const int    width,
   const int    height
);

void PUT_unpacked_buffer(
         char*  dest,
   const unsigned char*  source,
   const int    width,
   const int    height,
         GLenum type,
         GLenum format
);

void PUT_buffer(
         char*  dest,
   const unsigned char*  source,
   const int    num_bytes
);

void PUT_large_map2f(
         char*     dst,
   const GLfloat*  src,
   const GLint     uorder,
   const GLint     vorder,
   const GLint     ustride,
   const GLint     vstride,
   const GLint     nvalues
);

void PUT_large_map2d(
         char*     dst,
   const GLdouble* src,
   const GLint     uorder,
   const GLint     vorder,
   const GLint     ustride,
   const GLint     vstride,
   const GLint     nvalues
);

/*
 * All gl* API functions in api*.c jump through pointers in this struct.
 */
struct gl_api_table {
   void (*Accum)( GLenum, GLfloat );
   void (*AlphaFunc)( GLenum, GLclampf );
   GLboolean (*AreTexturesResident)( GLsizei, const GLuint *, GLboolean * );
   void (*ArrayElement)( GLint );
   void (*Begin)( GLenum );
   void (*BindTexture)( GLenum, GLuint );
   void (*Bitmap)( GLsizei, GLsizei, GLfloat, GLfloat,
		     GLfloat, GLfloat, const GLubyte *bitmap );
   void (*BlendColor)( GLclampf, GLclampf, GLclampf, GLclampf);
   void (*BlendEquation)( GLenum );
   void (*BlendFunc)( GLenum, GLenum );
   void (*CallList)( GLuint list );
   void (*CallLists)( GLsizei, GLenum, const GLvoid * );
   void (*Clear)( GLbitfield );
   void (*ClearAccum)(  GLfloat, GLfloat, GLfloat, GLfloat );
   void (*ClearColor)(  GLclampf, GLclampf, GLclampf, GLclampf );
   void (*ClearDepth)( GLclampd );
   void (*ClearIndex)(  GLfloat );
   void (*ClearStencil)(  GLint );
   void (*ClipPlane)(  GLenum, const GLdouble * );
   void (*Color3f)(  GLfloat, GLfloat, GLfloat );
   void (*Color3fv)(  const GLfloat * );
   void (*Color4f)(  GLfloat, GLfloat, GLfloat, GLfloat );
   void (*Color4fv)(  const GLfloat * );
   void (*Color4ub)(  GLubyte, GLubyte, GLubyte, GLubyte );
   void (*Color4ubv)(  const GLubyte * );
   void (*ColorMask)( GLboolean, GLboolean, GLboolean, GLboolean );
   void (*ColorMaterial)(  GLenum, GLenum );
   void (*ColorPointer)(  GLint, GLenum, GLsizei, const GLvoid * );
   void (*ColorTable)(  GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid * );
   void (*ColorSubTable)(  GLenum, GLsizei, const GLubyte * );
   void (*CopyPixels)(  GLint, GLint, GLsizei, GLsizei, GLenum );
   void (*CopyTexImage1D)(  GLenum, GLint, GLenum,
                           GLint, GLint, GLsizei, GLint );
   void (*CopyTexImage2D)(  GLenum, GLint, GLenum,
                           GLint, GLint, GLsizei, GLsizei, GLint );
   void (*CopyTexSubImage1D)(  GLenum, GLint, GLint,
                              GLint, GLint, GLsizei );
   void (*CopyTexSubImage2D)(  GLenum, GLint, GLint, GLint,
                              GLint, GLint, GLsizei, GLsizei );
   void (*CopyTexSubImage3DEXT)(  GLenum, GLint, GLint, GLint, GLint,
				  GLint, GLint, GLsizei, GLsizei  );
   void (*CullFace)(  GLenum );
   void (*DeleteLists)(  GLuint, GLsizei );
   void (*DeleteTextures)(  GLsizei, const GLuint *);
   void (*DepthFunc)(  GLenum );
   void (*DepthMask)(  GLboolean );
   void (*DepthRange)(  GLclampd, GLclampd );
   void (*Disable)(  GLenum );
   void (*DisableClientState)(  GLenum );
   void (*DrawArrays)(  GLenum, GLint, GLsizei );
   void (*DrawBuffer)(  GLenum );
   void (*DrawElements)(  GLenum, GLsizei, GLenum, const GLvoid *);
   void (*DrawPixels)( GLsizei width, GLsizei height, GLenum format,
                       GLenum type, const GLvoid *image );
   void (*DrawRangeElements)(  GLenum, GLuint, GLuint, GLsizei,
                              GLenum, const GLvoid * );
   void (*EdgeFlag)(  GLboolean );
   void (*EdgeFlagPointer)(  GLsizei, const GLboolean * );
   void (*Enable)(  GLenum );
   void (*EnableClientState)(  GLenum );
   void (*End)(  );
   void (*EndList)(  );
   void (*EvalCoord1f)(  GLfloat );
   void (*EvalCoord2f)(  GLfloat , GLfloat );
   void (*EvalMesh1)(  GLenum, GLint, GLint );
   void (*EvalMesh2)(  GLenum, GLint, GLint, GLint, GLint );
   void (*EvalPoint1)(  GLint );
   void (*EvalPoint2)(  GLint, GLint );
   void (*FeedbackBuffer)(  GLsizei, GLenum, GLfloat * );
   void (*Finish)(  );
   void (*Flush)(  );
   void (*Fogfv)(  GLenum, const GLfloat * );
   void (*FrontFace)(  GLenum );
   void (*Frustum)(  GLdouble, GLdouble, GLdouble, GLdouble,
                    GLdouble, GLdouble );
   GLuint (*GenLists)(  GLsizei );
   void (*GenTextures)(  GLsizei, GLuint * );
   void (*GetBooleanv)(  GLenum, GLboolean * );
   void (*GetClipPlane)(  GLenum, GLdouble * );
   void (*GetColorTable)(  GLenum, GLenum, GLenum, GLvoid *);
   void (*GetColorTableParameteriv)(  GLenum, GLenum, GLint *);
   void (*GetDoublev)(  GLenum, GLdouble * );
   GLenum (*GetError)(  );
   void (*GetFloatv)(  GLenum, GLfloat * );
   void (*GetIntegerv)(  GLenum, GLint * );
   const GLubyte* (*GetString)(  GLenum name );
   void (*GetLightfv)(  GLenum light, GLenum, GLfloat * );
   void (*GetLightiv)(  GLenum light, GLenum, GLint * );
   void (*GetMapdv)(  GLenum, GLenum, GLdouble * );
   void (*GetMapfv)(  GLenum, GLenum, GLfloat * );
   void (*GetMapiv)(  GLenum, GLenum, GLint * );
   void (*GetMaterialfv)(  GLenum, GLenum, GLfloat * );
   void (*GetMaterialiv)(  GLenum, GLenum, GLint * );
   void (*GetPixelMapfv)(  GLenum, GLfloat * );
   void (*GetPixelMapuiv)(  GLenum, GLuint * );
   void (*GetPixelMapusv)(  GLenum, GLushort * );
   void (*GetPointerv)(  GLenum, GLvoid ** );
   void (*GetPolygonStipple)(  GLubyte * );
   void (*PrioritizeTextures)(  GLsizei, const GLuint *,
                               const GLclampf * );
   void (*GetTexEnvfv)(  GLenum, GLenum, GLfloat * );
   void (*GetTexEnviv)(  GLenum, GLenum, GLint * );
   void (*GetTexGendv)(  GLenum coord, GLenum, GLdouble * );
   void (*GetTexGenfv)(  GLenum coord, GLenum, GLfloat * );
   void (*GetTexGeniv)(  GLenum coord, GLenum, GLint * );
   void (*GetTexImage)(  GLenum, GLint level, GLenum, GLenum,
                        GLvoid * );
   void (*GetTexLevelParameterfv)( GLenum, GLint, GLenum, GLfloat * );
   void (*GetTexLevelParameteriv)( GLenum, GLint, GLenum, GLint * );
   void (*GetTexParameterfv)(  GLenum, GLenum, GLfloat *);
   void (*GetTexParameteriv)(  GLenum, GLenum, GLint * );
   void (*Hint)(  GLenum, GLenum );
   void (*IndexMask)(  GLuint );
   void (*Indexf)(  GLfloat c );
   void (*Indexi)(  GLint c );
   void (*IndexPointer)(  GLenum, GLsizei, const GLvoid * );
   void (*InitNames)(  );
   void (*InterleavedArrays)(  GLenum, GLsizei, const GLvoid * );
   GLboolean (*IsEnabled)(  GLenum );
   GLboolean (*IsList)(  GLuint );
   GLboolean (*IsTexture)(  GLuint );
   void (*LightModelfv)(  GLenum, const GLfloat * );
   void (*Lightfv)(  GLenum light, GLenum, const GLfloat *);
   void (*LineStipple)(  GLint factor, GLushort );
   void (*LineWidth)(  GLfloat );
   void (*ListBase)(  GLuint );
   void (*LoadIdentity)(  );
   /* LoadMatrixd implemented with glLoadMatrixf */
   void (*LoadMatrixf)(  const GLfloat * );
   void (*LoadName)(  GLuint );
   void (*LogicOp)(  GLenum );
   void (*Map1d)(  GLenum, GLdouble , GLdouble , GLint, GLint,
		  const GLdouble *);
   void (*Map1f)(  GLenum, GLfloat, GLfloat, GLint, GLint,
		  const GLfloat *);
   void (*Map2d)(  GLenum, GLdouble , GLdouble , GLint, GLint,
		  GLdouble, GLdouble, GLint, GLint, const GLdouble *);
   void (*Map2f)(  GLenum, GLfloat, GLfloat, GLint, GLint,
		  GLfloat, GLfloat, GLint, GLint, const GLfloat *);
   void (*MapGrid1f)(  GLint, GLfloat, GLfloat );
   void (*MapGrid1d)(  GLint, GLfloat, GLfloat );
   void (*MapGrid2f)(  GLint, GLfloat, GLfloat,
			GLint, GLfloat, GLfloat );
   void (*MapGrid2d)(  GLint, GLfloat, GLfloat,
			GLint, GLfloat, GLfloat );
   void (*Materialfv)(  GLenum, GLenum, const GLfloat * );
   void (*MatrixMode)(  GLenum );
   /* MultMatrixd implemented with glMultMatrixf */
   void (*MultMatrixf)(  const GLfloat * );
   void (*NewList)(  GLuint list, GLenum );
   void (*Normal3f)(  GLfloat, GLfloat, GLfloat );
   void (*Normal3fv)(  const GLfloat * );
   void (*NormalPointer)(  GLenum, GLsizei, const GLvoid * );
   void (*Ortho)(  GLdouble, GLdouble, GLdouble, GLdouble,
                  GLdouble, GLdouble );
   void (*PassThrough)(  GLfloat );
   void (*PixelMapfv)(  GLenum, GLint, const GLfloat * );
   void (*PixelStorei)(  GLenum, GLint );
   void (*PixelTransferf)(  GLenum, GLfloat );
   void (*PixelZoom)(  GLfloat, GLfloat );
   void (*PointParameterfvEXT)(  GLenum, const GLfloat * );
   void (*PointSize)(  GLfloat );
   void (*PolygonMode)(  GLenum, GLenum );
   void (*PolygonOffset)(  GLfloat, GLfloat );
   void (*PolygonStipple)(  const GLubyte * );
   void (*PopAttrib)(  );
   void (*PopClientAttrib)(  );
   void (*PopMatrix)(  );
   void (*PopName)(  );
   void (*PushAttrib)(  GLbitfield );
   void (*PushClientAttrib)(  GLbitfield );
   void (*PushMatrix)(  );
   void (*PushName)(  GLuint );
   void (*RasterPos4f)( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
   void (*ReadBuffer)(  GLenum );
   void (*ReadPixels)(  GLint, GLint, GLsizei, GLsizei, GLenum,
			 GLenum, GLvoid * );
   void (*Rectf)(  GLfloat, GLfloat, GLfloat, GLfloat );
   GLint (*RenderMode)(  GLenum );
   void (*Rotatef)(  GLfloat, GLfloat, GLfloat, GLfloat );
   void (*Scalef)(  GLfloat, GLfloat, GLfloat );
   void (*Scissor)(  GLint, GLint, GLsizei, GLsizei);
   void (*SelectBuffer)(  GLsizei, GLuint * );
   void (*ShadeModel)(  GLenum );
   void (*StencilFunc)(  GLenum, GLint, GLuint );
   void (*StencilMask)(  GLuint );
   void (*StencilOp)(  GLenum, GLenum, GLenum );
   void (*TexCoord2f)(  GLfloat, GLfloat );
   void (*TexCoord4f)(  GLfloat, GLfloat, GLfloat, GLfloat );
   void (*TexCoordPointer)(  GLint, GLenum, GLsizei,
                            const GLvoid *);
   void (*TexEnvfv)(  GLenum, GLenum, const GLfloat * );
   void (*TexGenfv)(  GLenum coord, GLenum, const GLfloat * );
   void (*TexImage1D)(  GLenum, GLint, GLint, GLsizei,
                       GLint, GLenum, GLenum, const GLvoid * );
   void (*TexImage2D)(  GLenum, GLint, GLint, GLsizei, GLsizei,
                       GLint, GLenum, GLenum, const GLvoid * );
   void (*TexSubImage1D)(  GLenum, GLint, GLint, GLsizei, GLenum,
                           GLenum, const GLvoid *);
   void (*TexSubImage2D)(  GLenum, GLint, GLint, GLint,
                           GLsizei, GLsizei, GLenum, GLenum, const GLvoid *);
   void (*TexImage3DEXT)(  GLenum , GLint , GLint ,
			   GLsizei , GLsizei , GLsizei ,
			   GLint , GLenum , GLenum ,
			   const GLubyte * );
   void (*TexSubImage3DEXT)(  GLenum , GLint , GLint , GLint , GLint,
			      GLsizei , GLsizei , GLsizei ,
			      GLenum , GLenum , const GLubyte * );
   void (*TexParameterfv)(  GLenum, GLenum, const GLfloat * );
   /* Translated implemented by Translatef */
   void (*Translatef)(  GLfloat, GLfloat, GLfloat );

   void (*Vertex2d)(  GLdouble , GLdouble );
   void (*Vertex2dv)( const GLdouble *);
   void (*Vertex2f)(  GLfloat, GLfloat );
   void (*Vertex2fv)( const GLfloat *);
   void (*Vertex2i)(  GLint , GLint );
   void (*Vertex2iv)( const GLint *);
   void (*Vertex2s)(  GLshort , GLshort );
   void (*Vertex2sv)( const GLshort *);

   void (*Vertex3d)(  GLdouble , GLdouble, GLdouble );
   void (*Vertex3dv)( const GLdouble *);
   void (*Vertex3f)(  GLfloat, GLfloat, GLfloat );
   void (*Vertex3fv)( const GLfloat *);
   void (*Vertex3i)(  GLint , GLint, GLint );
   void (*Vertex3iv)( const GLint *);
   void (*Vertex3s)(  GLshort , GLshort, GLshort );
   void (*Vertex3sv)( const GLshort *);

   void (*Vertex4d)(  GLdouble , GLdouble, GLdouble, GLdouble );
   void (*Vertex4dv)( const GLdouble *);
   void (*Vertex4f)(  GLfloat, GLfloat, GLfloat, GLfloat );
   void (*Vertex4fv)( const GLfloat *);
   void (*Vertex4i)(  GLint , GLint, GLint, GLint );
   void (*Vertex4iv)( const GLint *);
   void (*Vertex4s)(  GLshort , GLshort, GLshort, GLshort );
   void (*Vertex4sv)( const GLshort *);

   void (*VertexPointer)(  GLint, GLenum, GLsizei, const GLvoid *);
   void (*Viewport)(  GLint, GLint, GLsizei, GLsizei );

   /* GL_MESA_window_pos extension */
   void (*WindowPos4fMESA)(  GLfloat, GLfloat, GLfloat, GLfloat );

   /* GL_MESA_resize_buffers extension */
   void (*ResizeBuffersMESA)(  );

   /* GL_ARB_multitexture */
   void (*MultiTexCoord1f)( GLenum, GLfloat );
   void (*MultiTexCoord2f)( GLenum, GLfloat, GLfloat );
   void (*MultiTexCoord3f)( GLenum, GLfloat, GLfloat, GLfloat );
   void (*MultiTexCoord4f)( GLenum, GLfloat, GLfloat, GLfloat, GLfloat );
   void (*ActiveTexture)( GLenum );
   void (*ClientActiveTexture)( GLenum );

   /* GL_EXT_compiled_vertex_array */
   void (*LockArrays)( int, GLsizei );
   void (*UnlockArrays)( void );
};

/* For the attribute stack: */
struct gl_attrib_node {
        GLbitfield kind;
        void *data;
        struct gl_attrib_node *next;
};

/*
 * Client pixel packing/unpacking attributes
 */
struct gl_pixelstore_attrib {
	GLint Alignment;
	GLint RowLength;
	GLint SkipPixels;
	GLint SkipRows;
	GLint ImageHeight;     /* for GL_EXT_texture3D */
	GLint SkipImages;      /* for GL_EXT_texture3D */
	GLboolean SwapBytes;
	GLboolean LsbFirst;
};

/*
 * Client vertex array attributes
 */
struct gl_array_attrib {
	GLint VertexSize;
	GLenum VertexType;
	GLsizei VertexStride;		/* user-specified stride */
	GLsizei VertexStrideB;		/* actual stride in bytes */
	void *VertexPtr;
        void (*VertexFuncPtr)(void *vertex);
	GLboolean VertexEnabled;

	GLenum NormalType;
	GLsizei NormalStride;		/* user-specified stride */
	GLsizei NormalStrideB;		/* actual stride in bytes */
	void *NormalPtr;
        void (*NormalFuncPtr)(void *normal);
	GLboolean NormalEnabled;

	GLint ColorSize;
	GLenum ColorType;
	GLsizei ColorStride;		/* user-specified stride */
	GLsizei ColorStrideB;		/* actual stride in bytes */
	void *ColorPtr;
        void (*ColorFuncPtr)(void *color);
	GLboolean ColorEnabled;

	GLenum IndexType;
	GLsizei IndexStride;		/* user-specified stride */
	GLsizei IndexStrideB;		/* actual stride in bytes */
	void *IndexPtr;
        void (*IndexFuncPtr)(void *index);
	GLboolean IndexEnabled;

	GLint TexCoordSize[MAX_TEX_SETS];
	GLenum TexCoordType[MAX_TEX_SETS];
	GLsizei TexCoordStride[MAX_TEX_SETS];	/* user-specified stride */
	GLsizei TexCoordStrideB[MAX_TEX_SETS];	/* actual stride in bytes */
	void *TexCoordPtr[MAX_TEX_SETS];
	GLboolean TexCoordEnabled[MAX_TEX_SETS];
	GLint TexCoordInterleaveFactor;
        void (*TexCoordFuncPtr)(void *texcoord);

	GLsizei EdgeFlagStride;		/* user-specified stride */
	GLsizei EdgeFlagStrideB;	/* actual stride in bytes */
	GLboolean *EdgeFlagPtr;
        void (*EdgeFlagFuncPtr)(void *edges);
	GLboolean EdgeFlagEnabled;
};

#define _GLX_UNKNOWN  0
#define _GLX_DIRECT   1
#define _GLX_INDIRECT 2

typedef struct GLContext {
    struct gl_api_table API;

    GLuint    ContextType;
    GLboolean CompileFlag;

    char* bufferP;
    char* bufferStart;

    /* data for Render requests */
    int bufferSize;
    char* bufferRenderEnd;

    /* data for LargeRender requests */
    int bufferLargeSize;
    char* bufferLargeRenderEnd;

    /* Check if we need workarounds for SGI host */
    GLboolean SGIhost;

    /* keep track of what Vertex Arrays are enabled */
    GLubyte enabled_varrays;

    GLboolean isRenderLargeReq;
    GLint     largeReqMaxDataLen;
    GLint     largeReqTotal;
    GLint     largeReqNum;
    GLint     largeReqDataLen;

    Display* dpy;
    GLX_CONTEXT contextID;
    GLX_CONTEXT_TAG contextTag;
    GLXDrawable drawable;
    GLboolean need_unpacking;

    /** imported from core Mesa library **/
    /* Client state - GL_EXT_multitexture */
    GLuint TexCoordSet;             /* Target of glTexCoord() functions */

    /* Client attribute stack */
    GLuint ClientAttribStackDepth;
    struct gl_attrib_node *ClientAttribStack[MAX_CLIENT_ATTRIB_STACK_DEPTH];

    /* Client attribute groups */
    GLuint num_enabled_arrays;
    struct gl_array_attrib          Array;  /* Vertex arrays */
    struct gl_pixelstore_attrib     Pack;   /* Pixel packing */
    struct gl_pixelstore_attrib     Unpack; /* Pixel unpacking */
    GLuint NewState;        /* bitwise OR of NEW_* flags */

    GLfloat* feedback_buffer;
    GLint feedback_buffer_size;
    GLuint* selection_buffer;
    GLint selection_buffer_size;

    GLenum ErrorValue;
    GLenum rendermode;

} GLContext;

extern GLContext* GLCurrent;

typedef struct GLVisualInfo {
    VisualID visualid;
    int class;
    int buffer_size;
    int level;
    int rgba;
    int doublebuffer;
    int stereo;
    int aux_buffers;
    int red_size;
    int green_size;
    int blue_size;
    int alpha_size;
    int depth_size;
    int stencil_size;
    int accum_red_size;
    int accum_green_size;
    int accum_blue_size;
    int accum_alpha_size;
} GLVisualInfo;

typedef struct GLScreenInfo {
    int numGLVisuals;
    GLVisualInfo* visualInfo;
} GLScreenInfo;

typedef struct GLDisplayPrivate {
    int hasExtension;
    int numScreens;
    GLScreenInfo* screenInfo;
} GLDisplayPrivate;

#endif
