#include <stdio.h>
#include <dlfcn.h>

#include "glx_symbols.h"
#include "mga.h"
#include "mgasymbols.h"


static unsigned char *MGAMMIOBase;
static MGARamdacRec MGAdac;		
static pciTagRec MGAPciTag;
static int MGAchipset;
static int MGAydstorg;
static Bool MGAUsePCIRetry;

int mgaInstallLocalSymbols( void )
{
   glxsym.MGAMMIOBase = &MGAMMIOBase;
   glxsym.MGAdac = &MGAdac;		
   glxsym.MGAPciTag = &MGAPciTag;
   glxsym.MGAchipset = &MGAchipset;
   glxsym.MGAydstorg = &MGAydstorg;
   glxsym.MGAUsePCIRetry = &MGAUsePCIRetry;

   return glxInstallLocalSVGASymbols();
}

static int any_error;
static void *my_dlsym(void *handle, const char *name)
{
   void *tmp = dlsym(handle, name);
   char *error;
   if ((error = dlerror()) != 0) {
      fputs(error, stderr);
      any_error = 1;
      return 0;
   }
   return tmp;
}

int mgaHookServerSymbols( void *handle )
{
   glxsym.MGAMMIOBase = my_dlsym(handle, "MGAMMIOBase");
   glxsym.MGAdac = my_dlsym(handle, "MGAdac");		
   glxsym.MGAPciTag = my_dlsym(handle, "MGAPciTag");
   glxsym.MGAchipset = my_dlsym(handle, "MGAchipset");
   glxsym.MGAydstorg = my_dlsym(handle, "MGAydstorg");
   glxsym.MGAUsePCIRetry = my_dlsym(handle, "MGAUsePCIRetry");

   if (!any_error) 
      ErrorF("Sucessfully initialized mga driver symbols\n");
   else
      ErrorF("MGA driver disabled due to missing symbols\n");

   return !any_error;
}
